using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using CFW.Util;
using CFW.FieldProperties;
using CFW.Database;

namespace Taskman2.SqlServer.Models.Base
{
    /// <summary>
    /// table USERS Field`
    /// </summary>
    [Serializable()]
    public class UsersTableRow : CFW.Models.Entity,ICloneable
    {
        ///<summary>[USER_ID]</summary>
        protected string _userId;
        ///<summary>[USER_ID]</summary>
        public string userId{
            get{return _userId;}
            set{_userId = value;}
        }
        ///<summary>[USER_NAME]</summary>
        protected string _userName;
        ///<summary>[USER_NAME]</summary>
        public string userName{
            get{return _userName;}
            set{_userName = value;}
        }
        ///<summary>[PASSWORD]</summary>
        protected string _password;
        ///<summary>[PASSWORD]</summary>
        public string password{
            get{return _password;}
            set{_password = value;}
        }
        ///<summary>[CREATED_BY]</summary>
        protected string _createdBy;
        ///<summary>[CREATED_BY]</summary>
        public string createdBy{
            get{return _createdBy;}
            set{_createdBy = value;}
        }
        ///<summary>[CREATED_AT]</summary>
        protected DateTime? _createdAt;
        ///<summary>[CREATED_AT]</summary>
        public DateTime? createdAt{
            get{return _createdAt;}
            set{_createdAt = value;}
        }
        ///<summary>[MODIFIED_BY]</summary>
        protected string _modifiedBy;
        ///<summary>[MODIFIED_BY]</summary>
        public string modifiedBy{
            get{return _modifiedBy;}
            set{_modifiedBy = value;}
        }
        ///<summary>[MODIFIED_AT]</summary>
        protected DateTime? _modifiedAt;
        ///<summary>[MODIFIED_AT]</summary>
        public DateTime? modifiedAt{
            get{return _modifiedAt;}
            set{_modifiedAt = value;}
        }
        ///<summary>[DELETED]</summary>
        protected Int32 _deleted;
        ///<summary>[DELETED]</summary>
        public Int32 deleted{
            get{return _deleted;}
            set{_deleted = value;}
        }
        
        /// <summary>
        /// default construct 
        /// </summary>
        public UsersTableRow() : base()
        {
            this._userId = "";
            this._userName = "";
            this._password = "";
            this._createdBy = "system";
            this._createdAt = null;
            this._modifiedBy = "system";
            this._modifiedAt = null;
            this._deleted = 0;
            
        }
        
        /// <summary>
        /// 񖼂w肵Ēlݒ
        /// </summary>
        /// <param name="name"></param>
        /// <param name="value">l</param>
        public override void SetValue(string name,object value)
        {
            if(name ==  "USER_ID"){ this._userId = StringUtil.StringValue( value );return; }
            if(name ==  "USER_NAME"){ this._userName = StringUtil.StringValue( value );return; }
            if(name ==  "PASSWORD"){ this._password = StringUtil.StringValue( value );return; }
            if(name ==  "CREATED_BY"){ this._createdBy = StringUtil.StringValue( value );return; }
            if(name ==  "CREATED_AT"){ this._createdAt = DateUtil.DateValue( value );return; }
            if(name ==  "MODIFIED_BY"){ this._modifiedBy = StringUtil.StringValue( value );return; }
            if(name ==  "MODIFIED_AT"){ this._modifiedAt = DateUtil.DateValue( value );return; }
            if(name ==  "DELETED"){ this._deleted = NumberUtil.Value<Int32>( value );return; }
            
        }
        /// <summary>
        /// 񖼂w肵Ēl擾
        /// </summary>
        /// <param name="name"></param>
        public override object GetValue(string name)
        {
            if(name ==  "USER_ID") return this._userId;
            if(name ==  "USER_NAME") return this._userName;
            if(name ==  "PASSWORD") return this._password;
            if(name ==  "CREATED_BY") return this._createdBy;
            if(name ==  "CREATED_AT") return this._createdAt;
            if(name ==  "MODIFIED_BY") return this._modifiedBy;
            if(name ==  "MODIFIED_AT") return this._modifiedAt;
            if(name ==  "DELETED") return this._deleted;
            
            return null;
        }
        
        /// <summary>
        /// N[
        /// </summary>
        /// <return >̃IuWFNg̃N[</return>
        public virtual object Clone()
        {
            UsersTableRow clone = new UsersTableRow();
            clone.CopyFrom(this);
            return clone;
        }
        /// <summary>
        /// N[
        /// </summary>
        /// <return >̃IuWFNg̃N[</return>
        public virtual void CopyFrom(UsersTableRow source)
        {
            this.userId = source.userId;
            this.userName = source.userName;
            this.password = source.password;
            this.createdBy = source.createdBy;
            this.createdAt = source.createdAt;
            this.modifiedBy = source.modifiedBy;
            this.modifiedAt = source.modifiedAt;
            this.deleted = source.deleted;
            
            
            this.IsNew = source.IsNew;
            this.IsModified = source.IsModified;
            this.IsDeleted = source.IsDeleted;
            
        }
        /// <summary>
        /// DataRow炱̃IuWFNg̒lݒ肷B
        /// </summary>
        /// <param name="row">ǂݍDataRow</param>
        public override void Map(DataRow row)
        {
            DataColumnCollection cols = row.Table.Columns;
            if (cols.Contains("USER_ID")){ this._userId = StringUtil.StringValue(row["USER_ID"]); }
            if (cols.Contains("USER_NAME")){ this._userName = StringUtil.StringValue(row["USER_NAME"]); }
            if (cols.Contains("PASSWORD")){ this._password = StringUtil.StringValue(row["PASSWORD"]); }
            if (cols.Contains("CREATED_BY")){ this._createdBy = StringUtil.StringValue(row["CREATED_BY"]); }
            if (cols.Contains("CREATED_AT")){ this._createdAt = DateUtil.DateValue(row["CREATED_AT"]); }
            if (cols.Contains("MODIFIED_BY")){ this._modifiedBy = StringUtil.StringValue(row["MODIFIED_BY"]); }
            if (cols.Contains("MODIFIED_AT")){ this._modifiedAt = DateUtil.DateValue(row["MODIFIED_AT"]); }
            if (cols.Contains("DELETED")){ this._deleted = NumberUtil.Value<Int32>(row["DELETED"]); }
            
            this.IsNew = false;
        }
        /// <summary>
        /// DataRow炱̃IuWFNg̒lݒ肷B
        /// </summary>
        /// <param name="row">ǂݍDataRow</param>
        /// <param name="alias">Iɂʖ̃vtBbNX</param>
        public override void Map(DataRow row,string alias)
        {
            DataColumnCollection cols = row.Table.Columns;
            string columnName = "";
            columnName = BuildColumnName(alias, "USER_ID");if (cols.Contains(columnName)){ this._userId = StringUtil.StringValue(row[columnName]); }
            columnName = BuildColumnName(alias, "USER_NAME");if (cols.Contains(columnName)){ this._userName = StringUtil.StringValue(row[columnName]); }
            columnName = BuildColumnName(alias, "PASSWORD");if (cols.Contains(columnName)){ this._password = StringUtil.StringValue(row[columnName]); }
            columnName = BuildColumnName(alias, "CREATED_BY");if (cols.Contains(columnName)){ this._createdBy = StringUtil.StringValue(row[columnName]); }
            columnName = BuildColumnName(alias, "CREATED_AT");if (cols.Contains(columnName)){ this._createdAt = DateUtil.DateValue(row[columnName]); }
            columnName = BuildColumnName(alias, "MODIFIED_BY");if (cols.Contains(columnName)){ this._modifiedBy = StringUtil.StringValue(row[columnName]); }
            columnName = BuildColumnName(alias, "MODIFIED_AT");if (cols.Contains(columnName)){ this._modifiedAt = DateUtil.DateValue(row[columnName]); }
            columnName = BuildColumnName(alias, "DELETED");if (cols.Contains(columnName)){ this._deleted = NumberUtil.Value<Int32>(row[columnName]); }
            
            this.IsNew = false;
        }
        /// <summary>
        /// DataReader炱̃IuWFNg̒lݒ肷B
        /// </summary>
        /// <param name="reader">ǂݍ񂾃[_[</param>
        /// <remarks>DataReader̐Ãe[uŝ̗݂̒`ƓőÎݗL</remarks>
        public override void Map(IDataReader reader)
        {
            this._userId = StringUtil.StringValue(reader[0]);
            this._userName = StringUtil.StringValue(reader[1]);
            this._password = StringUtil.StringValue(reader[2]);
            this._createdBy = StringUtil.StringValue(reader[3]);
            this._createdAt = DateUtil.DateValue(reader[4]);
            this._modifiedBy = StringUtil.StringValue(reader[5]);
            this._modifiedAt = DateUtil.DateValue(reader[6]);
            this._deleted = NumberUtil.Value<Int32>(reader[7]);
            
            this.IsNew = false;
        }
    }

}