using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using CFW.Util;
using CFW.FieldProperties;
using CFW.Database;

namespace Taskman2.SqlServer.Models.Base
{
    /// <summary>
    /// table STATUSES Field`
    /// </summary>
    [Serializable()]
    public class StatusesTableRow : CFW.Models.Entity,ICloneable
    {
        ///<summary>[STATUS_ID]</summary>
        protected Int32 _statusId;
        ///<summary>[STATUS_ID]</summary>
        public Int32 statusId{
            get{return _statusId;}
            set{_statusId = value;}
        }
        ///<summary>[STATUS_NAME]</summary>
        protected string _statusName;
        ///<summary>[STATUS_NAME]</summary>
        public string statusName{
            get{return _statusName;}
            set{_statusName = value;}
        }
        ///<summary>[CLOSED]</summary>
        protected Int32 _closed;
        ///<summary>[CLOSED]</summary>
        public Int32 closed{
            get{return _closed;}
            set{_closed = value;}
        }
        ///<summary>[CREATED_BY]</summary>
        protected string _createdBy;
        ///<summary>[CREATED_BY]</summary>
        public string createdBy{
            get{return _createdBy;}
            set{_createdBy = value;}
        }
        ///<summary>[CREATED_AT]</summary>
        protected DateTime? _createdAt;
        ///<summary>[CREATED_AT]</summary>
        public DateTime? createdAt{
            get{return _createdAt;}
            set{_createdAt = value;}
        }
        ///<summary>[MODIFIED_BY]</summary>
        protected string _modifiedBy;
        ///<summary>[MODIFIED_BY]</summary>
        public string modifiedBy{
            get{return _modifiedBy;}
            set{_modifiedBy = value;}
        }
        ///<summary>[MODIFIED_AT]</summary>
        protected DateTime? _modifiedAt;
        ///<summary>[MODIFIED_AT]</summary>
        public DateTime? modifiedAt{
            get{return _modifiedAt;}
            set{_modifiedAt = value;}
        }
        ///<summary>[DELETED]</summary>
        protected Int32 _deleted;
        ///<summary>[DELETED]</summary>
        public Int32 deleted{
            get{return _deleted;}
            set{_deleted = value;}
        }
        
        /// <summary>
        /// default construct 
        /// </summary>
        public StatusesTableRow() : base()
        {
            this._statusId = 0;
            this._statusName = "";
            this._closed = 0;
            this._createdBy = "system";
            this._createdAt = null;
            this._modifiedBy = "system";
            this._modifiedAt = null;
            this._deleted = 0;
            
        }
        
        /// <summary>
        /// 񖼂w肵Ēlݒ
        /// </summary>
        /// <param name="name"></param>
        /// <param name="value">l</param>
        public override void SetValue(string name,object value)
        {
            if(name ==  "STATUS_ID"){ this._statusId = NumberUtil.Value<Int32>( value );return; }
            if(name ==  "STATUS_NAME"){ this._statusName = StringUtil.StringValue( value );return; }
            if(name ==  "CLOSED"){ this._closed = NumberUtil.Value<Int32>( value );return; }
            if(name ==  "CREATED_BY"){ this._createdBy = StringUtil.StringValue( value );return; }
            if(name ==  "CREATED_AT"){ this._createdAt = DateUtil.DateValue( value );return; }
            if(name ==  "MODIFIED_BY"){ this._modifiedBy = StringUtil.StringValue( value );return; }
            if(name ==  "MODIFIED_AT"){ this._modifiedAt = DateUtil.DateValue( value );return; }
            if(name ==  "DELETED"){ this._deleted = NumberUtil.Value<Int32>( value );return; }
            
        }
        /// <summary>
        /// 񖼂w肵Ēl擾
        /// </summary>
        /// <param name="name"></param>
        public override object GetValue(string name)
        {
            if(name ==  "STATUS_ID") return this._statusId;
            if(name ==  "STATUS_NAME") return this._statusName;
            if(name ==  "CLOSED") return this._closed;
            if(name ==  "CREATED_BY") return this._createdBy;
            if(name ==  "CREATED_AT") return this._createdAt;
            if(name ==  "MODIFIED_BY") return this._modifiedBy;
            if(name ==  "MODIFIED_AT") return this._modifiedAt;
            if(name ==  "DELETED") return this._deleted;
            
            return null;
        }
        
        /// <summary>
        /// N[
        /// </summary>
        /// <return >̃IuWFNg̃N[</return>
        public virtual object Clone()
        {
            StatusesTableRow clone = new StatusesTableRow();
            clone.CopyFrom(this);
            return clone;
        }
        /// <summary>
        /// N[
        /// </summary>
        /// <return >̃IuWFNg̃N[</return>
        public virtual void CopyFrom(StatusesTableRow source)
        {
            this.statusId = source.statusId;
            this.statusName = source.statusName;
            this.closed = source.closed;
            this.createdBy = source.createdBy;
            this.createdAt = source.createdAt;
            this.modifiedBy = source.modifiedBy;
            this.modifiedAt = source.modifiedAt;
            this.deleted = source.deleted;
            
            
            this.IsNew = source.IsNew;
            this.IsModified = source.IsModified;
            this.IsDeleted = source.IsDeleted;
            
        }
        /// <summary>
        /// DataRow炱̃IuWFNg̒lݒ肷B
        /// </summary>
        /// <param name="row">ǂݍDataRow</param>
        public override void Map(DataRow row)
        {
            DataColumnCollection cols = row.Table.Columns;
            if (cols.Contains("STATUS_ID")){ this._statusId = NumberUtil.Value<Int32>(row["STATUS_ID"]); }
            if (cols.Contains("STATUS_NAME")){ this._statusName = StringUtil.StringValue(row["STATUS_NAME"]); }
            if (cols.Contains("CLOSED")){ this._closed = NumberUtil.Value<Int32>(row["CLOSED"]); }
            if (cols.Contains("CREATED_BY")){ this._createdBy = StringUtil.StringValue(row["CREATED_BY"]); }
            if (cols.Contains("CREATED_AT")){ this._createdAt = DateUtil.DateValue(row["CREATED_AT"]); }
            if (cols.Contains("MODIFIED_BY")){ this._modifiedBy = StringUtil.StringValue(row["MODIFIED_BY"]); }
            if (cols.Contains("MODIFIED_AT")){ this._modifiedAt = DateUtil.DateValue(row["MODIFIED_AT"]); }
            if (cols.Contains("DELETED")){ this._deleted = NumberUtil.Value<Int32>(row["DELETED"]); }
            
            this.IsNew = false;
        }
        /// <summary>
        /// DataRow炱̃IuWFNg̒lݒ肷B
        /// </summary>
        /// <param name="row">ǂݍDataRow</param>
        /// <param name="alias">Iɂʖ̃vtBbNX</param>
        public override void Map(DataRow row,string alias)
        {
            DataColumnCollection cols = row.Table.Columns;
            string columnName = "";
            columnName = BuildColumnName(alias, "STATUS_ID");if (cols.Contains(columnName)){ this._statusId = NumberUtil.Value<Int32>(row[columnName]); }
            columnName = BuildColumnName(alias, "STATUS_NAME");if (cols.Contains(columnName)){ this._statusName = StringUtil.StringValue(row[columnName]); }
            columnName = BuildColumnName(alias, "CLOSED");if (cols.Contains(columnName)){ this._closed = NumberUtil.Value<Int32>(row[columnName]); }
            columnName = BuildColumnName(alias, "CREATED_BY");if (cols.Contains(columnName)){ this._createdBy = StringUtil.StringValue(row[columnName]); }
            columnName = BuildColumnName(alias, "CREATED_AT");if (cols.Contains(columnName)){ this._createdAt = DateUtil.DateValue(row[columnName]); }
            columnName = BuildColumnName(alias, "MODIFIED_BY");if (cols.Contains(columnName)){ this._modifiedBy = StringUtil.StringValue(row[columnName]); }
            columnName = BuildColumnName(alias, "MODIFIED_AT");if (cols.Contains(columnName)){ this._modifiedAt = DateUtil.DateValue(row[columnName]); }
            columnName = BuildColumnName(alias, "DELETED");if (cols.Contains(columnName)){ this._deleted = NumberUtil.Value<Int32>(row[columnName]); }
            
            this.IsNew = false;
        }
        /// <summary>
        /// DataReader炱̃IuWFNg̒lݒ肷B
        /// </summary>
        /// <param name="reader">ǂݍ񂾃[_[</param>
        /// <remarks>DataReader̐Ãe[uŝ̗݂̒`ƓőÎݗL</remarks>
        public override void Map(IDataReader reader)
        {
            this._statusId = NumberUtil.Value<Int32>(reader[0]);
            this._statusName = StringUtil.StringValue(reader[1]);
            this._closed = NumberUtil.Value<Int32>(reader[2]);
            this._createdBy = StringUtil.StringValue(reader[3]);
            this._createdAt = DateUtil.DateValue(reader[4]);
            this._modifiedBy = StringUtil.StringValue(reader[5]);
            this._modifiedAt = DateUtil.DateValue(reader[6]);
            this._deleted = NumberUtil.Value<Int32>(reader[7]);
            
            this.IsNew = false;
        }
    }

}