using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using CFW.Util;
using CFW.FieldProperties;
using CFW.Database;

namespace Taskman2.SqlServer.Models.Base
{
    /// <summary>
    /// table PRIORITIES Field`
    /// </summary>
    [Serializable()]
    public class PrioritiesTableRow : CFW.Models.Entity,ICloneable
    {
        ///<summary>[PRIORITY_ID]</summary>
        protected Int32 _priorityId;
        ///<summary>[PRIORITY_ID]</summary>
        public Int32 priorityId{
            get{return _priorityId;}
            set{_priorityId = value;}
        }
        ///<summary>[PRIORITY_NAME]</summary>
        protected string _priorityName;
        ///<summary>[PRIORITY_NAME]</summary>
        public string priorityName{
            get{return _priorityName;}
            set{_priorityName = value;}
        }
        ///<summary>[IS_DEFAULT]</summary>
        protected System.Nullable<Int32> _isDefault;
        ///<summary>[IS_DEFAULT]</summary>
        public System.Nullable<Int32> isDefault{
            get{return _isDefault;}
            set{_isDefault = value;}
        }
        ///<summary>[CREATED_BY]</summary>
        protected string _createdBy;
        ///<summary>[CREATED_BY]</summary>
        public string createdBy{
            get{return _createdBy;}
            set{_createdBy = value;}
        }
        ///<summary>[CREATED_AT]</summary>
        protected DateTime? _createdAt;
        ///<summary>[CREATED_AT]</summary>
        public DateTime? createdAt{
            get{return _createdAt;}
            set{_createdAt = value;}
        }
        ///<summary>[MODIFIED_BY]</summary>
        protected string _modifiedBy;
        ///<summary>[MODIFIED_BY]</summary>
        public string modifiedBy{
            get{return _modifiedBy;}
            set{_modifiedBy = value;}
        }
        ///<summary>[MODIFIED_AT]</summary>
        protected DateTime? _modifiedAt;
        ///<summary>[MODIFIED_AT]</summary>
        public DateTime? modifiedAt{
            get{return _modifiedAt;}
            set{_modifiedAt = value;}
        }
        ///<summary>[DELETED]</summary>
        protected Int32 _deleted;
        ///<summary>[DELETED]</summary>
        public Int32 deleted{
            get{return _deleted;}
            set{_deleted = value;}
        }
        
        /// <summary>
        /// default construct 
        /// </summary>
        public PrioritiesTableRow() : base()
        {
            this._priorityId = 0;
            this._priorityName = "";
            this._isDefault = null;
            this._createdBy = "system";
            this._createdAt = null;
            this._modifiedBy = "system";
            this._modifiedAt = null;
            this._deleted = 0;
            
        }
        
        /// <summary>
        /// 񖼂w肵Ēlݒ
        /// </summary>
        /// <param name="name"></param>
        /// <param name="value">l</param>
        public override void SetValue(string name,object value)
        {
            if(name ==  "PRIORITY_ID"){ this._priorityId = NumberUtil.Value<Int32>( value );return; }
            if(name ==  "PRIORITY_NAME"){ this._priorityName = StringUtil.StringValue( value );return; }
            if(name ==  "IS_DEFAULT"){ this._isDefault = NumberUtil.Value<Int32?>( value );return; }
            if(name ==  "CREATED_BY"){ this._createdBy = StringUtil.StringValue( value );return; }
            if(name ==  "CREATED_AT"){ this._createdAt = DateUtil.DateValue( value );return; }
            if(name ==  "MODIFIED_BY"){ this._modifiedBy = StringUtil.StringValue( value );return; }
            if(name ==  "MODIFIED_AT"){ this._modifiedAt = DateUtil.DateValue( value );return; }
            if(name ==  "DELETED"){ this._deleted = NumberUtil.Value<Int32>( value );return; }
            
        }
        /// <summary>
        /// 񖼂w肵Ēl擾
        /// </summary>
        /// <param name="name"></param>
        public override object GetValue(string name)
        {
            if(name ==  "PRIORITY_ID") return this._priorityId;
            if(name ==  "PRIORITY_NAME") return this._priorityName;
            if(name ==  "IS_DEFAULT") return this._isDefault;
            if(name ==  "CREATED_BY") return this._createdBy;
            if(name ==  "CREATED_AT") return this._createdAt;
            if(name ==  "MODIFIED_BY") return this._modifiedBy;
            if(name ==  "MODIFIED_AT") return this._modifiedAt;
            if(name ==  "DELETED") return this._deleted;
            
            return null;
        }
        
        /// <summary>
        /// N[
        /// </summary>
        /// <return >̃IuWFNg̃N[</return>
        public virtual object Clone()
        {
            PrioritiesTableRow clone = new PrioritiesTableRow();
            clone.CopyFrom(this);
            return clone;
        }
        /// <summary>
        /// N[
        /// </summary>
        /// <return >̃IuWFNg̃N[</return>
        public virtual void CopyFrom(PrioritiesTableRow source)
        {
            this.priorityId = source.priorityId;
            this.priorityName = source.priorityName;
            this.isDefault = source.isDefault;
            this.createdBy = source.createdBy;
            this.createdAt = source.createdAt;
            this.modifiedBy = source.modifiedBy;
            this.modifiedAt = source.modifiedAt;
            this.deleted = source.deleted;
            
            
            this.IsNew = source.IsNew;
            this.IsModified = source.IsModified;
            this.IsDeleted = source.IsDeleted;
            
        }
        /// <summary>
        /// DataRow炱̃IuWFNg̒lݒ肷B
        /// </summary>
        /// <param name="row">ǂݍDataRow</param>
        public override void Map(DataRow row)
        {
            DataColumnCollection cols = row.Table.Columns;
            if (cols.Contains("PRIORITY_ID")){ this._priorityId = NumberUtil.Value<Int32>(row["PRIORITY_ID"]); }
            if (cols.Contains("PRIORITY_NAME")){ this._priorityName = StringUtil.StringValue(row["PRIORITY_NAME"]); }
            if (cols.Contains("IS_DEFAULT")){ this._isDefault = NumberUtil.Value<Int32?>(row["IS_DEFAULT"]); }
            if (cols.Contains("CREATED_BY")){ this._createdBy = StringUtil.StringValue(row["CREATED_BY"]); }
            if (cols.Contains("CREATED_AT")){ this._createdAt = DateUtil.DateValue(row["CREATED_AT"]); }
            if (cols.Contains("MODIFIED_BY")){ this._modifiedBy = StringUtil.StringValue(row["MODIFIED_BY"]); }
            if (cols.Contains("MODIFIED_AT")){ this._modifiedAt = DateUtil.DateValue(row["MODIFIED_AT"]); }
            if (cols.Contains("DELETED")){ this._deleted = NumberUtil.Value<Int32>(row["DELETED"]); }
            
            this.IsNew = false;
        }
        /// <summary>
        /// DataRow炱̃IuWFNg̒lݒ肷B
        /// </summary>
        /// <param name="row">ǂݍDataRow</param>
        /// <param name="alias">Iɂʖ̃vtBbNX</param>
        public override void Map(DataRow row,string alias)
        {
            DataColumnCollection cols = row.Table.Columns;
            string columnName = "";
            columnName = BuildColumnName(alias, "PRIORITY_ID");if (cols.Contains(columnName)){ this._priorityId = NumberUtil.Value<Int32>(row[columnName]); }
            columnName = BuildColumnName(alias, "PRIORITY_NAME");if (cols.Contains(columnName)){ this._priorityName = StringUtil.StringValue(row[columnName]); }
            columnName = BuildColumnName(alias, "IS_DEFAULT");if (cols.Contains(columnName)){ this._isDefault = NumberUtil.Value<Int32?>(row[columnName]); }
            columnName = BuildColumnName(alias, "CREATED_BY");if (cols.Contains(columnName)){ this._createdBy = StringUtil.StringValue(row[columnName]); }
            columnName = BuildColumnName(alias, "CREATED_AT");if (cols.Contains(columnName)){ this._createdAt = DateUtil.DateValue(row[columnName]); }
            columnName = BuildColumnName(alias, "MODIFIED_BY");if (cols.Contains(columnName)){ this._modifiedBy = StringUtil.StringValue(row[columnName]); }
            columnName = BuildColumnName(alias, "MODIFIED_AT");if (cols.Contains(columnName)){ this._modifiedAt = DateUtil.DateValue(row[columnName]); }
            columnName = BuildColumnName(alias, "DELETED");if (cols.Contains(columnName)){ this._deleted = NumberUtil.Value<Int32>(row[columnName]); }
            
            this.IsNew = false;
        }
        /// <summary>
        /// DataReader炱̃IuWFNg̒lݒ肷B
        /// </summary>
        /// <param name="reader">ǂݍ񂾃[_[</param>
        /// <remarks>DataReader̐Ãe[uŝ̗݂̒`ƓőÎݗL</remarks>
        public override void Map(IDataReader reader)
        {
            this._priorityId = NumberUtil.Value<Int32>(reader[0]);
            this._priorityName = StringUtil.StringValue(reader[1]);
            this._isDefault = NumberUtil.Value<Int32?>(reader[2]);
            this._createdBy = StringUtil.StringValue(reader[3]);
            this._createdAt = DateUtil.DateValue(reader[4]);
            this._modifiedBy = StringUtil.StringValue(reader[5]);
            this._modifiedAt = DateUtil.DateValue(reader[6]);
            this._deleted = NumberUtil.Value<Int32>(reader[7]);
            
            this.IsNew = false;
        }
    }

}