using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using CFW.Util;
using CFW.Models;
using CFW.FieldProperties;
using CFW.Database;
using CFW.Database.Expressions;
using CFW.Database.CommandBuilder;
using CFW.Database.Oracle;
using ODP = Oracle.DataAccess.Client;
using ODPTypes = Oracle.DataAccess.Types;

namespace Taskman2.Oracle.Models 
{
    /// <summary>
    /// Tasks f`
    /// </summary>
    [Serializable()]
	public class TasksModel : DbModel<TasksEntity,TasksProperty>
	{
        Random rnd = new Random();
        /// <summary>
        /// default construct  
        /// </summary>
        public TasksModel() : base()
        {
        }
        /// <summary>
        /// ̐ڑgp\z
        /// </summary>
        /// <param name="connection">̐ڑBJĂO</param>
        public TasksModel(Connection connection) : base(connection)
        {
        }
        /// <summary>
        /// ̐ڑAvpeBgp\z
        /// </summary>
        /// <param name="connection">̐ڑBJĂO</param>
        /// <param name="property">̃vpeB</param>
        public TasksModel(Connection connection, TasksProperty property) : base(connection,property)
        {
        }

        public int generateRandom()
        {
            try
            {
                this.connect("oracle");
                int startId = generateId();
                List<TasksEntity> tasks = new List<TasksEntity>();
                for (int i = 0; i < 100; i++)
                {
                    tasks.Add(generateRandomItem(startId + i));
                }
                this.save(tasks);

                return 100;

            }
            finally
            {
                this.disconnect();
            }
        }
        private TasksEntity generateRandomItem(int id)
        {
            try
            {
                this.connect("oracle");

                TasksEntity newTask = new TasksEntity();
                newTask.taskId = id;
                newTask.statusId = new int[] { 10, 20, 80, 99 }[rnd.Next(0, 3)];
                newTask.categoryId = rnd.Next(1, 6);
                newTask.priorityId = rnd.Next(1, 5);
                newTask.subject = "test task " + newTask.taskId.ToString();
                newTask.description = "description of test task " + newTask.taskId.ToString();
                newTask.IsNew = true;
                newTask.IsModified = true;

                return newTask;

            }
            finally
            {
                this.disconnect();
            }

        }
        private int generateId()
        {
            try
            {
                this.connect("oracle");

                SelectCommandBuilder builder = new SelectCommandBuilder(this.connection);
                builder.from("TASKS")
                    .select("nvl(MAX(TASK_ID),0) + 1", "newId");

                DataSet result = builder.getCommand().ExecuteQuery(this.connection);
                return NumberUtil.Value<int>(result.Tables[0].Rows[0][0]);

            }
            finally
            {
                this.disconnect();
            }
        }
        public DataSet findAll()
        {
            try
            {
                this.connect("oracle");

                TasksProperty tasksProperty = new TasksProperty();
                StatusesProperty statusesProperty = new StatusesProperty();
                PrioritiesProperty prioritiesProperty = new PrioritiesProperty();
                CategoriesProperty categoriesProperty = new CategoriesProperty();

                ExpressionFactory ef = connection.getExpressionFactory();

                SelectCommandBuilder builder = new SelectCommandBuilder(this.connection);
                builder.from(tasksProperty)
                    .joinLeft("STATUSES", ef.relation(tasksProperty.statusId, statusesProperty.statusId))
                    .joinLeft("PRIORITIES", ef.relation(tasksProperty.priorityId, prioritiesProperty.priorityId))
                    .joinLeft("CATEGORIES", ef.relation(tasksProperty.categoryId, categoriesProperty.categoryId))
                    .select(tasksProperty.Fields())
                    .select(statusesProperty.Fields())
                    .select(prioritiesProperty.Fields())
                    .select(categoriesProperty.Fields())
                    .where(ef.columnValue(statusesProperty.closed, NumberUtil.BoolToInt( false )))
                    .orderBy(tasksProperty.categoryId, "ASC")
                    .orderBy(tasksProperty.priorityId, "DESC");


                DataSet result = builder.getCommand().ExecuteQuery(this.connection);
                return result;

            }
            finally
            {
                this.disconnect();
            }
        }
        public List<TasksEntity> findAll2()
        {
            try
            {
                this.connect("oracle");

                TasksProperty tasksProperty = new TasksProperty();
                StatusesProperty statusesProperty = new StatusesProperty();
                PrioritiesProperty prioritiesProperty = new PrioritiesProperty();
                CategoriesProperty categoriesProperty = new CategoriesProperty();
                ExpressionFactory ef = connection.getExpressionFactory();

                AssociationSelect<TasksEntity> select = new AssociationSelect<TasksEntity>(connection);
                select.from(tasksProperty);
                select.associate(
                    new Association("status"
                        , Association.Multiplicity.TO_ONE
                        , statusesProperty
                        , ef.relation(tasksProperty.statusId, statusesProperty.statusId)
                    ),
                    new Association("priority"
                        , Association.Multiplicity.TO_ONE
                        , prioritiesProperty
                        , ef.relation(tasksProperty.priorityId, prioritiesProperty.priorityId)
                    ),
                    new Association("category"
                        , Association.Multiplicity.TO_ONE
                        , categoriesProperty
                        , ef.relation(tasksProperty.categoryId, categoriesProperty.categoryId)
                    )

                );

                List<TasksEntity> result = select.queryAsEntity();
                return result;

            }
            finally
            {
                this.disconnect();
            }
        }
        public void mapCategory(Entity entity, DataRow row, string alias)
        {
            TasksEntity task = entity as TasksEntity;
            CategoriesEntity category = new CategoriesEntity();
            category.Map(row, alias);
            task.category = category;

        }
        public void mapStatus(Entity entity, DataRow row, string alias)
        {
            TasksEntity task = entity as TasksEntity;
            StatusesEntity status = new StatusesEntity();
            status.Map(row, alias);
            task.status = status;

        }
        public StatusesEntity getStatus(int taskId)
        {
            try
            {
                this.connect("oracle");

                Command command = new Command("begin Tasks_getStatus(:taskId,:statusId,:statusName); end;");
                command.input(new Parameter(":taskId",DbType.Int32, taskId))
                    .output(new Parameter(":statusId", DbType.Int32,null,10,0))
                    .output(new Parameter(":statusName", DbType.String, null, 100,0));

                int result = command.ExecuteUpdate(this.connection);
                if (result == 0)
                {
                    return null;
                }
                StatusesEntity status = new StatusesEntity();
                status.statusId = NumberUtil.Value<int>(command.FindParameter(":statusId").ParameterValue);
                status.statusName = StringUtil.StringValue(command.FindParameter(":statusName").ParameterValue);
                return status;

            }
            finally
            {
                this.disconnect();
            }
        }
        public DataSet getClosed(int taskId)
        {
            try
            {
                this.connect("oracle");

                Command command = new Command("begin GET_CLOSED.GET(:taskId,:result); end;");
                command.input(new Parameter(":taskId", DbType.Int32, taskId))
                    .output(new OracleParameter(":result",ODP.OracleDbType.RefCursor));

                DataSet result = command.ExecuteQuery(this.connection);
                return result;

            }
            finally
            {
                this.disconnect();
            }
        }

	}

}