using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using CFW.Util;
using CFW.FieldProperties;
using CFW.Database;

namespace Taskman2.Oracle.Models.Base
{
    /// <summary>
    /// table USERSɑΉtB[hvpeB
    /// </summary>
    [Serializable()]
    public class UsersTableProperty : CFW.Models.EntityProperty
    {
        ///<summary>[USER_ID]</summary>
        public FieldProperty userId;
        ///<summary>[USER_NAME]</summary>
        public FieldProperty userName;
        ///<summary>[PASSWORD]</summary>
        public FieldProperty password;
        ///<summary>[CREATED_BY]</summary>
        public FieldProperty createdBy;
        ///<summary>[CREATED_AT]</summary>
        public FieldProperty createdAt;
        ///<summary>[MODIFIED_BY]</summary>
        public FieldProperty modifiedBy;
        ///<summary>[MODIFIED_AT]</summary>
        public FieldProperty modifiedAt;
        ///<summary>[DELETED]</summary>
        public FieldProperty deleted;
        

        /// <summary>
        /// default construct
        /// </summary>
        public UsersTableProperty()
        {
            this.EntityName = "USERS";
            this.ModifiedAtField = "UPDATE_DATE";
            this.CreatedAtField = "CREATE_DATE";
            
            userId = FieldProperty.NewInstance("varchar", "USERS", "USER_ID","[USER_ID]", 16, 16, 0, false, "",true);
            userName = FieldProperty.NewInstance("varchar", "USERS", "USER_NAME","[USER_NAME]", 100, 100, 0, true, "",false);
            password = FieldProperty.NewInstance("varchar", "USERS", "PASSWORD","[PASSWORD]", 64, 64, 0, true, "",false);
            createdBy = FieldProperty.NewInstance("varchar", "USERS", "CREATED_BY","[CREATED_BY]", 16, 16, 0, false, "system",false);
            createdAt = FieldProperty.NewInstance("datetime", "USERS", "CREATED_AT","[CREATED_AT]", 16, 23, 3, false, null,false);
            modifiedBy = FieldProperty.NewInstance("varchar", "USERS", "MODIFIED_BY","[MODIFIED_BY]", 16, 16, 0, false, "system",false);
            modifiedAt = FieldProperty.NewInstance("datetime", "USERS", "MODIFIED_AT","[MODIFIED_AT]", 16, 23, 3, false, null,false);
            deleted = FieldProperty.NewInstance("decimal", "USERS", "DELETED", "[DELETED]", 4, 10, 0, false, 0, false);
            
        }

        /// <summary>
        /// Ce[^\gĊOCe[^B
        /// </summary>
        /// <returns>Ce[^</returns>
        public override IEnumerable<FieldProperty> Fields()
        {
            yield return this.userId;
            yield return this.userName;
            yield return this.password;
            yield return this.createdBy;
            yield return this.createdAt;
            yield return this.modifiedBy;
            yield return this.modifiedAt;
            yield return this.deleted;
            
        }
                /// <summary>
        /// Ce[^\gĊOCe[^B
        /// </summary>
        /// <returns>Ce[^</returns>
        public override IEnumerable<FieldProperty> PrimaryKeys()
        {
            yield return  this.userId;
            
        }
                
    }
}