using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using CFW.Util;
using CFW.FieldProperties;
using CFW.Database;

namespace Taskman2.Oracle.Models.Base
{
    /// <summary>
    /// table TASKSɑΉtB[hvpeB
    /// </summary>
    [Serializable()]
    public class TasksTableProperty : CFW.Models.EntityProperty
    {
        ///<summary>[TASK_ID]</summary>
        public FieldProperty taskId;
        ///<summary>[SUBJECT]</summary>
        public FieldProperty subject;
        ///<summary>[STATUS_ID]</summary>
        public FieldProperty statusId;
        ///<summary>[CATEGORY_ID]</summary>
        public FieldProperty categoryId;
        ///<summary>[PRIORITY_ID]</summary>
        public FieldProperty priorityId;
        ///<summary>[DESCRIPTION]</summary>
        public FieldProperty description;
        ///<summary>[CREATED_BY]</summary>
        public FieldProperty createdBy;
        ///<summary>[CREATED_AT]</summary>
        public FieldProperty createdAt;
        ///<summary>[MODIFIED_BY]</summary>
        public FieldProperty modifiedBy;
        ///<summary>[MODIFIED_AT]</summary>
        public FieldProperty modifiedAt;
        ///<summary>[DELETED]</summary>
        public FieldProperty deleted;
        

        /// <summary>
        /// default construct
        /// </summary>
        public TasksTableProperty()
        {
            this.EntityName = "TASKS";
            this.ModifiedAtField = "UPDATE_DATE";
            this.CreatedAtField = "CREATE_DATE";

            taskId = FieldProperty.NewInstance("decimal", "TASKS", "TASK_ID", "[TASK_ID]", 4, 10, 0, false, 0, true);
            subject = FieldProperty.NewInstance("varchar", "TASKS", "SUBJECT","[SUBJECT]", 200, 200, 0, false, "",false);
            statusId = FieldProperty.NewInstance("decimal", "TASKS", "STATUS_ID", "[STATUS_ID]", 4, 10, 0, false, 0, false);
            categoryId = FieldProperty.NewInstance("decimal", "TASKS", "CATEGORY_ID", "[CATEGORY_ID]", 4, 10, 0, true, null, false);
            priorityId = FieldProperty.NewInstance("decimal", "TASKS", "PRIORITY_ID", "[PRIORITY_ID]", 4, 10, 0, false, 0, false);
            description = FieldProperty.NewInstance("varchar", "TASKS", "DESCRIPTION","[DESCRIPTION]", 1000, 1000, 0, true, "",false);
            createdBy = FieldProperty.NewInstance("varchar", "TASKS", "CREATED_BY","[CREATED_BY]", 16, 16, 0, false, "system",false);
            createdAt = FieldProperty.NewInstance("datetime", "TASKS", "CREATED_AT","[CREATED_AT]", 16, 23, 3, false, null,false);
            modifiedBy = FieldProperty.NewInstance("varchar", "TASKS", "MODIFIED_BY","[MODIFIED_BY]", 16, 16, 0, false, "system",false);
            modifiedAt = FieldProperty.NewInstance("datetime", "TASKS", "MODIFIED_AT","[MODIFIED_AT]", 16, 23, 3, false, null,false);
            deleted = FieldProperty.NewInstance("decimal", "TASKS", "DELETED", "[DELETED]", 4, 10, 0, false, 0, false);
            
        }

        /// <summary>
        /// Ce[^\gĊOCe[^B
        /// </summary>
        /// <returns>Ce[^</returns>
        public override IEnumerable<FieldProperty> Fields()
        {
            yield return this.taskId;
            yield return this.subject;
            yield return this.statusId;
            yield return this.categoryId;
            yield return this.priorityId;
            yield return this.description;
            yield return this.createdBy;
            yield return this.createdAt;
            yield return this.modifiedBy;
            yield return this.modifiedAt;
            yield return this.deleted;
            
        }
                /// <summary>
        /// Ce[^\gĊOCe[^B
        /// </summary>
        /// <returns>Ce[^</returns>
        public override IEnumerable<FieldProperty> PrimaryKeys()
        {
            yield return  this.taskId;
            
        }
                
    }
}