using System;
using System.Collections.Generic;
using System.Text;
using CFW.Forms;
using CFW.Forms.Filters;
using CFW.Util;
using CFW.Models;
using Taskman2.Oracle.Models.Base;

namespace Taskman2.Oracle.Windows.Forms.Adapters.Base
{
    /// <summary>
    /// table PRIORITIES Field`
    /// </summary>
    public class PrioritiesTableFormAdapter : CFW.Forms.FormAdapter
	{
		private PrioritiesTableRow theEntity;

		///<summary>[PRIORITY_ID]</summary>
		public FormAdapterElement priorityId;
		///<summary>[PRIORITY_NAME]</summary>
		public FormAdapterElement priorityName;
		///<summary>[IS_DEFAULT]</summary>
		public FormAdapterElement isDefault;
		///<summary>[CREATED_BY]</summary>
		public FormAdapterElement createdBy;
		///<summary>[CREATED_AT]</summary>
		public FormAdapterElement createdAt;
		///<summary>[MODIFIED_BY]</summary>
		public FormAdapterElement modifiedBy;
		///<summary>[MODIFIED_AT]</summary>
		public FormAdapterElement modifiedAt;
		///<summary>[DELETED]</summary>
		public FormAdapterElement deleted;
		

		/// <summary>݂̃f[^\[X擾
		/// </summary>
        public override Entity GetEntity()
        {
            return this.theEntity;
        }
		/// <summary>\̍XV
		/// </summary>
        public override void RenderView()
        {
			if(this.priorityId != null) this.priorityId.Render();
			if(this.priorityName != null) this.priorityName.Render();
			if(this.isDefault != null) this.isDefault.Render();
			if(this.createdBy != null) this.createdBy.Render();
			if(this.createdAt != null) this.createdAt.Render();
			if(this.modifiedBy != null) this.modifiedBy.Render();
			if(this.modifiedAt != null) this.modifiedAt.Render();
			if(this.deleted != null) this.deleted.Render();
			
        }

		/// <summary>̃A_v^[f[^ݒ
		/// </summary>
        /// <param name="dataSource">̃A_v^[f[^</param>
        public override void SetEntity(Entity entity)
        {
        	this.theEntity = (PrioritiesTableRow)entity;
			if(this.priorityId != null) this.priorityId.SetValue(this.theEntity.priorityId);
			if(this.priorityName != null) this.priorityName.SetValue(this.theEntity.priorityName);
			if(this.isDefault != null) this.isDefault.SetValue(this.theEntity.isDefault);
			if(this.createdBy != null) this.createdBy.SetValue(this.theEntity.createdBy);
			if(this.createdAt != null) this.createdAt.SetValue(this.theEntity.createdAt);
			if(this.modifiedBy != null) this.modifiedBy.SetValue(this.theEntity.modifiedBy);
			if(this.modifiedAt != null) this.modifiedAt.SetValue(this.theEntity.modifiedAt);
			if(this.deleted != null) this.deleted.SetValue(this.theEntity.deleted);
			

        }

		/// <summary>UI͂ꂽef[^\[XɎ荞
		/// </summary>
        public override void UpdateEntity()
        {
			if(this.priorityId != null) this.theEntity.priorityId = NumberUtil.Value<Int32>(this.priorityId.GetValue());
			if(this.priorityName != null) this.theEntity.priorityName = StringUtil.StringValue(this.priorityName.GetValue());
			if(this.isDefault != null) this.theEntity.isDefault = NumberUtil.Value<Int32?>(this.isDefault.GetValue());
			if(this.createdBy != null) this.theEntity.createdBy = StringUtil.StringValue(this.createdBy.GetValue());
			if(this.createdAt != null) this.theEntity.createdAt = DateUtil.DateValue(this.createdAt.GetValue());
			if(this.modifiedBy != null) this.theEntity.modifiedBy = StringUtil.StringValue(this.modifiedBy.GetValue());
			if(this.modifiedAt != null) this.theEntity.modifiedAt = DateUtil.DateValue(this.modifiedAt.GetValue());
			if(this.deleted != null) this.theEntity.deleted = NumberUtil.Value<Int32>(this.deleted.GetValue());
			
        }

		/// <summary>UI͂ꂽe荞
		/// </summary>
        public override void UpdateFields()
        {
			if(this.priorityId != null) this.priorityId.UpdateField();
			if(this.priorityName != null) this.priorityName.UpdateField();
			if(this.isDefault != null) this.isDefault.UpdateField();
			if(this.createdBy != null) this.createdBy.UpdateField();
			if(this.createdAt != null) this.createdAt.UpdateField();
			if(this.modifiedBy != null) this.modifiedBy.UpdateField();
			if(this.modifiedAt != null) this.modifiedAt.UpdateField();
			if(this.deleted != null) this.deleted.UpdateField();
			
        }

		/// <summary>͓e؂
		/// ؃G[MessagesXgɑSẴG[B
		/// </summary>
        public override bool Validate()
        {
            bool valid = true;
			
			if(this.priorityId != null){
			    if(!this.priorityId.Validate()){
				    valid = false;
				    this.messages.Add(this.priorityId.ErrorMessage);
			    }
			}
			
			if(this.priorityName != null){
			    if(!this.priorityName.Validate()){
				    valid = false;
				    this.messages.Add(this.priorityName.ErrorMessage);
			    }
			}
			
			if(this.isDefault != null){
			    if(!this.isDefault.Validate()){
				    valid = false;
				    this.messages.Add(this.isDefault.ErrorMessage);
			    }
			}
			
			if(this.createdBy != null){
			    if(!this.createdBy.Validate()){
				    valid = false;
				    this.messages.Add(this.createdBy.ErrorMessage);
			    }
			}
			
			if(this.createdAt != null){
			    if(!this.createdAt.Validate()){
				    valid = false;
				    this.messages.Add(this.createdAt.ErrorMessage);
			    }
			}
			
			if(this.modifiedBy != null){
			    if(!this.modifiedBy.Validate()){
				    valid = false;
				    this.messages.Add(this.modifiedBy.ErrorMessage);
			    }
			}
			
			if(this.modifiedAt != null){
			    if(!this.modifiedAt.Validate()){
				    valid = false;
				    this.messages.Add(this.modifiedAt.ErrorMessage);
			    }
			}
			
			if(this.deleted != null){
			    if(!this.deleted.Validate()){
				    valid = false;
				    this.messages.Add(this.deleted.ErrorMessage);
			    }
			}
			

            return valid;
        }
		
	}
/* 
    // initialize code sample
    // Form̃o[ɈȉǉB
    //     private PrioritiesFormAdapter formAdapter;
    //     private PrioritiesProperty property;
    //     private PrioritiesEntity property;
    // tB[hƓ̓Rg[킹B
    // 2(tB^[)͓KXtB[hɍ킹ĕύX
    formAdapter = new PrioritiesFormAdapter();

	
    formAdapter.priorityId= new TextBoxAdapterElement(
        priorityId,
        new CFW.Forms.Filters.StringFilter(property.priorityId),
        CFW.Validators.FieldValidator.GetInstance(property.priorityId)
    );
	
    formAdapter.priorityName= new TextBoxAdapterElement(
        priorityName,
        new CFW.Forms.Filters.StringFilter(property.priorityName),
        CFW.Validators.FieldValidator.GetInstance(property.priorityName)
    );
	
    formAdapter.isDefault= new TextBoxAdapterElement(
        isDefault,
        new CFW.Forms.Filters.StringFilter(property.isDefault),
        CFW.Validators.FieldValidator.GetInstance(property.isDefault)
    );
	
    formAdapter.createdBy= new TextBoxAdapterElement(
        createdBy,
        new CFW.Forms.Filters.StringFilter(property.createdBy),
        CFW.Validators.FieldValidator.GetInstance(property.createdBy)
    );
	
    formAdapter.createdAt= new TextBoxAdapterElement(
        createdAt,
        new CFW.Forms.Filters.StringFilter(property.createdAt),
        CFW.Validators.FieldValidator.GetInstance(property.createdAt)
    );
	
    formAdapter.modifiedBy= new TextBoxAdapterElement(
        modifiedBy,
        new CFW.Forms.Filters.StringFilter(property.modifiedBy),
        CFW.Validators.FieldValidator.GetInstance(property.modifiedBy)
    );
	
    formAdapter.modifiedAt= new TextBoxAdapterElement(
        modifiedAt,
        new CFW.Forms.Filters.StringFilter(property.modifiedAt),
        CFW.Validators.FieldValidator.GetInstance(property.modifiedAt)
    );
	
    formAdapter.deleted= new TextBoxAdapterElement(
        deleted,
        new CFW.Forms.Filters.StringFilter(property.deleted),
        CFW.Validators.FieldValidator.GetInstance(property.deleted)
    );
	
    formAdapter.SetEntity(entity);
    formAdapter.RenderView();
	

*/	

}