
/* Drop Tables */

DROP TABLE TASKS;
DROP TABLE CATEGORIES;
DROP TABLE PRIORITIES;
DROP TABLE STATUSES;
DROP TABLE USERS;




/* Create Tables */

CREATE TABLE CATEGORIES
(
	CATEGORY_ID NUMBER(10,0) NOT NULL,
	CATEGORY_NAME VARCHAR2(40),
	CREATED_BY VARCHAR2(16) DEFAULT 'system' NOT NULL,
	CREATED_AT DATE DEFAULT sysdate NOT NULL,
	MODIFIED_BY VARCHAR2(16) DEFAULT 'system' NOT NULL,
	MODIFIED_AT DATE DEFAULT sysdate NOT NULL,
	DELETED NUMBER(10,0) DEFAULT 0 NOT NULL,
	PRIMARY KEY (CATEGORY_ID)
);


CREATE TABLE PRIORITIES
(
	PRIORITY_ID NUMBER(10,0) NOT NULL,
	PRIORITY_NAME VARCHAR2(200),
	IS_DEFAULT NUMBER(10,0),
	CREATED_BY VARCHAR2(16) DEFAULT 'system' NOT NULL,
	CREATED_AT DATE DEFAULT sysdate NOT NULL,
	MODIFIED_BY VARCHAR2(16) DEFAULT 'system' NOT NULL,
	MODIFIED_AT DATE DEFAULT sysdate NOT NULL,
	DELETED NUMBER(10,0) DEFAULT 0 NOT NULL,
	PRIMARY KEY (PRIORITY_ID)
);


CREATE TABLE STATUSES
(
	STATUS_ID NUMBER(10,0) NOT NULL,
	STATUS_NAME VARCHAR2(40),
	CLOSED NUMBER(10,0) DEFAULT 0 NOT NULL,
	CREATED_BY VARCHAR2(16) DEFAULT 'system' NOT NULL,
	CREATED_AT DATE DEFAULT sysdate NOT NULL,
	MODIFIED_BY VARCHAR2(16) DEFAULT 'system' NOT NULL,
	MODIFIED_AT DATE DEFAULT sysdate NOT NULL,
	DELETED NUMBER(10,0) DEFAULT 0 NOT NULL,
	PRIMARY KEY (STATUS_ID)
);


CREATE TABLE TASKS
(
	TASK_ID NUMBER(10,0) NOT NULL,
	SUBJECT VARCHAR2(200) NOT NULL,
	STATUS_ID NUMBER(10,0) NOT NULL,
	CATEGORY_ID NUMBER(10,0),
	PRIORITY_ID NUMBER(10,0) NOT NULL,
	FROM_DATE DATE,
	TO_DATE DATE,
	DESCRIPTION VARCHAR2(1000),
	CREATED_BY VARCHAR2(16) DEFAULT 'system' NOT NULL,
	CREATED_AT DATE DEFAULT sysdate NOT NULL,
	MODIFIED_BY VARCHAR2(16) DEFAULT 'system' NOT NULL,
	MODIFIED_AT DATE DEFAULT sysdate NOT NULL,
	DELETED NUMBER(10,0) DEFAULT 0 NOT NULL,
	PRIMARY KEY (TASK_ID)
);


CREATE TABLE USERS
(
	USER_ID VARCHAR2(16) NOT NULL,
	USER_NAME VARCHAR2(100),
	PASSWORD VARCHAR2(64),
	CREATED_BY VARCHAR2(16) DEFAULT 'system' NOT NULL,
	CREATED_AT DATE DEFAULT sysdate NOT NULL,
	MODIFIED_BY VARCHAR2(16) DEFAULT 'system' NOT NULL,
	MODIFIED_AT DATE DEFAULT sysdate NOT NULL,
	DELETED NUMBER(10,0) DEFAULT 0 NOT NULL,
	PRIMARY KEY (USER_ID)
);
