using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using TaskManager.Models;
using CFW.Auth;
using TaskManager.Forms;
namespace TaskManager
{
    public partial class TaskMain : Form
    {
        List<TasksEntity> currentTasks;
        DateTime currentDate;
        TaskEdit editForm;
        TaskSearchConditionForm searchConditionForm;
        public TaskMain()
        {
            InitializeComponent();
            editForm = new TaskEdit();
            editForm.EditComplete = EditComplete;
            editForm.StartPosition = FormStartPosition.Manual;

            searchConditionForm = new TaskSearchConditionForm();

        }

        private void TaskMain_Load(object sender, EventArgs e)
        {
            currentDate = CFW.Util.DateUtil.Today();
            loadTaskList(currentDate);
            dataGridView1.AutoGenerateColumns = false;
            initializeView();
        }
        private void initializeView()
        {
            monthCalendar1.SelectionStart = currentDate;
            monthCalendar1.SelectionEnd = currentDate;

            updateTaskListView();

            AuthProvider p = AuthProviderFactory.GetInstance();
            Identity id = p.GetIdentity();
        }
        private void updateTaskListView()
        {
            dataGridView1.DataSource = currentTasks;
            dataGridView1.Refresh();
        }
        private void loadTaskList(DateTime date)
        {
            TasksModel model = new TasksModel();
            currentTasks = model.findIncomlete(date);

        }
        private void loadTaskListByCondition(TaskSearchCondition conditiondate)
        {
            TasksModel model = new TasksModel();
            currentTasks = model.findByCondition(conditiondate);

        }

        private void monthCalendar1_DateSelected(object sender, DateRangeEventArgs e)
        {
            currentDate = monthCalendar1.SelectionEnd;
            loadTaskList(currentDate);
            updateTaskListView();
        }

        private void newTaskButton_Click(object sender, EventArgs e)
        {
            Point p = this.Location;
            p.Offset(dataGridView1.Location);
            editForm.Location = p;

            editForm.New();
            editForm.Show();

        }

        private void button1_Click(object sender, EventArgs e)
        {
            KeyValueListTestForm form = new KeyValueListTestForm();
            form.Show();
        }

        private void editTaskButton_Click(object sender, EventArgs e)
        {
            Point p = this.Location;
            p.Offset(dataGridView1.Location);
            editForm.Location = p;

            TasksEntity entity = dataGridView1.SelectedRows[0].DataBoundItem as TasksEntity;
            editForm.Edit(entity.id);
            editForm.Show();
        }

        private void TaskMain_FormClosed(object sender, FormClosedEventArgs e)
        {
            editForm.Close();
            editForm.Dispose();

            searchConditionForm.Close();
            searchConditionForm.Dispose();
        }
        private void EditComplete()
        {
            loadTaskList(currentDate);
            updateTaskListView();

        }

        private void editSearchConditionButton_Click(object sender, EventArgs e)
        {
            DialogResult result = searchConditionForm.ShowDialog();
            if (result == DialogResult.OK)
            {
                loadTaskListByCondition(searchConditionForm.condition);
                updateTaskListView();
            }
           
        }

    }
}