using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using CFW.Util;
using CFW.FieldProperties;
using CFW.Database;
using TaskManager.Models.Base;

namespace TaskManager.Models
{
    /// <summary>
    /// Tasks GeBeB`
    /// </summary>
    [Serializable()]
	public class TasksEntity : TasksTableRow,ICloneable
	{

        private string _categoryName;

        public string categoryName
        {
            get {
                if (_category == null) return _categoryName;
                return _category.name;
            }
            set { _categoryName = value; }
        }
        private string _statusName;

        public string statusName
        {
            get {
                if (statuses.Count > 0) return statuses[0].name;
                return _statusName; 
            }
            set { _statusName = value; }
        }

        private CategoriesEntity _category;

        public CategoriesEntity category
        {
            get { return _category; }
            set { _category = value; }
        }
        private List<StatusesEntity> _statuses;

        public List<StatusesEntity> statuses
        {
            get { return _statuses; }
            set { _statuses = value; }
        }

        /// <summary>
        /// ftHg\z
        /// </summary>
        public TasksEntity() : base()
        {
            _categoryName = "";
            _statusName = "";
            category = null;
            statuses = new List<StatusesEntity>();

        }
	
        /// <summary>
        /// N[
        /// </summary>
        /// <return >̃IuWFNg̃N[</return>
        public override object Clone()
        {
            TasksEntity clone = new TasksEntity();
            clone.CopyFrom(this);
			
			//TODO: ɂ̃NX̓Ǝ̃N[

            return clone;
        }
        /// <summary>
        /// nꂽp[^IuWFNg̓ẽIuWFNgɃRs[B
        /// </summary>
        /// <param name="source">Rs[̃GeBeB</param>
        public virtual void CopyFrom(TasksEntity source)
        {
        	base.CopyFrom(source);

			//TODO: ɂ̃NX̓Ǝ̃Rs[
        }
        public bool isClosed
        {
            get {
                StatusesModel model = new StatusesModel();

                return model.isClosed(statusId); 
            }
        }
        public override void Map(DataRow row)
        {
            Map(row,"");
        }
        public override void Map(DataRow row, string alias)
        {
            string prefix = "";
            if (!string.IsNullOrEmpty(alias))
            {
                prefix = alias + "__";
            }
            DataColumnCollection cols = row.Table.Columns;
            if (cols.Contains(prefix + "STATUS_NAME")) { this._statusName = StringUtil.StringValue(row[prefix + "STATUS_NAME"]); }
            if (cols.Contains(prefix + "CATEGORY_NAME")) { this._categoryName = StringUtil.StringValue(row[prefix + "CATEGORY_NAME"]); }

            base.Map(row, alias);

        }
        public bool keyEquals(TasksEntity target)
        {
            if (target == null) return false;
            if (this.id != target.id) return false;
            // ...

            return true;

        }
        
	}

}