using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using CFW.Util;
using CFW.FieldProperties;
using CFW.Database;

namespace TaskManager.Models.Base
{
    /// <summary>
    /// table TASKSɑΉtB[hvpeB
    /// </summary>
    [Serializable()]
    public class TasksTableProperty : CFW.Models.EntityProperty
    {
		///<summary>[ID]</summary>
		public FieldProperty id;
		///<summary>[SUBJECT]</summary>
		public FieldProperty subject;
		///<summary>[STATUS_ID]</summary>
		public FieldProperty statusId;
		///<summary>[FROM_DATE]</summary>
		public FieldProperty fromDate;
		///<summary>[TO_DATE]</summary>
		public FieldProperty toDate;
		///<summary>[DESCRIPTION]</summary>
		public FieldProperty description;
		///<summary>[CREATED_BY]</summary>
		public FieldProperty createdBy;
		///<summary>[CREATED_AT]</summary>
		public FieldProperty createdAt;
		///<summary>[MODIFIED_BY]</summary>
		public FieldProperty modifiedBy;
		///<summary>[MODIFIED_AT]</summary>
		public FieldProperty modifiedAt;
		///<summary>[DELETED]</summary>
		public FieldProperty deleted;
		///<summary>[CATEGORY_ID]</summary>
		public FieldProperty categoryId;
		///<summary>[PRIORITY]</summary>
		public FieldProperty priority;
		

	    /// <summary>
	    /// default construct
	    /// </summary>
        public TasksTableProperty()
        {
        	this.EntityName = "TASKS";
        	this.ModifiedAtField = "UPDATE_DATE";
        	this.CreatedAtField = "CREATE_DATE";
        	
			id = FieldProperty.NewInstance("int", "TASKS", "ID","[ID]", 4, 10, 0, false, 0,true);
			subject = FieldProperty.NewInstance("varchar", "TASKS", "SUBJECT","[SUBJECT]", 200, 200, 0, false, "",false);
			statusId = FieldProperty.NewInstance("smallint", "TASKS", "STATUS_ID","[STATUS_ID]", 2, 5, 0, false, 0,false);
			fromDate = FieldProperty.NewInstance("datetime", "TASKS", "FROM_DATE","[FROM_DATE]", 16, 23, 3, true, null,false);
			toDate = FieldProperty.NewInstance("datetime", "TASKS", "TO_DATE","[TO_DATE]", 16, 23, 3, true, null,false);
			description = FieldProperty.NewInstance("varchar", "TASKS", "DESCRIPTION","[DESCRIPTION]", 1000, 1000, 0, true, "",false);
			createdBy = FieldProperty.NewInstance("varchar", "TASKS", "CREATED_BY","[CREATED_BY]", 16, 16, 0, false, "",false);
			createdAt = FieldProperty.NewInstance("datetime", "TASKS", "CREATED_AT","[CREATED_AT]", 16, 23, 3, false, null,false);
			modifiedBy = FieldProperty.NewInstance("varchar", "TASKS", "MODIFIED_BY","[MODIFIED_BY]", 16, 16, 0, false, "",false);
			modifiedAt = FieldProperty.NewInstance("datetime", "TASKS", "MODIFIED_AT","[MODIFIED_AT]", 16, 23, 3, false, null,false);
			deleted = FieldProperty.NewInstance("tinyint", "TASKS", "DELETED","[DELETED]", 1, 3, 0, false, 0,false);
			categoryId = FieldProperty.NewInstance("int", "TASKS", "CATEGORY_ID","[CATEGORY_ID]", 4, 10, 0, true, null,false);
			priority = FieldProperty.NewInstance("tinyint", "TASKS", "PRIORITY","[PRIORITY]", 1, 3, 0, true, null,false);
			
        }

        /// <summary>
        /// Ce[^\gĊOCe[^B
        /// </summary>
        /// <returns>Ce[^</returns>
        public override IEnumerable<FieldProperty> Fields()
        {
			yield return this.id;
			yield return this.subject;
			yield return this.statusId;
			yield return this.fromDate;
			yield return this.toDate;
			yield return this.description;
			yield return this.createdBy;
			yield return this.createdAt;
			yield return this.modifiedBy;
			yield return this.modifiedAt;
			yield return this.deleted;
			yield return this.categoryId;
			yield return this.priority;
			
        }
        /// <summary>
        /// Ce[^\gĊOCe[^B
        /// </summary>
        /// <returns>Ce[^</returns>
        public override IEnumerable<FieldProperty> PrimaryKeys()
        {
            yield return  this.id;
            
        }
    }
}