using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using CFW.Windows;
using CFW.Windows.Forms;
using CFW.Windows.Forms.Adapters;
using CFW.Forms.Filters;
using TaskManager.Forms.Adapters;
using TaskManager.Models;
using CFW.Models;
namespace TaskManager.Forms
{
    public partial class TaskSearchConditionForm : Form
    {
        public TaskSearchCondition condition;
        TaskSearchConditionFormAdapter adapter;
        private Enumerations priorityEnumerations;
        private Enumerations statusEnumerations;
        private Enumerations categoryEnumerations;



        public TaskSearchConditionForm()
        {
            InitializeComponent();
            initializeFormAdapter();
            condition = new TaskSearchCondition();
            loadEnumerations();
            initializeView();

        }

        private void initializeFormAdapter()
        {
            adapter = new TaskSearchConditionFormAdapter();
            adapter.periodFrom = new TextBoxAdapterElement(
                periodFromInput,
                new DateTimeFilter("yyyy/M/d"),
                new CFW.Validators.DateFieldValidator(),
                "yyyy/MM/dd");
            adapter.periodFrom.FilterOnBlur = true;
            adapter.periodTo = new TextBoxAdapterElement(
                periodToInput,
                new DateTimeFilter("yyyy/M/d"),
                new CFW.Validators.DateFieldValidator(),
                "yyyy/MM/dd");
            adapter.periodTo.FilterOnBlur = true;

            adapter.categories = new CheckBoxListAdapterElement(
                categoriesInput
                );
            adapter.statuses = new CheckBoxListAdapterElement(
                statusesInput
                );
            adapter.priorities = new CheckBoxListAdapterElement(
                prioritiesInput
                );


        }
        private void loadEnumerations()
        {
            CategoriesModel categories = new CategoriesModel();
            categoryEnumerations = categories.getEnumerations();

            StatusesModel statuses = new StatusesModel();
            statusEnumerations = statuses.getEnumerations();

            PrioritiesModel priorities = new PrioritiesModel();
            priorityEnumerations = priorities.getEnumerations();

        }
        private void initializeView()
        {
            categoriesInput.DataSource = categoryEnumerations;
            categoriesInput.Refresh();

            prioritiesInput.DataSource = priorityEnumerations;
            prioritiesInput.Refresh();

            statusesInput.DataSource = statusEnumerations;
            statusesInput.Refresh();
        }

        private void render()
        {
            adapter.SetEntity(condition);
            adapter.RenderView();
        }

        private void categoriesInput_Load(object sender, EventArgs e)
        {
            render();
        }

        private void doSearchButton_Click(object sender, EventArgs e)
        {
            adapter.Bind();
            if (adapter.IsValid)
            {
                condition = adapter.GetEntity() as TaskSearchCondition;
                DialogResult = DialogResult.OK;
            }
            else
            {
                Point p = this.Location;
                p.X += this.Width / 2;
                p.Y += this.Height / 2;

                using (ErrorMessageForm form = new ErrorMessageForm())
                {
                    form.StartPosition = FormStartPosition.Manual;
                    form.Location = p;
                    form.messages = adapter.Messages;
                    form.ShowDialog(this);
                }
            }
        }
    }
}