using System;
using System.Collections.Generic;
using System.Text;
using CFW.Forms;
using CFW.Forms.Filters;
using CFW.Util;
using CFW.Models;
using TaskManager.Models.Base;

namespace TaskManager.Windows.Forms.Adapters.Base
{
    /// <summary>
    /// table auth_users_roles Field`
    /// </summary>
    public class AuthUsersRolesTableFormAdapter : CFW.Forms.FormAdapter
	{
		private AuthUsersRolesTableRow theEntity;

		///<summary>[id]</summary>
		public FormAdapterElement id;
		///<summary>[login_id]</summary>
		public FormAdapterElement loginId;
		///<summary>[acl_roles_id]</summary>
		public FormAdapterElement aclRolesId;
		///<summary>[description]</summary>
		public FormAdapterElement description;
		

		/// <summary>݂̃f[^\[X擾
		/// </summary>
        public override Entity GetEntity()
        {
            return this.theEntity;
        }
		/// <summary>\̍XV
		/// </summary>
        public override void RenderView()
        {
			if(this.id != null) this.id.Render();
			if(this.loginId != null) this.loginId.Render();
			if(this.aclRolesId != null) this.aclRolesId.Render();
			if(this.description != null) this.description.Render();
			
        }

		/// <summary>̃A_v^[f[^ݒ
		/// </summary>
        /// <param name="dataSource">̃A_v^[f[^</param>
        public override void SetEntity(Entity entity)
        {
        	this.theEntity = (AuthUsersRolesTableRow)entity;
			if(this.id != null) this.id.SetValue(this.theEntity.id);
			if(this.loginId != null) this.loginId.SetValue(this.theEntity.loginId);
			if(this.aclRolesId != null) this.aclRolesId.SetValue(this.theEntity.aclRolesId);
			if(this.description != null) this.description.SetValue(this.theEntity.description);
			

        }

		/// <summary>UI͂ꂽef[^\[XɎ荞
		/// </summary>
        public override void UpdateEntity()
        {
			if(this.id != null) this.theEntity.id = NumberUtil.Value<Int32>(this.id.GetValue());
			if(this.loginId != null) this.theEntity.loginId = StringUtil.StringValue(this.loginId.GetValue());
			if(this.aclRolesId != null) this.theEntity.aclRolesId = NumberUtil.Value<Int32>(this.aclRolesId.GetValue());
			if(this.description != null) this.theEntity.description = StringUtil.StringValue(this.description.GetValue());
			
        }

		/// <summary>UI͂ꂽe荞
		/// </summary>
        public override void UpdateFields()
        {
			if(this.id != null) this.id.UpdateField();
			if(this.loginId != null) this.loginId.UpdateField();
			if(this.aclRolesId != null) this.aclRolesId.UpdateField();
			if(this.description != null) this.description.UpdateField();
			
        }

		/// <summary>͓e؂
		/// ؃G[MessagesXgɑSẴG[B
		/// </summary>
        public override bool Validate()
        {
            bool valid = true;
			
			if(this.id != null){
			    if(!this.id.Validate()){
				    valid = false;
				    this.messages.Add(this.id.ErrorMessage);
			    }
			}
			
			if(this.loginId != null){
			    if(!this.loginId.Validate()){
				    valid = false;
				    this.messages.Add(this.loginId.ErrorMessage);
			    }
			}
			
			if(this.aclRolesId != null){
			    if(!this.aclRolesId.Validate()){
				    valid = false;
				    this.messages.Add(this.aclRolesId.ErrorMessage);
			    }
			}
			
			if(this.description != null){
			    if(!this.description.Validate()){
				    valid = false;
				    this.messages.Add(this.description.ErrorMessage);
			    }
			}
			

            return valid;
        }
		
	}
/* 
    // initialize code sample
    // Form̃o[ɈȉǉB
    //     private AuthUsersRolesFormAdapter formAdapter;
    //     private AuthUsersRolesProperty property;
    //     private AuthUsersRolesEntity property;
    // tB[hƓ̓Rg[킹B
    // 2(tB^[)͓KXtB[hɍ킹ĕύX
    formAdapter = new AuthUsersRolesFormAdapter();

	
    formAdapter.id= new TextBoxAdapterElement(
        id,
        new CFW.Forms.Filters.StringFilter(property.id),
        CFW.Validators.FieldValidator.GetInstance(property.id)
    );
	
    formAdapter.loginId= new TextBoxAdapterElement(
        loginId,
        new CFW.Forms.Filters.StringFilter(property.loginId),
        CFW.Validators.FieldValidator.GetInstance(property.loginId)
    );
	
    formAdapter.aclRolesId= new TextBoxAdapterElement(
        aclRolesId,
        new CFW.Forms.Filters.StringFilter(property.aclRolesId),
        CFW.Validators.FieldValidator.GetInstance(property.aclRolesId)
    );
	
    formAdapter.description= new TextBoxAdapterElement(
        description,
        new CFW.Forms.Filters.StringFilter(property.description),
        CFW.Validators.FieldValidator.GetInstance(property.description)
    );
	
    formAdapter.SetEntity(entity);
    formAdapter.RenderView();
	

*/	

}