using System;
using System.Collections.Generic;
using System.Text;
using CFW.Forms;
using CFW.Forms.Filters;
using CFW.Util;
using CFW.Models;
using TaskManager.Models.Base;

namespace TaskManager.Windows.Forms.Adapters.Base
{
    /// <summary>
    /// table acl_roles Field`
    /// </summary>
    public class AclRolesTableFormAdapter : CFW.Forms.FormAdapter
	{
		private AclRolesTableRow theEntity;

		///<summary>[id]</summary>
		public FormAdapterElement id;
		///<summary>[name]</summary>
		public FormAdapterElement name;
		///<summary>[left_side]</summary>
		public FormAdapterElement leftSide;
		///<summary>[right_side]</summary>
		public FormAdapterElement rightSide;
		///<summary>[description]</summary>
		public FormAdapterElement description;
		///<summary>[deleted]</summary>
		public FormAdapterElement deleted;
		///<summary>[create_at]</summary>
		public FormAdapterElement createAt;
		///<summary>[modified_at]</summary>
		public FormAdapterElement modifiedAt;
		

		/// <summary>݂̃f[^\[X擾
		/// </summary>
        public override Entity GetEntity()
        {
            return this.theEntity;
        }
		/// <summary>\̍XV
		/// </summary>
        public override void RenderView()
        {
			if(this.id != null) this.id.Render();
			if(this.name != null) this.name.Render();
			if(this.leftSide != null) this.leftSide.Render();
			if(this.rightSide != null) this.rightSide.Render();
			if(this.description != null) this.description.Render();
			if(this.deleted != null) this.deleted.Render();
			if(this.createAt != null) this.createAt.Render();
			if(this.modifiedAt != null) this.modifiedAt.Render();
			
        }

		/// <summary>̃A_v^[f[^ݒ
		/// </summary>
        /// <param name="dataSource">̃A_v^[f[^</param>
        public override void SetEntity(Entity entity)
        {
        	this.theEntity = (AclRolesTableRow)entity;
			if(this.id != null) this.id.SetValue(this.theEntity.id);
			if(this.name != null) this.name.SetValue(this.theEntity.name);
			if(this.leftSide != null) this.leftSide.SetValue(this.theEntity.leftSide);
			if(this.rightSide != null) this.rightSide.SetValue(this.theEntity.rightSide);
			if(this.description != null) this.description.SetValue(this.theEntity.description);
			if(this.deleted != null) this.deleted.SetValue(this.theEntity.deleted);
			if(this.createAt != null) this.createAt.SetValue(this.theEntity.createAt);
			if(this.modifiedAt != null) this.modifiedAt.SetValue(this.theEntity.modifiedAt);
			

        }

		/// <summary>UI͂ꂽef[^\[XɎ荞
		/// </summary>
        public override void UpdateEntity()
        {
			if(this.id != null) this.theEntity.id = NumberUtil.Value<Int32>(this.id.GetValue());
			if(this.name != null) this.theEntity.name = StringUtil.StringValue(this.name.GetValue());
			if(this.leftSide != null) this.theEntity.leftSide = NumberUtil.Value<Int32>(this.leftSide.GetValue());
			if(this.rightSide != null) this.theEntity.rightSide = NumberUtil.Value<Int32>(this.rightSide.GetValue());
			if(this.description != null) this.theEntity.description = StringUtil.StringValue(this.description.GetValue());
			if(this.deleted != null) this.theEntity.deleted = NumberUtil.Value<Int32>(this.deleted.GetValue());
			if(this.createAt != null) this.theEntity.createAt = DateUtil.DateValue(this.createAt.GetValue());
			if(this.modifiedAt != null) this.theEntity.modifiedAt = DateUtil.DateValue(this.modifiedAt.GetValue());
			
        }

		/// <summary>UI͂ꂽe荞
		/// </summary>
        public override void UpdateFields()
        {
			if(this.id != null) this.id.UpdateField();
			if(this.name != null) this.name.UpdateField();
			if(this.leftSide != null) this.leftSide.UpdateField();
			if(this.rightSide != null) this.rightSide.UpdateField();
			if(this.description != null) this.description.UpdateField();
			if(this.deleted != null) this.deleted.UpdateField();
			if(this.createAt != null) this.createAt.UpdateField();
			if(this.modifiedAt != null) this.modifiedAt.UpdateField();
			
        }

		/// <summary>͓e؂
		/// ؃G[MessagesXgɑSẴG[B
		/// </summary>
        public override bool Validate()
        {
            bool valid = true;
			
			if(this.id != null){
			    if(!this.id.Validate()){
				    valid = false;
				    this.messages.Add(this.id.ErrorMessage);
			    }
			}
			
			if(this.name != null){
			    if(!this.name.Validate()){
				    valid = false;
				    this.messages.Add(this.name.ErrorMessage);
			    }
			}
			
			if(this.leftSide != null){
			    if(!this.leftSide.Validate()){
				    valid = false;
				    this.messages.Add(this.leftSide.ErrorMessage);
			    }
			}
			
			if(this.rightSide != null){
			    if(!this.rightSide.Validate()){
				    valid = false;
				    this.messages.Add(this.rightSide.ErrorMessage);
			    }
			}
			
			if(this.description != null){
			    if(!this.description.Validate()){
				    valid = false;
				    this.messages.Add(this.description.ErrorMessage);
			    }
			}
			
			if(this.deleted != null){
			    if(!this.deleted.Validate()){
				    valid = false;
				    this.messages.Add(this.deleted.ErrorMessage);
			    }
			}
			
			if(this.createAt != null){
			    if(!this.createAt.Validate()){
				    valid = false;
				    this.messages.Add(this.createAt.ErrorMessage);
			    }
			}
			
			if(this.modifiedAt != null){
			    if(!this.modifiedAt.Validate()){
				    valid = false;
				    this.messages.Add(this.modifiedAt.ErrorMessage);
			    }
			}
			

            return valid;
        }
		
	}
/* 
    // initialize code sample
    // Form̃o[ɈȉǉB
    //     private AclRolesFormAdapter formAdapter;
    //     private AclRolesProperty property;
    //     private AclRolesEntity property;
    // tB[hƓ̓Rg[킹B
    // 2(tB^[)͓KXtB[hɍ킹ĕύX
    formAdapter = new AclRolesFormAdapter();

	
    formAdapter.id= new TextBoxAdapterElement(
        id,
        new CFW.Forms.Filters.StringFilter(property.id),
        CFW.Validators.FieldValidator.GetInstance(property.id)
    );
	
    formAdapter.name= new TextBoxAdapterElement(
        name,
        new CFW.Forms.Filters.StringFilter(property.name),
        CFW.Validators.FieldValidator.GetInstance(property.name)
    );
	
    formAdapter.leftSide= new TextBoxAdapterElement(
        leftSide,
        new CFW.Forms.Filters.StringFilter(property.leftSide),
        CFW.Validators.FieldValidator.GetInstance(property.leftSide)
    );
	
    formAdapter.rightSide= new TextBoxAdapterElement(
        rightSide,
        new CFW.Forms.Filters.StringFilter(property.rightSide),
        CFW.Validators.FieldValidator.GetInstance(property.rightSide)
    );
	
    formAdapter.description= new TextBoxAdapterElement(
        description,
        new CFW.Forms.Filters.StringFilter(property.description),
        CFW.Validators.FieldValidator.GetInstance(property.description)
    );
	
    formAdapter.deleted= new TextBoxAdapterElement(
        deleted,
        new CFW.Forms.Filters.StringFilter(property.deleted),
        CFW.Validators.FieldValidator.GetInstance(property.deleted)
    );
	
    formAdapter.createAt= new TextBoxAdapterElement(
        createAt,
        new CFW.Forms.Filters.StringFilter(property.createAt),
        CFW.Validators.FieldValidator.GetInstance(property.createAt)
    );
	
    formAdapter.modifiedAt= new TextBoxAdapterElement(
        modifiedAt,
        new CFW.Forms.Filters.StringFilter(property.modifiedAt),
        CFW.Validators.FieldValidator.GetInstance(property.modifiedAt)
    );
	
    formAdapter.SetEntity(entity);
    formAdapter.RenderView();
	

*/	

}