using System;
using System.Collections.Generic;
using System.Text;
using CFW.Forms;
using CFW.Forms.Filters;
using CFW.Util;
using SQLiteSample.Model;
using SQLiteSample.Model.TableRow;
using SQLiteSample.Model.TableProperty;
using SQLiteSample.Model.TableValidator;


namespace SQLiteSample.Model.TableFormAdapter
{
    /// <summary>
    /// table postaldata Field`
    /// </summary>
    public class PostaldataTableFormAdapter : CFW.Forms.FormAdapter
	{
		private PostaldataTableRow table;

		///<summary>[id]</summary>
		public FormAdapterElement Id;
		///<summary>[local_code]</summary>
		public FormAdapterElement LocalCode;
		///<summary>[postal_code_5]</summary>
		public FormAdapterElement PostalCode5;
		///<summary>[postal_code]</summary>
		public FormAdapterElement PostalCode;
		///<summary>[prefecture_k]</summary>
		public FormAdapterElement Prefecturek;
		///<summary>[city_k]</summary>
		public FormAdapterElement Cityk;
		///<summary>[area_k]</summary>
		public FormAdapterElement Areak;
		///<summary>[prefecture]</summary>
		public FormAdapterElement Prefecture;
		///<summary>[city]</summary>
		public FormAdapterElement City;
		///<summary>[area]</summary>
		public FormAdapterElement Area;
		///<summary>[flag1]</summary>
		public FormAdapterElement Flag1;
		///<summary>[flag2]</summary>
		public FormAdapterElement Flag2;
		///<summary>[flag3]</summary>
		public FormAdapterElement Flag3;
		///<summary>[flag4]</summary>
		public FormAdapterElement Flag4;
		///<summary>[flag5]</summary>
		public FormAdapterElement Flag5;
		///<summary>[flag6]</summary>
		public FormAdapterElement Flag6;
		

        public override object GetDataSource()
        {
            return this.table;
        }

        public override void RenderView()
        {
			this.Id.Render();
			this.LocalCode.Render();
			this.PostalCode5.Render();
			this.PostalCode.Render();
			this.Prefecturek.Render();
			this.Cityk.Render();
			this.Areak.Render();
			this.Prefecture.Render();
			this.City.Render();
			this.Area.Render();
			this.Flag1.Render();
			this.Flag2.Render();
			this.Flag3.Render();
			this.Flag4.Render();
			this.Flag5.Render();
			this.Flag6.Render();
			
        }

        public override void SetDataSource(object dataSource)
        {
        	this.table = (PostaldataTableRow)dataSource;
			this.Id.SetValue(this.table.Id);
			this.LocalCode.SetValue(this.table.LocalCode);
			this.PostalCode5.SetValue(this.table.PostalCode5);
			this.PostalCode.SetValue(this.table.PostalCode);
			this.Prefecturek.SetValue(this.table.Prefecturek);
			this.Cityk.SetValue(this.table.Cityk);
			this.Areak.SetValue(this.table.Areak);
			this.Prefecture.SetValue(this.table.Prefecture);
			this.City.SetValue(this.table.City);
			this.Area.SetValue(this.table.Area);
			this.Flag1.SetValue(this.table.Flag1);
			this.Flag2.SetValue(this.table.Flag2);
			this.Flag3.SetValue(this.table.Flag3);
			this.Flag4.SetValue(this.table.Flag4);
			this.Flag5.SetValue(this.table.Flag5);
			this.Flag6.SetValue(this.table.Flag6);
			

        }

        public override void UpdateDataSource()
        {
			this.table.Id = NumberUtil.Value<Int32>(this.Id.GetValue());
			this.table.LocalCode = StringUtil.StringValue(this.LocalCode.GetValue());
			this.table.PostalCode5 = StringUtil.StringValue(this.PostalCode5.GetValue());
			this.table.PostalCode = StringUtil.StringValue(this.PostalCode.GetValue());
			this.table.Prefecturek = StringUtil.StringValue(this.Prefecturek.GetValue());
			this.table.Cityk = StringUtil.StringValue(this.Cityk.GetValue());
			this.table.Areak = StringUtil.StringValue(this.Areak.GetValue());
			this.table.Prefecture = StringUtil.StringValue(this.Prefecture.GetValue());
			this.table.City = StringUtil.StringValue(this.City.GetValue());
			this.table.Area = StringUtil.StringValue(this.Area.GetValue());
			this.table.Flag1 = NumberUtil.Value<Int32>(this.Flag1.GetValue());
			this.table.Flag2 = NumberUtil.Value<Int32>(this.Flag2.GetValue());
			this.table.Flag3 = NumberUtil.Value<Int32>(this.Flag3.GetValue());
			this.table.Flag4 = NumberUtil.Value<Int32>(this.Flag4.GetValue());
			this.table.Flag5 = NumberUtil.Value<Int32>(this.Flag5.GetValue());
			this.table.Flag6 = NumberUtil.Value<Int32>(this.Flag6.GetValue());
			
        }

        public override void UpdateFields()
        {
			this.Id.UpdateField();
			this.LocalCode.UpdateField();
			this.PostalCode5.UpdateField();
			this.PostalCode.UpdateField();
			this.Prefecturek.UpdateField();
			this.Cityk.UpdateField();
			this.Areak.UpdateField();
			this.Prefecture.UpdateField();
			this.City.UpdateField();
			this.Area.UpdateField();
			this.Flag1.UpdateField();
			this.Flag2.UpdateField();
			this.Flag3.UpdateField();
			this.Flag4.UpdateField();
			this.Flag5.UpdateField();
			this.Flag6.UpdateField();
			
        }

        public override bool Validate()
        {
            bool valid = true;
			if(!this.Id.Validate()) valid = false;
			if(!this.LocalCode.Validate()) valid = false;
			if(!this.PostalCode5.Validate()) valid = false;
			if(!this.PostalCode.Validate()) valid = false;
			if(!this.Prefecturek.Validate()) valid = false;
			if(!this.Cityk.Validate()) valid = false;
			if(!this.Areak.Validate()) valid = false;
			if(!this.Prefecture.Validate()) valid = false;
			if(!this.City.Validate()) valid = false;
			if(!this.Area.Validate()) valid = false;
			if(!this.Flag1.Validate()) valid = false;
			if(!this.Flag2.Validate()) valid = false;
			if(!this.Flag3.Validate()) valid = false;
			if(!this.Flag4.Validate()) valid = false;
			if(!this.Flag5.Validate()) valid = false;
			if(!this.Flag6.Validate()) valid = false;
			

            return valid;
        }
		
	}

}