using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace SQLiteSample
{
    public partial class PerformanceCheckForm : Form
    {
        

        public PerformanceCheckForm()
        {
            InitializeComponent();

            TextBoxTraceListener listener = new TextBoxTraceListener(this.textBox2);
            System.Diagnostics.Trace.Listeners.Add(listener);
        }

        private int GetLastId()
        {
            System.Diagnostics.Stopwatch sw = new System.Diagnostics.Stopwatch();
            sw.Start();

            CFW.Database.Connection connection = CFW.Database.ConnectionFactory.GetConnectionByName("default");
            connection.Open();
            CFW.Database.Command command = new CFW.Database.Command("select isnull( max(id),0) from t1", CommandType.Text);
            long result = (long)connection.ExecuteScalar(command);
            connection.Close();
            sw.Stop();
            System.Diagnostics.Trace.WriteLine("getlast id time=" + sw.ElapsedMilliseconds.ToString());

            return (int)result;
        }

        private void DeleteAllButton_Click(object sender, EventArgs e)
        {
            System.Diagnostics.Stopwatch sw = new System.Diagnostics.Stopwatch();
            sw.Start();

            CFW.Database.Connection connection = CFW.Database.ConnectionFactory.GetConnectionByName("default");
            connection.Open();
            CFW.Database.Command command = new CFW.Database.Command("delete from t1", CommandType.Text);
            int result = connection.ExecuteUpdate(command);
            connection.Close();
            sw.Stop();
            System.Diagnostics.Trace.WriteLine("delete all time=" + sw.ElapsedMilliseconds.ToString());

        }

        private void InsertButton_Click(object sender, EventArgs e)
        {

            System.Diagnostics.Stopwatch sw = new System.Diagnostics.Stopwatch();
            sw.Start();
            int count = CFW.Util.NumberUtil.Value<int>(RepeatCount.Text);
            CFW.Database.Connection connection = CFW.Database.ConnectionFactory.GetConnectionByName("default");
            connection.Open();

            Model.TableProperty.T1TableProperty property = new SQLiteSample.Model.TableProperty.T1TableProperty();
            property.Id.DoUpdate = false;
            Model.TableAccess.T1TableAccess access = new SQLiteSample.Model.TableAccess.T1TableAccess(connection,property);

            for (int i = 0; i < count; i++)
            {
                Model.Entity.T1Entity row = new Model.Entity.T1Entity();
                row.Id = 1;//dummy̒lB
                row.Value = "Value " + CFW.Util.NumberUtil.Format(i, "0000000000");

                Model.Validator.T1Validator validator = new SQLiteSample.Model.Validator.T1Validator(row);
                if (validator.Validate())
                {
                    System.Diagnostics.Trace.WriteLine(string.Format("vaidate success"));
                }
                else{
                    System.Diagnostics.Trace.WriteLine(string.Format("vaidate failed"));
                }

                access.Insert(row);
            }
            
            connection.Close();
         
            sw.Stop();
            System.Diagnostics.Trace.WriteLine(string.Format( "insert {0} rows  time={1}",count, sw.ElapsedMilliseconds.ToString()));
        }

        private void UpdateButton_Click(object sender, EventArgs e)
        {

            System.Diagnostics.Stopwatch sw = new System.Diagnostics.Stopwatch();
            sw.Start();

            int count = CFW.Util.NumberUtil.Value<int>(RepeatCount.Text);

            CFW.Database.Connection connection = CFW.Database.ConnectionFactory.GetConnectionByName("default");
            connection.Open();


            Model.TableProperty.T1TableProperty property = new SQLiteSample.Model.TableProperty.T1TableProperty();
            property.Id.DoUpdate = false;
            Model.TableAccess.T1TableAccess access = new SQLiteSample.Model.TableAccess.T1TableAccess(connection, property);
            int last = GetLastId();
            for (int i = (last - count); i <= last ; i++)
            {
                Model.TableRow.T1TableRow row = new SQLiteSample.Model.TableRow.T1TableRow();
                row.Id = (long) i;
                row.Value = "Value " + CFW.Util.NumberUtil.Format(i, "0000000000") + "updated";

                int result = access.Update(row);
            }

            connection.Close();

            sw.Stop();
            System.Diagnostics.Trace.WriteLine(string.Format("update {0} rows  time={1}", count, sw.ElapsedMilliseconds.ToString()));
        }

        private void ReadButton_Click(object sender, EventArgs e)
        {

            System.Diagnostics.Stopwatch sw = new System.Diagnostics.Stopwatch();
            sw.Start();

            int count = CFW.Util.NumberUtil.Value<int>(RepeatCount.Text);

            CFW.Database.Connection connection = CFW.Database.ConnectionFactory.GetConnectionByName("default");
            connection.Open();

            Model.TableProperty.T1TableProperty property = new SQLiteSample.Model.TableProperty.T1TableProperty();
            Model.TableAccess.T1TableAccess access = new SQLiteSample.Model.TableAccess.T1TableAccess(connection, property);

            int last = GetLastId();
            for (int i = (last - count); i <= last; i++)
            {
                Model.TableRow.T1TableRow conditionRow = new SQLiteSample.Model.TableRow.T1TableRow();
                conditionRow.Id = (long)i;
                Model.TableRow.T1TableRow row = access.Get(conditionRow);
            }

            connection.Close();

            sw.Stop();
            System.Diagnostics.Trace.WriteLine(string.Format("read {0} rows  time={1}", count, sw.ElapsedMilliseconds.ToString()));

        }

    }
}