using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace Locker
{
    public partial class Form1 : Form
    {
        delegate void AddStateDelegate(TestThread request);
        delegate void StartProcessDelegate();
        System.Threading.Timer timer;
        System.Data.IsolationLevel isolation;
        bool useTran;

        public Form1()
        {
            InitializeComponent();
            executeAt.Text = DateTime.Now.ToString("HH:mm:ss");
            this.numRepeat.Text = "1";
            this.numThreads.Text = "1";
            this.timeWait.Text = "0";
            isolation = IsolationLevel.ReadCommitted;

        }

        private void button1_Click(object sender, EventArgs e)
        {
            button1.Enabled = false;
            this.Cursor = Cursors.WaitCursor;

            listView1.Items.Clear();

            DateTime executeAt = (DateTime) CFW.Util.DateUtil.Parse(DateTime.Now.ToString("yyyy/MM/dd") + " " + this.executeAt.Text);

            timer = new System.Threading.Timer(new System.Threading.TimerCallback(this.CheckStart), executeAt, 0, 50);



        }
        void CheckStart(object o)
        {
            DateTime exect = (DateTime)o;
            if (DateTime.Now.CompareTo(exect) > 0)
            {
                this.timer.Dispose();
                this.Invoke(new StartProcessDelegate(StartProcess));
            }
        }
        void StartProcess()
        {
            int numThreads = CFW.Util.NumberUtil.Parse<int>(this.numThreads.Text);
            int numRepeat = CFW.Util.NumberUtil.Parse<int>(this.numRepeat.Text);
            int wait = CFW.Util.NumberUtil.Parse<int>(this.timeWait.Text);

            if (isolationOptionReadCommited.Checked) this.isolation = IsolationLevel.ReadCommitted;
            if (isolationOptionReadUncommited.Checked) this.isolation = IsolationLevel.ReadUncommitted;
            if (isolationOptionSnapshot.Checked) this.isolation = IsolationLevel.Snapshot;

            this.useTran = this.useTranOption.Checked;

            progressBar1.Minimum = 0;
            progressBar1.Maximum = numThreads;
            progressBar1.Value = 0;

            for (int i = 0; i < numThreads; i++)
            {
                progressBar1.Value++;
                TestThread t1 = new TestThread();
                t1.numRepeat = numRepeat;
                t1.timeWait = wait;
                t1.TestProcess += this.Test1;
                t1.OnThreadEnd += this.Test1End;
                System.Threading.Thread thread1 = new System.Threading.Thread(new System.Threading.ThreadStart(t1.Run));
                thread1.Start();
                System.Threading.Thread.Sleep(wait);

            }

        }
        void Test1(TestThread thread)
        {
            CFW.Database.Connection connection = CFW.Database.ConnectionFactory.GetConnectionByName("default");
            connection.Open(isolation);
            if (this.useTran) connection.BeginTransaction();
            try
            {
                CFW.Database.Command command = new CFW.Database.Command(textBox1.Text, CommandType.Text);
                DataSet result = connection.ExecuteQuery(command);
                if (this.useTran) connection.CommitTransaction();
            }
            catch (Exception ex)
            {
                if (this.useTran) connection.RollbackTransaction();
                thread.message += ex.Message;
            }
            finally
            {
                connection.Close();
            }

        }
        void Test1End(TestThread thread)
        {
            this.Invoke(new AddStateDelegate(AddState), thread);
        }
        public void AddState(TestThread thread)
        {
            ListViewItem item = new ListViewItem();
            item.Text = thread.Name;
            item.SubItems.Add(thread.startTime.ToString("HH:mm:ss.fff"));
            item.SubItems.Add(thread.endTime.ToString("HH:mm:ss.fff"));
            TimeSpan t = thread.endTime - thread.startTime;
            item.SubItems.Add(t.TotalMilliseconds.ToString("#,##0") + "ms");

            item.SubItems.Add(thread.message);
            listView1.Items.Add(item);

            progressBar1.Value--;
            if (progressBar1.Value == 0)
            {
                this.Cursor = Cursors.Default;
                button1.Enabled = true;
            }

        }

        private void executeAt_TextChanged(object sender, EventArgs e)
        {

        }

        private void executeAt_DoubleClick(object sender, EventArgs e)
        {
            executeAt.Text = DateTime.Now.ToString("HH:mm:ss");

        }

    }
}