﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using Konozama.Shop.Model.Entity;
using Konozama.Shop.Model.Access;
using Konozama.Shop.Model.FormAdapter;
using Konozama.Shop.Model.Property;

public partial class Settlement : System.Web.UI.Page
{
    OrdersEntity cart;
    protected decimal? TotalPrice = 0;

    protected void Page_Load(object sender, EventArgs e)
    {
        if (Page.PreviousPage != null)
        {
            if (Page.PreviousPage.IsCrossPagePostBack)
            {
                this.cart = (OrdersEntity)Session["cart"];
                this.RenderView(false);
            }
        }

    }
    void RenderView(bool finished)
    {
        if (!finished)
        {
            if (this.cart != null)
            {
                this.message.Text = "現在のカートの内容はご覧のとおりです。";
                this.TotalPrice = cart.TotalPrice;
                cartItems.DataSource = cart.Items;
                this.DataBind();
            }
            else
            {
                this.message.Text = "カートには何も入っていません。";
            }
            settlementView.Visible = true;
            settlementFinishView.Visible = false;
        }
        else
        {
            settlementView.Visible = false;
            settlementFinishView.Visible = true;
        }
    }
    void UpdateCartData()
    {
        this.cart = (OrdersEntity)Session["cart"];
        //入力値取り込み
        this.cart.DeliveryPlace = CFW.Util.StringUtil.NormalizeString( this.DeliveryPlace.Text,CFW.Util.StringUtil.NormalizeMode.Default);
        if (this.PaymentByCard.Checked) this.cart.PaymentMethod = 1;
        if (this.PaymentByCOD.Checked) this.cart.PaymentMethod = 2;

        //現在のユーザーは？
        this.cart.CustomerId = 1001;


    }
    void SaveOrder()
    {
        OrdersAccess access = new OrdersAccess();
        access.Save(this.cart);
    }
    protected void Submit_Click(object sender, EventArgs e)
    {
        UpdateCartData();
        SaveOrder();
        RenderView(true);

    }
}
