using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using CFW.Util;
using CFW.FieldProperties;
using CFW.Database;
using Konozama.Shop.Model;
using Konozama.Shop.Model.TableRow;
using Konozama.Shop.Model.TableProperty;

namespace Konozama.Shop.Model.TableRow
{
    /// <summary>
    /// table products Field`
    /// </summary>
    [Serializable()]
    public class ProductsTableRow : CFW.Models.Entity, ICloneable
    {
        ///<summary>[id]</summary>
        protected Int32 _Id;
        ///<summary>[id]</summary>
        public Int32 Id{
            get{return _Id;}
            set{_Id = value;}
        }
        ///<summary>[name]</summary>
        protected string _Name;
        ///<summary>[name]</summary>
        public string Name{
            get{return _Name;}
            set{_Name = value;}
        }
        ///<summary>[unit_price]</summary>
        protected System.Nullable<Decimal> _UnitPrice;
        ///<summary>[unit_price]</summary>
        public System.Nullable<Decimal> UnitPrice{
            get{return _UnitPrice;}
            set{_UnitPrice = value;}
        }
        ///<summary>[description]</summary>
        protected string _Description;
        ///<summary>[description]</summary>
        public string Description{
            get{return _Description;}
            set{_Description = value;}
        }
        ///<summary>[category_id]</summary>
        protected System.Nullable<Int32> _CategoryId;
        ///<summary>[category_id]</summary>
        public System.Nullable<Int32> CategoryId{
            get{return _CategoryId;}
            set{_CategoryId = value;}
        }
        
        /// <summary>
        /// default construct 
        /// </summary>
        public ProductsTableRow() : base()
        {
            _Id = 0;
            _Name = "";
            _UnitPrice = null;
            _Description = "";
            _CategoryId = null;
            
        }
        
        /// <summary>
        /// DataRowWJč\z
        /// </summary>
        public override void Map(DataRow row,string alias)
        {
            string columnName = "";
            columnName = BuildColumnName(alias, "id");if(ColumnExists(row,columnName)) _Id = NumberUtil.Value<Int32>( row[columnName] );
            columnName = BuildColumnName(alias, "name");if(ColumnExists(row,columnName)) _Name = StringUtil.StringValue( row[columnName] );
            columnName = BuildColumnName(alias, "unit_price");if(ColumnExists(row,columnName)) _UnitPrice = NumberUtil.Value<Decimal?>( row[columnName] );
            columnName = BuildColumnName(alias, "description");if(ColumnExists(row,columnName)) _Description = StringUtil.StringValue( row[columnName] );
            columnName = BuildColumnName(alias, "category_id");if(ColumnExists(row,columnName)) _CategoryId = NumberUtil.Value<Int32?>( row[columnName] );
            
        }
        /// <summary>
        /// 񖼂w肵Ēlݒ
        /// </summary>
        /// <param name="name"></param>
        /// <param name="value"></param>
        public override void SetValue(string name,object value)
        {
            if(name ==  "id") _Id = NumberUtil.Value<Int32>( value );
            if(name ==  "name") _Name = StringUtil.StringValue( value );
            if(name ==  "unit_price") _UnitPrice = NumberUtil.Value<Decimal?>( value );
            if(name ==  "description") _Description = StringUtil.StringValue( value );
            if(name ==  "category_id") _CategoryId = NumberUtil.Value<Int32?>( value );
            
        }
        public override object GetValue(string name)
        {
            throw new Exception("The method or operation is not implemented.");
        }
        /// <summary>
        /// N[
        /// </summary>
        /// <return >̃IuWFNg̃N[</return>
        public virtual object Clone()
        {
            ProductsTableRow clone = new ProductsTableRow();
            clone.CopyFrom(this);
            return clone;
        }
        /// <summary>
        /// N[
        /// </summary>
        /// <return >̃IuWFNg̃N[</return>
        public virtual void CopyFrom(ProductsTableRow source)
        {
            this.Id = source.Id;
            this.Name = source.Name;
            this.UnitPrice = source.UnitPrice;
            this.Description = source.Description;
            this.CategoryId = source.CategoryId;
            
        }
    }

}