using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using CFW.Util;
using CFW.FieldProperties;
using Konozama.Shop.Model;
using Konozama.Shop.Model.TableRow;

namespace Konozama.Shop.Model.TableProperty
{
    /// <summary>
    /// table ordersɑΉtB[hvpeB
    /// </summary>
    [Serializable()]
    public class OrdersTableProperty : FieldPropertiesBase
    {
    	///<summary>ftHg̃e[u</summary>
    	string DefaultTableName;
		///<summary>[id]</summary>
		public FieldProperty Id;
		///<summary>[customer_id]</summary>
		public FieldProperty CustomerId;
		///<summary>[order_date]</summary>
		public FieldProperty OrderDate;
		///<summary>[payment_method]</summary>
		public FieldProperty PaymentMethod;
		///<summary>[delivery_place]</summary>
		public FieldProperty DeliveryPlace;
		

	    /// <summary>
	    /// default construct
	    /// </summary>
        public OrdersTableProperty()
        {
        	this.DefaultTableName = "orders";
			Id = FieldProperty.NewInstance("int", "orders", "id","[id]", 4, 10, 0, false, 0,true);
			CustomerId = FieldProperty.NewInstance("int", "orders", "customer_id","[customer_id]", 4, 10, 0, false, 0,false);
			OrderDate = FieldProperty.NewInstance("datetime", "orders", "order_date","[order_date]", 16, 23, 3, false, null,false);
			PaymentMethod = FieldProperty.NewInstance("int", "orders", "payment_method","[payment_method]", 4, 10, 0, true, null,false);
			DeliveryPlace = FieldProperty.NewInstance("varchar", "orders", "delivery_place","[delivery_place]", 255, 0, 0, true, "",false);
			
        }

	    /// <summary>
	    /// DoUpdateꊇݒ
	    /// </summary>
	    /// <param name="doUpdate">ݒl</param>
        public void SetUpdate()
        {
        	this.SetUpdate(true);
        }
	    /// <summary>
	    /// DoUpdateꊇݒ
	    /// </summary>
	    /// <param name="doUpdate">ݒl</param>
        public void SetUpdate(bool doUpdate)
        {
			Id.DoUpdate = doUpdate;
			CustomerId.DoUpdate = doUpdate;
			OrderDate.DoUpdate = doUpdate;
			PaymentMethod.DoUpdate = doUpdate;
			DeliveryPlace.DoUpdate = doUpdate;
			
        }
	    /// <summary>
	    /// TableNameꊇݒ
	    /// TableCommandgꍇAliasꊇݒ肷B
	    /// </summary>
	    /// <param name="alias">Vɐݒ肷e[u</param>
        public void SetTableName(string alias)
        {
			Id.TableName = alias;
			CustomerId.TableName = alias;
			OrderDate.TableName = alias;
			PaymentMethod.TableName = alias;
			DeliveryPlace.TableName = alias;
			
        }
	    /// <summary>
	    /// TableName߂
	    /// </summary>
        public void ResetTableName()
        {
        	this.SetTableName(this.DefaultTableName);
        }
	    /// <summary>
	    /// e[uIR}hɑSĂ̗I悤Ɏw
	    /// </summary>
        public void SetSelectTo(ref CFW.Database.TableCommand.TableSelectCommand command)
        {
			command.AddSelect(this.Id);
			command.AddSelect(this.CustomerId);
			command.AddSelect(this.OrderDate);
			command.AddSelect(this.PaymentMethod);
			command.AddSelect(this.DeliveryPlace);
			
        }
    }
}