using System;
using System.Collections.Generic;
using System.Text;
using CFW.Forms;
using CFW.Forms.Filters;
using CFW.Util;
using Konozama.Shop.Model;
using Konozama.Shop.Model.TableRow;
using Konozama.Shop.Model.TableProperty;
using Konozama.Shop.Model.TableValidator;


namespace Konozama.Shop.Model.TableFormAdapter
{
    /// <summary>
    /// table orders Field`
    /// </summary>
    public class OrdersTableFormAdapter : CFW.Forms.FormAdapter
	{
		private OrdersTableRow table;

		///<summary>[id]</summary>
		public FormAdapterElement Id;
		///<summary>[customer_id]</summary>
		public FormAdapterElement CustomerId;
		///<summary>[order_date]</summary>
		public FormAdapterElement OrderDate;
		///<summary>[payment_method]</summary>
		public FormAdapterElement PaymentMethod;
		///<summary>[delivery_place]</summary>
		public FormAdapterElement DeliveryPlace;


        public override CFW.Models.Entity GetEntity()
        {
            return this.table;
        }

        public override void RenderView()
        {
			this.Id.Render();
			this.CustomerId.Render();
			this.OrderDate.Render();
			this.PaymentMethod.Render();
			this.DeliveryPlace.Render();
			
        }

        public override void SetEntity(CFW.Models.Entity dataSource)
        {
        	this.table = (OrdersTableRow)dataSource;
			this.Id.SetValue(this.table.Id);
			this.CustomerId.SetValue(this.table.CustomerId);
			this.OrderDate.SetValue(this.table.OrderDate);
			this.PaymentMethod.SetValue(this.table.PaymentMethod);
			this.DeliveryPlace.SetValue(this.table.DeliveryPlace);
			

        }

        public override void UpdateEntity()
        {
			this.table.Id = NumberUtil.Value<Int32>(this.Id.GetValue());
			this.table.CustomerId = NumberUtil.Value<Int32>(this.CustomerId.GetValue());
			this.table.OrderDate = DateUtil.DateValue(this.OrderDate.GetValue());
			this.table.PaymentMethod = NumberUtil.Value<Int32?>(this.PaymentMethod.GetValue());
			this.table.DeliveryPlace = StringUtil.StringValue(this.DeliveryPlace.GetValue());
			
        }

        public override void UpdateFields()
        {
			this.Id.UpdateField();
			this.CustomerId.UpdateField();
			this.OrderDate.UpdateField();
			this.PaymentMethod.UpdateField();
			this.DeliveryPlace.UpdateField();
			
        }

        public override bool Validate()
        {
            bool valid = true;
			if(!this.Id.Validate()) valid = false;
			if(!this.CustomerId.Validate()) valid = false;
			if(!this.OrderDate.Validate()) valid = false;
			if(!this.PaymentMethod.Validate()) valid = false;
			if(!this.DeliveryPlace.Validate()) valid = false;
			

            return valid;
        }
		
	}

}