using System;
using System.Collections.Generic;
using System.Text;
using CFW.Forms;
using CFW.Forms.Filters;
using CFW.Util;
using Konozama.Shop.Model;
using Konozama.Shop.Model.TableRow;
using Konozama.Shop.Model.TableProperty;
using Konozama.Shop.Model.TableValidator;


namespace Konozama.Shop.Model.TableFormAdapter
{
    /// <summary>
    /// table order_items Field`
    /// </summary>
    public class OrderItemsTableFormAdapter : CFW.Forms.FormAdapter
	{
		private OrderItemsTableRow table;

		///<summary>[id]</summary>
		public FormAdapterElement Id;
		///<summary>[order_id]</summary>
		public FormAdapterElement OrderId;
		///<summary>[product_id]</summary>
		public FormAdapterElement ProductId;
		///<summary>[unit_price]</summary>
		public FormAdapterElement UnitPrice;
		///<summary>[quantity]</summary>
		public FormAdapterElement Quantity;
		///<summary>[price]</summary>
		public FormAdapterElement Price;
		

        public override CFW.Models.Entity GetEntity()
        {
            return this.table;
        }

        public override void RenderView()
        {
			this.Id.Render();
			this.OrderId.Render();
			this.ProductId.Render();
			this.UnitPrice.Render();
			this.Quantity.Render();
			this.Price.Render();
			
        }

        public override void SetEntity(CFW.Models.Entity dataSource)
        {
        	this.table = (OrderItemsTableRow)dataSource;
			this.Id.SetValue(this.table.Id);
			this.OrderId.SetValue(this.table.OrderId);
			this.ProductId.SetValue(this.table.ProductId);
			this.UnitPrice.SetValue(this.table.UnitPrice);
			this.Quantity.SetValue(this.table.Quantity);
			this.Price.SetValue(this.table.Price);
			

        }

        public override void UpdateEntity()
        {
			this.table.Id = NumberUtil.Value<Int32>(this.Id.GetValue());
			this.table.OrderId = NumberUtil.Value<Int32?>(this.OrderId.GetValue());
			this.table.ProductId = NumberUtil.Value<Int32?>(this.ProductId.GetValue());
			this.table.UnitPrice = NumberUtil.Value<Decimal?>(this.UnitPrice.GetValue());
			this.table.Quantity = NumberUtil.Value<Decimal?>(this.Quantity.GetValue());
			this.table.Price = NumberUtil.Value<Decimal?>(this.Price.GetValue());
			
        }

        public override void UpdateFields()
        {
			this.Id.UpdateField();
			this.OrderId.UpdateField();
			this.ProductId.UpdateField();
			this.UnitPrice.UpdateField();
			this.Quantity.UpdateField();
			this.Price.UpdateField();
			
        }

        public override bool Validate()
        {
            bool valid = true;
			if(!this.Id.Validate()) valid = false;
			if(!this.OrderId.Validate()) valid = false;
			if(!this.ProductId.Validate()) valid = false;
			if(!this.UnitPrice.Validate()) valid = false;
			if(!this.Quantity.Validate()) valid = false;
			if(!this.Price.Validate()) valid = false;
			

            return valid;
        }
		
	}

}