using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using System.Data.SqlClient;
using System.Xml;
using System.Xml.Serialization;
using CFW.Util;
using CFW.FieldProperties;
using CFW.Database;
using CFW.Database.TableCommand;
using Konozama.Shop.Model;
using Konozama.Shop.Model.TableRow;
using Konozama.Shop.Model.TableProperty;


namespace Konozama.Shop.Model.TableAccess
{
    /// <summary>
    /// table[products]ɑ΂鑀
    /// </summary>
    [Serializable()]
    public class ProductsTableAccess
    {
        /// <summary>
        /// f[^\[Xւ̐ڑ
        /// </summary>
        private Connection connection;
        /// <summary>
        /// productsɑΉvpeB
        /// </summary>
        private ProductsTableProperty property;



#region constructors
        /// <summary>
        /// default construct  gps
        /// </summary>
        private ProductsTableAccess()
        {
            this.connection = ConnectionFactory.GetConnectionByName("default");
            this.property = new ProductsTableProperty();
        }
        /// <summary>
        /// ̐ڑgp\z
        /// </summary>
        public ProductsTableAccess(Connection db)
        {
            this.connection = db;
            this.property = new  ProductsTableProperty();
        }
        /// <summary>
        /// ̐ڑAvpeBgp\z
        /// </summary>
        /// <param name="db">̐ڑBJĂO</param>
        public ProductsTableAccess(Connection db, ProductsTableProperty property)
        {
            this.connection = db;
            this.property = property;
        }
#endregion

#region public interface
        /// <summary>
        /// products֍s̑}
        /// </summary>
        /// <param name="data">}sf[^</param>
        public int Insert(ProductsTableRow data)
        {
            TableInsertCommand command = BuildInsertCommand(data);
            int ret = connection.ExecuteUpdate(command.GetCommand());
            return ret;
        }

        /// <summary>
        /// products֍s̍XV
        /// </summary>
        /// <param name="data">XVsf[^</param>
        public int Update(ProductsTableRow data)
        {
            TableUpdateCommand command = BuildUpdateCommand(data);
            int ret = connection.ExecuteUpdate(command.GetCommand());
            return ret;
        }
        /// <summary>
        /// products֍s̍XV
        /// </summary>
        /// <remarks>where͌ĂяogݗāAp[^Ăяo</remarks>
        /// <param name="data">XVsf[^</param>
        /// <param name="condition"></param>
        public int Update(ProductsTableRow data,  TableCommandCondition condition)
        {
            TableUpdateCommand command = BuildUpdateCommand(data,condition);
            int ret = connection.ExecuteUpdate(command.GetCommand());
            return ret;
        }
        /// <summary>
        /// productss̍폜
        /// </summary>
        /// <param name="data">폜sf[^BL[̂݃ZbgłĂOK</param>
        public int Delete(ProductsTableRow data)
        {
            TableDeleteCommand command = BuildDeleteCommand(data);
            int ret = connection.ExecuteUpdate(command.GetCommand());
            return ret;
        }
        /// <summary>
        /// productss̍폜
        /// </summary>
        /// <remarks>where͌ĂяogݗāAp[^Ăяo
        /// <param name="condition"></param>
        public int Delete(TableCommandCondition condition)
        {
            TableDeleteCommand command = BuildDeleteCommand(condition);
            int ret = connection.ExecuteUpdate(command.GetCommand());
            return ret;
        }
        /// <summary>
        /// products̍s݊mF
        /// </summary>
        /// <param name="data">L[ݒ肵f[^</param>
        /// <return>ݒ肵L[ɊYs݂鎞true</return>
        public bool Exists(ProductsTableRow data)
        {
            TableSelectCommand command = BuildExistsCommand(data);
            DataSet result = connection.ExecuteQuery(command.GetCommand());

            int cnt = NumberUtil.IntValue(result.Tables[0].Rows[0][0]);
            if(cnt > 0) return true;
            else return false;
        }
        /// <summary>
        /// products̍s擾
        /// L[1s擾B
        /// قƂǂ̃NCAg͎gpȂ͂AeXgpƂĎgp\
        /// </summary>
        /// <param name="condition">L[ݒ肵f[^</param>
        public ProductsTableRow Get(ProductsTableRow condition)
        {
            TableSelectCommand command = BuildSelectCommand(condition);
            DataSet result = connection.ExecuteQuery(command.GetCommand());

            ProductsTableRow data = null;

            if(result.Tables[0].Rows.Count>0){
                data = new ProductsTableRow();
                data.Map(result.Tables[0].Rows[0],"products");
                data.IsNew = false;
            }
            return data;
        }
        /// <summary>
        /// products̍s擾
        /// [U[ݒɊYsׂĎ擾B
        /// قƂǂ̃NCAg͎gpȂ͂AeXgpƂĎgp\
        /// </summary>
        /// <param name="condition">WHERE</param>
        /// <param name="order">\[g</param>
        public List<ProductsTableRow> GetList( TableCommandCondition condition,List<TableCommandColumn> order)
        {
            ProductsTableRow data = null;

            TableSelectCommand command = BuildSelectCommand(condition,order);

            DataSet result = connection.ExecuteQuery(command.GetCommand());

			List<ProductsTableRow> list = new List<ProductsTableRow>();
            if(result.Tables[0].Rows.Count>0){
                for (int i = 0; i < result.Tables[0].Rows.Count; i++)
                {
	                data = new ProductsTableRow();
	                data.Map(result.Tables[0].Rows[0],"products");
                    data.IsNew = false;
                    list.Add(data);
                }
            }
            return list;
        }
#endregion
        /// <summary>
        /// productsւinsert sqlR}h
        /// </summary>
        /// <param name="data">ǉf[^</param>
        public TableInsertCommand BuildInsertCommand(ProductsTableRow data)
        {
            TableInsertCommand command = new TableInsertCommand("products");

            if (property.Id.DoUpdate) command.AddInsert(property.Id, data.Id);
            if (property.Name.DoUpdate) command.AddInsert(property.Name, data.Name);
            if (property.UnitPrice.DoUpdate) command.AddInsert(property.UnitPrice, data.UnitPrice);
            if (property.Description.DoUpdate) command.AddInsert(property.Description, data.Description);
            if (property.CategoryId.DoUpdate) command.AddInsert(property.CategoryId, data.CategoryId);
            
            return command;
        }
        /// <summary>
        /// productsւupdate sqlR}h(WHERE͎L[g)
        /// </summary>
        /// <param name="data">ύXf[^</param>
        public TableUpdateCommand BuildUpdateCommand(ProductsTableRow data)
        {
            TableUpdateCommand command = new TableUpdateCommand("products");

            //XV`
            if (property.Id.DoUpdate) command.AddUpdate(property.Id, data.Id);
            if (property.Name.DoUpdate) command.AddUpdate(property.Name, data.Name);
            if (property.UnitPrice.DoUpdate) command.AddUpdate(property.UnitPrice, data.UnitPrice);
            if (property.Description.DoUpdate) command.AddUpdate(property.Description, data.Description);
            if (property.CategoryId.DoUpdate) command.AddUpdate(property.CategoryId, data.CategoryId);
            

            //XV`
            command.AddWhere(new ColumnValueCondition( property.Id,"@PK_Id", data.Id,"="));
            
            return command;
        }

        /// <summary>
        /// productsւ̍XVSqlR}h(WHERE͊O炤)
        /// </summary>
        /// <param name="data">ύXf[^</param>
        /// <param name="condition">Ώۏ</param>
        public TableUpdateCommand BuildUpdateCommand(ProductsTableRow data, TableCommandCondition condition)
        {
            TableUpdateCommand command = new TableUpdateCommand("products");

            //XV`
            if (property.Id.DoUpdate) command.AddUpdate(property.Id, data.Id);
            if (property.Name.DoUpdate) command.AddUpdate(property.Name, data.Name);
            if (property.UnitPrice.DoUpdate) command.AddUpdate(property.UnitPrice, data.UnitPrice);
            if (property.Description.DoUpdate) command.AddUpdate(property.Description, data.Description);
            if (property.CategoryId.DoUpdate) command.AddUpdate(property.CategoryId, data.CategoryId);
            

            //XV`
            command.AddWhere(condition);

            return command;
        }

        /// <summary>
        /// productsւselect sqlR}h(WHERE͊O炤
        /// </summary>
        /// <param name="condition">Ώۏ</param>
        public TableDeleteCommand BuildDeleteCommand(TableCommandCondition condition)
        {
            TableDeleteCommand command = new TableDeleteCommand("products");


            //XV`
            command.AddWhere(condition);

            return command;
        }
        /// <summary>
        /// productsւdelete sqlR}h(WHERE͎L[g)
        /// </summary>
        /// <param name="data">Ώۏ</param>
        public TableDeleteCommand BuildDeleteCommand(ProductsTableRow data)
        {
            TableDeleteCommand command = new TableDeleteCommand("products");

            //XV`
            command.AddWhere(new ColumnValueCondition( property.Id,"@PK_Id", data.Id,"="));
            

            return command;
        }

        /// <summary>
        /// productsւselect count(*)(WHERE͎L[g)
        /// </summary>
        /// <param name="data">Ώۏ</param>
        public TableSelectCommand BuildExistsCommand(ProductsTableRow data)
        {
            TableSelectCommand command = new TableSelectCommand("products");

            //XV`
            command.AddSelect(new TableCommandColumn("CNT","COUNT(*)"));

            //XV`
            command.AddWhere(new ColumnValueCondition( property.Id,"@PK_Id", data.Id,"="));
            

            return command;
        }

        /// <summary>
        /// productsւselect sqlR}h(WHERE͎L[g)
        /// </summary>
        /// <param name="data">Ώۏ</param>
        public TableSelectCommand BuildSelectCommand(ProductsTableRow data)
        {
            TableSelectCommand command = new TableSelectCommand("products");

            //XV`
            command.AddSelect(property.Id);
            command.AddSelect(property.Name);
            command.AddSelect(property.UnitPrice);
            command.AddSelect(property.Description);
            command.AddSelect(property.CategoryId);
            

            //XV`
            command.AddWhere(new ColumnValueCondition( property.Id,"@PK_Id", data.Id,"="));
            

            return command;
        }

        /// <summary>
        /// productsւselect sqlR}h(WHERE͊O炤)
        /// </summary>
        /// <param name="condition">Ώۏ</param>
        /// <param name="order">\[g</param>
        public TableSelectCommand BuildSelectCommand(TableCommandCondition condition,List<TableCommandColumn> order)
        {
            TableSelectCommand command = new TableSelectCommand("products");

            //XV`
            command.AddSelect(property.Id);
            command.AddSelect(property.Name);
            command.AddSelect(property.UnitPrice);
            command.AddSelect(property.Description);
            command.AddSelect(property.CategoryId);
            

            //XV`
            if(condition != null)   command.AddWhere(condition);
            //
            if (order != null) command.OrderBy.AddRange(order);

            return command;
        }
        /// <summary>
        /// productsselect list
        /// </summary>
        /// <param name="tableAlias">e[uɕtʖ</param>
        /// <param name="columnAliasPrefix">ɕtʖ̐ړ</param>
        public string  GetSelectListString(string tableAlias , string columnAliasPrefix)
        {
        	StringBuilder builder = new StringBuilder();

            //XV`
            builder.AppendLine(", "+ tableAlias + ".id AS " + columnAliasPrefix + "id" );
            builder.AppendLine(", "+ tableAlias + ".name AS " + columnAliasPrefix + "name" );
            builder.AppendLine(", "+ tableAlias + ".unit_price AS " + columnAliasPrefix + "unit_price" );
            builder.AppendLine(", "+ tableAlias + ".description AS " + columnAliasPrefix + "description" );
            builder.AppendLine(", "+ tableAlias + ".category_id AS " + columnAliasPrefix + "category_id" );
            

            return builder.ToString().Substring(1);
        }
    }
}
