using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using CFW.Forms;
using CFW.Forms.Filters;
using CFW.Windows.Forms;
using CFW.Windows.Forms.Adapters;
namespace FormAdapterSample
{
    public partial class Form1 : Form
    {
        NumberInputElement element;
        DateInputElement dateElement;

        public Form1()
        {
            InitializeComponent();
            element = new NumberInputElement(numberInput);
            dateElement = new DateInputElement(dateInput);
        }

        private void doBindButton_Click(object sender, EventArgs e)
        {
            element.UpdateField();
            resultText.Text = (element.Validate()) ? CFW.Util.StringUtil.StringValue(element.GetValue()) : element.ErrorMessage;
        }

        private void doApplyButton_Click(object sender, EventArgs e)
        {
            int precision = CFW.Util.NumberUtil.Value<int>(precisionInput.Text);
            int scale = CFW.Util.NumberUtil.Value<int>(scaleInput.Text);
            element.setup(precision,scale,"");

        }

        private void button3_Click(object sender, EventArgs e)
        {
            using (NumberInputTest form = new NumberInputTest())
            {
                form.ShowDialog();
            }
        }

        private void button4_Click(object sender, EventArgs e)
        {
            using (DateInputTest form = new DateInputTest())
            {
                form.ShowDialog();
            }

        }

        private void doApplyButton2_Click(object sender, EventArgs e)
        {
            dateElement.setup(inputFormatInput.Text, outputFormatInput.Text);

        }

        private void doBindButton2_Click(object sender, EventArgs e)
        {
            dateElement.UpdateField();
            dateInputResult.Text = (dateElement.Validate()) ? CFW.Util.DateUtil.Format(dateElement.GetValue(), "yyyy/MM/dd HH:mm:ss.fff") : dateElement.ErrorMessage;

        }

        private void button1_Click(object sender, EventArgs e)
        {
            using (FilterCheckForm form = new FilterCheckForm())
            {
                form.ShowDialog();
            }
        }
    }
}