using System;
using System.Collections.Generic;
using System.Text;

namespace ErrorHandling.Forms
{
    public class SampleFormAdapter : CFW.Forms.FormAdapter
    {
        public CFW.Forms.FormAdapterElement valueA;
        public CFW.Forms.FormAdapterElement valueB;

        Model.SampleEntity entity;

        public override bool Validate()
        {
            bool valid = true;
            if (!valueA.Validate()) valid = false;
            if (!valueA.Validate()) valid = false;

            return valid;
        }

        public override void UpdateFields()
        {
            this.valueA.UpdateField();
            this.valueB.UpdateField();
        }

        public override void SetDataSource(object dataSource)
        {
            this.entity = dataSource as Model.SampleEntity;
        }

        public override object GetDataSource()
        {
            return this.entity;
        }

        public override void UpdateDataSource()
        {
            this.entity.valueA = CFW.Util.NumberUtil.Value<decimal>(this.valueA.GetValue());
            this.entity.valueB = CFW.Util.NumberUtil.Value<decimal>(this.valueB.GetValue());
        }

        public override void RenderView()
        {

            this.valueA.Render();
            this.valueB.Render();
        }
    }
}
