using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Diagnostics;
using CFW.Database;

namespace DbPerfCheck
{
    public partial class Form1 : Form
    {
        const int COMMAND_REPEAT_MAX = 1000;
        Random randomGenerator1 = new Random();
        Random randomGenerator2 = new Random();

        public Form1()
        {
            InitializeComponent();
        }

        private void checkPerformance1()
        {
            Connection connection = ConnectionFactory.GetConnectionByName("default");
            connection.Open();
            for (int i = 0; i < COMMAND_REPEAT_MAX; i++)
            {
                Command command = createInPlaceParameterCommand();
                command.SetConnection(connection);
                DataSet result = command.ExecuteQuery();
            }
            connection.Close();
        }
        private void checkPerformance2()
        {
            Connection connection = ConnectionFactory.GetConnectionByName("default");
            connection.Open();
            for (int i = 0; i < COMMAND_REPEAT_MAX; i++)
            {
                Command command = createBindParameterCommand();
                command.SetConnection(connection);
                DataSet result = command.ExecuteQuery();
            }
            connection.Close();
        }

        private void checkPerformance3()
        {
            Connection connection = ConnectionFactory.GetConnectionByName("default");
            connection.Open();
            for (int i = 0; i < COMMAND_REPEAT_MAX; i++)
            {
                Command command = createInPlaceParameterCommand2();
                command.SetConnection(connection);
                DataSet result = command.ExecuteQuery();
            }
            connection.Close();
        }
        private Command createInPlaceParameterCommand()
        {
            string query = @"select * from test_table3
where field1 between {0} and {1}
and (field5 = {2} or field5 = {3} )";
            Command command = new Command(String.Format(query, generateRandomField1(), generateRandomField1(), generateRandomField5(), generateRandomField5()));
            return command;

        }
        private Command createInPlaceParameterCommand2()
        {
            string query = @"select * from test_table3
where field1 between " + generateRandomField1().ToString() + " and " + generateRandomField1().ToString() + @"
and (field5 = " + generateRandomField5().ToString() + " or field5 = " + generateRandomField5().ToString() + " )";
            Command command = new Command(query);
            return command;

        }
        private Command createBindParameterCommand()
        {
            string query = @"select * from test_table3
where field1 between @p1 and @p2
and (field5 = @p3 or field5 = @p4 )";
            Command command = new Command(query);
            command.SetParameter(new Parameter("@p1", generateRandomField1()));
            command.SetParameter(new Parameter("@p2", generateRandomField1()));
            command.SetParameter(new Parameter("@p3", generateRandomField5()));
            command.SetParameter(new Parameter("@p4", generateRandomField5()));
            return command;


        }
        public int generateRandomField1()
        {
            int value = randomGenerator1.Next(300);
            return value;
        }
        public short generateRandomField5()
        {
            short value = (short) randomGenerator2.Next(500);
            return value;
        }
        private void button1_Click(object sender, EventArgs e)
        {
            Stopwatch sw = new Stopwatch();
            sw.Start();
            checkPerformance1();
            sw.Stop();
            resultText1.Text = sw.ElapsedMilliseconds.ToString("#,##0 msec");
        }
        private void button2_Click(object sender, EventArgs e)
        {
            Stopwatch sw = new Stopwatch();
            sw.Start();
            checkPerformance2();
            sw.Stop();
            resultText2.Text = sw.ElapsedMilliseconds.ToString("#,##0 msec");

        }

        private void button3_Click(object sender, EventArgs e)
        {

            Stopwatch sw = new Stopwatch();
            sw.Start();
            checkPerformance3();
            sw.Stop();
            resultText3.Text = sw.ElapsedMilliseconds.ToString("#,##0 msec");
        }
    }
}