using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using CFW.Database;
using CFW.Database.CommandBuilder;
using Oracle.DataAccess.Client;
using System.Data.SqlClient;
using System.Diagnostics;

namespace Connection
{
    public partial class OracleTestForm : Form
    {
        const int REPEAT_MAX = 2000;
        public OracleTestForm()
        {
            InitializeComponent();
        }

        private void button1_Click(object sender, EventArgs e)
        {
            using (CFW.Database.Connection connection = CFW.Database.ConnectionFactory.GetConnectionByName("xe"))
            {
                connection.Open();
                Command command = new Command("select * from sample1 order by id");
                command.SetConnection(connection);
                DataSet result = command.ExecuteQuery();

                dataGridView1.AutoGenerateColumns = true;
                dataGridView1.DataSource = result.Tables[0];
                dataGridView1.Refresh();

                connection.Close();
            }
        }

        private void button2_Click(object sender, EventArgs e)
        {
            using (OracleConnection con = new OracleConnection())
            {
                con.ConnectionString = "User Id=sample; Password=sample; Data Source=MyDB";
                for (int i = 0; i < 100; i++)
                {
                    con.Open();
                    con.Close();
                }
                con.Open();

                try
                {

                    // CommandIuWFNg
                    using (OracleCommand cmd = con.CreateCommand())
                    {
                        // NG
                        cmd.CommandText = "select * from user_tab_columns where table_name = @name1";

                        // oChE\bhwiOwp[^j
                        cmd.BindByName = true;

                        // p[^̐ivCXz_𖼑OŎwj
                        OracleParameter para1 = new OracleParameter();
                        para1.ParameterName = ":name1";
                        para1.Value = "SAMPLE1";
                        cmd.Parameters.Add(para1);

                        cmd.CommandText = cmd.CommandText.Replace("@", ":");

                        // NG̎s
                        using (OracleDataReader reader = cmd.ExecuteReader())
                        {
                            while (reader.Read())
                            {
                                // J
                                Console.WriteLine(reader[0]);
                                Console.WriteLine(reader[1]);
                            }
                        }
                    }
                }
                finally
                {
                    if (con != null)
                    {
                        con.Close();
                    }
                }
            }

        }
        private void button3_Click(object sender, EventArgs e)
        {
            using (CFW.Database.Connection connection = CFW.Database.ConnectionFactory.GetConnectionByName("xe"))
            {

                CFW.Models.IEntityProperty property = null;
                try
                {
                    connection.Open();
                    property = connection.DescribeTable("SAMPLE1");
                }
                finally
                {
                    connection.Close();
                }

                textBox1.Text = "";
                if (property == null)
                {

                    textBox1.Text = "not found";
                    return;
                }
                foreach (CFW.FieldProperties.FieldProperty p in property.Fields())
                {
                    textBox1.AppendText(formatFieldProperty(p));
                    textBox1.AppendText(Environment.NewLine);
                }
            }

        }

        private void button4_Click(object sender, EventArgs e)
        {
            Stopwatch w = new Stopwatch();
            w.Start();

            Command command = new Command("select * from sample1 order by id");
            for (int i = 0; i < 10000; i++)
            {
                string pn = @"[@test{0}]";

                command.AddParameter(new Parameter(string.Format(pn,i), DbType.String,string.Format( "aaa {0}",i )));
            }

            w.Stop();

            textBox1.Text = string.Format("create elapsed {0} ms\r\n", w.ElapsedMilliseconds);

            SqlCommand com = new SqlCommand(command.Text);

            w.Reset();
            w.Start();
            int j = 0;
            foreach (Parameter p in command.Parameters)
            {
                SqlParameter param = com.CreateParameter();
                param.ParameterName = p.ParameterName;
                param.DbType = p.ParameterType;

                param.Direction = p.ParameterDirection;
                com.Parameters.Add(param);
                j++;

            }
            w.Stop();

            textBox1.AppendText( string.Format( "{0} elapsed {1} ms",j,w.ElapsedMilliseconds) );

        }

        private void button5_Click(object sender, EventArgs e)
        {
            using (CFW.Database.Connection con = ConnectionFactory.GetConnectionByName("xe"))
            {


                try
                {
                    con.Open();
                    ConditionFactory cf = new ConditionFactory(con);
                    SelectCommandBuilder builder = new SelectCommandBuilder(con);
                    Command command = builder.from("sample1")
                        .select(new string[] { "id", "short_field", "string_field1", "string_field2" })
                        .where(cf.create("id", 1, "="))
                        .orderBy("string_field1", "DESC")
                        .getCommand();

                    command.SetConnection(con);
                    DataSet result = command.ExecuteQuery();

                    dataGridView2.AutoGenerateColumns = true;
                    dataGridView2.DataSource = result.Tables[0];
                    dataGridView2.Refresh();

                }
                finally
                {
                    con.Close();
                }
            }

        }

        private void button6_Click(object sender, EventArgs e)
        {
            CFW.Database.Connection con = ConnectionFactory.GetConnectionByName("xe");
            try
            {
                con.Open();
                ConditionFactory cf = new ConditionFactory(con);
                SelectCommandBuilder builder = new SelectCommandBuilder(con);
                Command command = builder.from("sample1")
                    .select(new string[] { "id", "short_field", "string_field1", "string_field2" })
                    .where(cf.create("id", con.buildParameterName("id1"), 1, "="))
                    .whereOr(cf.create("id", con.buildParameterName("id2"), 4, "="))
                    .whereOr(cf.create("id", con.buildParameterName("id3"), 100, ">"))
                    .orderBy("string_field1", "DESC")
                    .getCommand();

                command.SetConnection(con);
                DataSet result = command.ExecuteQuery();

                dataGridView2.AutoGenerateColumns = true;
                dataGridView2.DataSource = result.Tables[0];
                dataGridView2.Refresh();

            }
            finally
            {
                con.Close();
            }

        }

        private void button7_Click(object sender, EventArgs e)
        {
            try
            {
                ConnectionTest.Models.Sample1Model model = new ConnectionTest.Models.Sample1Model();
                List<ConnectionTest.Models.Sample1Entity> list = model.find2();

                dataGridView2.AutoGenerateColumns = true;
                dataGridView2.DataSource = list;
                dataGridView2.Refresh();
            }
            finally
            {

            }
        }

        private void button8_Click(object sender, EventArgs e)
        {
            try
            {
                ConnectionTest.Models.Sample1Model model = new ConnectionTest.Models.Sample1Model();
                List<ConnectionTest.Models.Sample1Entity> list = model.find3(textBox2.Text);

                dataGridView2.AutoGenerateColumns = true;
                dataGridView2.DataSource = list;
                dataGridView2.Refresh();
            }
            finally
            {

            }

        }

        private void button9_Click(object sender, EventArgs e)
        {
            using (CFW.Database.Connection connection = CFW.Database.ConnectionFactory.GetConnectionByName())
            {

                CFW.Models.IEntityProperty property = null;
                try
                {
                    connection.Open();
                    property = connection.DescribeTable("sample1");
                }
                finally
                {
                    connection.Close();
                }

                textBox1.Text = "";
                if (property == null)
                {

                    textBox1.Text = "not found";
                    return;
                }
                foreach (CFW.FieldProperties.FieldProperty p in property.Fields())
                {
                    textBox1.AppendText(formatFieldProperty(p));
                    textBox1.AppendText(Environment.NewLine);
                }
            }

        }
        private string formatFieldProperty(CFW.FieldProperties.FieldProperty p)
        {
            string s = 
            p.TableName + 
            "." +
            p.FieldName +
            " [" +
            p.DisplayName +
            "] " +
            p.sqlTypeName +
            " " +
            p.Length.ToString() +
            " " +
            p.Precision.ToString() +
            " " +
            p.Scale.ToString() +
            " " +
            CFW.Util.NumberUtil.FormatBool(p.IsNullable, "null", "not null") +
            " " +
            CFW.Util.NumberUtil.FormatBool(p.IsPrimaryKey, "PK", " ");
            return s;
        }

        private void button10_Click(object sender, EventArgs e)
        {
            Stopwatch sw = new Stopwatch();
            sw.Start();
            string connectionString = "User Id=sample; Password=sample; Data Source=MyDB";
            for (int i = 0; i < REPEAT_MAX; i++)
            {
                using (OracleConnection con = new OracleConnection())
                {
                    con.ConnectionString = connectionString;
                    con.Open();
                }
            }
            sw.Stop();
            textBox3.AppendText( string.Format("with using elapsed {0:#,##0}", sw.ElapsedMilliseconds ) );
            textBox3.AppendText(Environment.NewLine);

        }

        private void button11_Click(object sender, EventArgs e)
        {
            Stopwatch sw = new Stopwatch();
            sw.Start();

            string connectionString = "User Id=sample; Password=sample; Data Source=MyDB";
            for (int i = 0; i < REPEAT_MAX; i++)
            {
                OracleConnection con = new OracleConnection();
                con.ConnectionString = connectionString;
                con.Open();
                con.Close();
            }

            sw.Stop();
            textBox3.AppendText(string.Format("withotu using elapsed {0:#,##0}", sw.ElapsedMilliseconds));
            textBox3.AppendText(Environment.NewLine);
        }

        private void button12_Click(object sender, EventArgs e)
        {
            Stopwatch sw = new Stopwatch();
            sw.Start();
            string connectionString = "User Id=sample; Password=sample; Data Source=MyDB";
            for (int i = 0; i < REPEAT_MAX; i++)
            {
                using (OracleConnection con = new OracleConnection())
                {
                    con.ConnectionString = connectionString;
                    
                    con.Open();
                }
                Oracle.DataAccess.Client.OracleConnection.ClearAllPools();
            }
            sw.Stop();
            textBox3.AppendText(string.Format("with using+clear elapsed {0:#,##0}", sw.ElapsedMilliseconds));
            textBox3.AppendText(Environment.NewLine);

        }

        private void button13_Click(object sender, EventArgs e)
        {
            textBox3.AppendText(string.Format("System.Data.OracleClient requires sql.net 8.1.7>"));
            textBox3.AppendText(Environment.NewLine);


        }

    }
}