using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using CFW.Models;
using CFW.FieldProperties;

namespace Connection
{
    public partial class Form1 : Form
    {
        DataSet allMenuSet = null;
        List<ApplicationMenuEntity> allMenuList = null;
        SampleModel model;
        public Form1()
        {
            InitializeComponent();
            model = new SampleModel();
        }

        private void button1_Click(object sender, EventArgs e)
        {
            allMenuSet = model.getAll();
            render();
            
        }
        private void render()
        {
            if (allMenuSet == null)
            {
                textBox1.Text = "no result";
            }
            textBox1.Text = "";
            DataRowCollection rows = allMenuSet.Tables[0].Rows;
            foreach (DataRow row in rows) 
            {
                textBox1.AppendText(CFW.Util.StringUtil.StringValue( row[0] ));
                textBox1.AppendText("\t");
                textBox1.AppendText(CFW.Util.StringUtil.StringValue(row[1]));
                textBox1.AppendText("\t");
                textBox1.AppendText(CFW.Util.StringUtil.StringValue(row[2]));
                textBox1.AppendText("\t");
                textBox1.AppendText(CFW.Util.StringUtil.StringValue(row[3]));
                textBox1.AppendText("\t");
                textBox1.AppendText(CFW.Util.StringUtil.StringValue(row[4]));
                textBox1.AppendText("\t");
                textBox1.AppendText(CFW.Util.StringUtil.StringValue(row[5]));
                textBox1.AppendText(Environment.NewLine);
            }
        }
        private void render2()
        {
            if (allMenuList == null)
            {
                textBox1.Text = "no result";
            }
            textBox1.Text = "";
            foreach (ApplicationMenuTableRow item in allMenuList)
            {
                textBox1.AppendText(CFW.Util.StringUtil.StringValue(item.id));
                textBox1.AppendText("\t");
                textBox1.AppendText(CFW.Util.StringUtil.StringValue(item.name));
                textBox1.AppendText("\t");
                textBox1.AppendText(CFW.Util.StringUtil.StringValue(item.displayName));
                textBox1.AppendText("\t");
                textBox1.AppendText(CFW.Util.StringUtil.StringValue(item.description));
                textBox1.AppendText("\t");
                textBox1.AppendText(CFW.Util.StringUtil.StringValue(item.createdAt));
                textBox1.AppendText("\t");
                textBox1.AppendText(CFW.Util.StringUtil.StringValue(item.modifiedAt));
                textBox1.AppendText(Environment.NewLine);
            }
        }

        private void button2_Click(object sender, EventArgs e)
        {
            allMenuList = model.getAll2();
            render2();

        }

        private void button3_Click(object sender, EventArgs e)
        {
            using (OracleTestForm form = new OracleTestForm())
            {
                form.ShowDialog();
            }
        }

        private void button5_Click(object sender, EventArgs e)
        {
            System.Diagnostics.Stopwatch sw = new System.Diagnostics.Stopwatch();
            sw.Start();
            for (int i = 0; i < 1000; i++)
            {
                using (CFW.Database.Connection connection = CFW.Database.ConnectionFactory.GetConnectionByName("xe"))
                {
                    connection.Open();
                }
            }
            sw.Stop();
            textBox1.Text = sw.ElapsedMilliseconds.ToString("#,##0ms");
        }

        private void button6_Click(object sender, EventArgs e)
        {
            System.Diagnostics.Stopwatch sw = new System.Diagnostics.Stopwatch();
            sw.Start();
            for (int i = 0; i < 1000; i++)
            {
                CFW.Database.Connection connection = CFW.Database.ConnectionFactory.GetConnectionByName("xe");
                connection.Open();
                connection.Close();
            }
            sw.Stop();
            textBox1.Text = sw.ElapsedMilliseconds.ToString("#,##0ms");

        }

        private void button7_Click(object sender, EventArgs e)
        {
            BusinessLogic logic = new BusinessLogic();
            textBox1.Text = logic.GetMessage1();
        }

        private void button8_Click(object sender, EventArgs e)
        {
            System.Diagnostics.Stopwatch sw = new System.Diagnostics.Stopwatch();
            sw.Start();

            Attr.EntityPropertyFactory factory = new Connection.Attr.EntityPropertyFactory();
            factory.typeStringDefault = textBox2.Text;
            CFW.Models.IEntityProperty property = factory.getProperty(typeof(ConnectionTest.Models.Sample2Entity));
            sw.Stop();

            textBox1.Text = "";
            foreach (CFW.FieldProperties.FieldProperty p in property.Fields())
            {
                textBox1.AppendText(formatFieldProperty(p));
                textBox1.AppendText(Environment.NewLine);
            }
            textBox1.AppendText( ((double)sw.ElapsedTicks / (double)TimeSpan.TicksPerMillisecond) .ToString("#,##0.000ms") );
            DefaultEntityProperty property2 = factory.getProperty(typeof(ConnectionTest.Models.Sample2Entity)) as DefaultEntityProperty;
            property2["number_field3"].DoUpdate = false;
            property2["number_field2"].DoUpdate = false;
            property2["number_field1"].DoUpdate = false;

            foreach (CFW.FieldProperties.FieldProperty p in property2.Fields())
            {
                p.FieldName += "2";
            }
            
            foreach (CFW.FieldProperties.FieldProperty p in property.Fields())
            {
                textBox1.AppendText(formatFieldProperty(p));
                textBox1.AppendText(Environment.NewLine);
            }

        }
        private string formatFieldProperty(CFW.FieldProperties.FieldProperty p)
        {
            string s =
            p.TableName +
            "." +
            p.FieldName +
            " [" +
            p.DisplayName +
            "] " +
            p.sqlTypeName +
            " " +
            p.Length.ToString() +
            " " +
            p.Precision.ToString() +
            " " +
            p.Scale.ToString() +
            " " +
            CFW.Util.NumberUtil.FormatBool(p.IsNullable, "null", "not null") +
            " " +
            CFW.Util.NumberUtil.FormatBool(p.IsPrimaryKey, "PK", " ");
            return s;
        }

        private void button9_Click(object sender, EventArgs e)
        {

            System.Diagnostics.Stopwatch sw = new System.Diagnostics.Stopwatch();
            sw.Start();

            ConnectionTest.Models.Base.Sample1TableProperty property = new ConnectionTest.Models.Base.Sample1TableProperty();
            sw.Stop();
            textBox1.Text = "";
            foreach (CFW.FieldProperties.FieldProperty p in property.Fields())
            {
                textBox1.AppendText(formatFieldProperty(p));
                textBox1.AppendText(Environment.NewLine);
            }
            textBox1.AppendText(((double)sw.ElapsedTicks / (double)TimeSpan.TicksPerMillisecond).ToString("#,##0.000ms"));
            textBox1.AppendText(Environment.NewLine);
            sw.Reset();

            sw.Start();
            for (int i = 0; i < 100; i++)
            {
                CFW.Models.IEntityProperty pp = property.Clone() as CFW.Models.IEntityProperty;
            }
            sw.Stop();
            textBox1.AppendText("clone elapsed ");
            textBox1.AppendText(((double)sw.ElapsedTicks / (double)TimeSpan.TicksPerMillisecond).ToString("#,##0.000000ms"));
            textBox1.AppendText(Environment.NewLine);


        }

    }
}