using System;
using System.Collections.Generic;
using System.Text;
using System.Reflection;
using CFW.FieldProperties;
using CFW.Models;
using CFW.Database;
namespace Connection.Attr
{
    public class FieldAttribute : Attribute
    {
        public string sqlTypeName = "";
        public string entityName = "";
        public string fieldName = "";
        public string displayName = "";
        public int length = 0;
        public int precision = 0;
        public int scale = 0;
        public bool nullable = true;
        public object defaultValue = null;

        public FieldAttribute()
        {
        }

    }
    public class PrimaryKeyFieldAttribute : Attribute
    {
        public PrimaryKeyFieldAttribute()
        {
        }
    }
    public class IdentityFieldAttribute : Attribute
    {
        public IdentityFieldAttribute()
        {

        }
    }
    public class ModifiedAtFieldAttribute : Attribute
    {
        public ModifiedAtFieldAttribute()
        {

        }
    }
    public class CreatedAtFieldAttribute : Attribute
    {
        public CreatedAtFieldAttribute()
        {

        }
    }

    public class ColumnAttribute : Attribute
    {
        public FieldProperty p;
        public ColumnAttribute(string sqlTypeName, string tableName, string columnName, string displayName, int length, int prec, int scale, bool nullable, object columnDef, bool isPrimaryKey)
        {
            p = FieldProperty.NewInstance(sqlTypeName, tableName, columnName, displayName, length, prec, scale, nullable, columnDef, isPrimaryKey);
        }

    }
    public class EntityAttribute : Attribute
    {
        public string tableName = "";

        public EntityAttribute(string name)
        {
            tableName = name;
        }

    }

    public class EntityPropertyFactory
    {
        public string typeStringDefault;

        static Dictionary<string, DefaultEntityProperty> dict = new Dictionary<string, DefaultEntityProperty>();
        public EntityPropertyFactory()
        {
        }
        public IEntityProperty getProperty(Type t)
        {
            if (dict.ContainsKey(t.FullName))
            {
                return dict[t.FullName].Clone() as DefaultEntityProperty;
            }
            EntityAttribute a = getTableAttribute(t);
            if (a == null) return null;

            DefaultEntityProperty tableProperty = new DefaultEntityProperty();
            tableProperty.EntityName = a.tableName;
            tableProperty.entityType = t;

            PropertyInfo[] typeProperties = t.GetProperties();

            foreach (PropertyInfo property in typeProperties)
            {
                FieldAttribute attr = getFieldAttribute(property);
                if (attr == null) continue;
                FieldProperty p = createFieldProperty(attr, property);
                tableProperty.fieldList.Add(p);

                PrimaryKeyFieldAttribute pkey = getAttribute(property, typeof(PrimaryKeyFieldAttribute)) as PrimaryKeyFieldAttribute;
                if (pkey != null)
                {
                    tableProperty.primaryKeyList.Add(p);
                }
                ModifiedAtFieldAttribute modifiedAt = getAttribute(property, typeof(ModifiedAtFieldAttribute)) as ModifiedAtFieldAttribute;
                if (modifiedAt != null)
                {
                    tableProperty.ModifiedAtField = p.FieldName;
                }
                CreatedAtFieldAttribute createdAt = getAttribute(property, typeof(CreatedAtFieldAttribute)) as CreatedAtFieldAttribute;
                if (createdAt != null)
                {
                    tableProperty.CreatedAtField = p.FieldName;
                }



            }
            dict[t.FullName] = tableProperty;
            return tableProperty;
            
        }
        FieldProperty createFieldProperty(FieldAttribute attribute, PropertyInfo property)
        {
            //e\z@ł̔r
            //1. ^ɂՍ\z
            FieldProperty p = FieldProperty.NewInstance(getBaseType(property));
            p.TableName = attribute.entityName;
            p.FieldName = attribute.fieldName;
            p.DisplayName = attribute.displayName;
            p.setSize(attribute.length, attribute.precision, attribute.scale);
            p.IsNullable = attribute.nullable;
            p.DefaultValue = attribute.defaultValue;

            //2. SQL^\zQ
            //FieldProperty p = FieldProperty.NewInstance(attribute.sqlTypeName);
            //p.TableName = attribute.entityName;
            //p.FieldName = attribute.fieldName;
            //p.DisplayName = attribute.displayName;
            //p.setSize(attribute.length, attribute.precision, attribute.scale);
            //p.IsNullable = attribute.nullable;
            //p.DefaultValue = attribute.defaultValue;

            //t2m̍\z
            //FieldProperty p = FieldProperty.NewInstance(typeStringDefault, attribute.entityName, attribute.fieldName, attribute.displayName, 4, 10, 0, false,0, true);


            return p;
            
        }
        Type getBaseType(PropertyInfo property)
        {
            Type t = property.PropertyType;
            //Nullable<T>T
            if (t.IsGenericType)
            {
                t = t.GetGenericArguments()[0];
            }
            return t;
            
        }
        EntityAttribute getTableAttribute(Type t)
        {
            object[] attrs = t.GetCustomAttributes(typeof(EntityAttribute), true);
            if (attrs == null) return null;
            return attrs[0] as EntityAttribute;
        }
        FieldAttribute getFieldAttribute(PropertyInfo p)
        {
            object[] attrs = p.GetCustomAttributes(typeof(FieldAttribute), true);
            if (attrs == null) return null;
            if (attrs.Length == 0) return null;
            return attrs[0] as FieldAttribute;

        }
        Attribute getAttribute(PropertyInfo property, Type targetAttribute)
        {
            object[] attrs = property.GetCustomAttributes(targetAttribute, true);
            if (attrs == null) return null;
            if (attrs.Length == 0) return null;
            return attrs[0] as Attribute;

        }
    }
}
