using System;
using System.Collections.Generic;
using System.Text;
using CFW.Forms;
using CFW.Forms.Filters;
using CFW.Util;
using CFW.Sample.Test4;
using CFW.Sample.Test4.TableRow;
using CFW.Sample.Test4.TableProperty;
using CFW.Sample.Test4.TableValidator;


namespace CFW.Sample.Test4.TableFormAdapter
{
    /// <summary>
    /// table users Field`
    /// </summary>
    public class UsersTableFormAdapter : CFW.Forms.FormAdapter
	{
		private UsersTableRow table;

		///<summary>[user_id]</summary>
		public FormAdapterElement UserId;
		///<summary>[password]</summary>
		public FormAdapterElement Password;
		///<summary>[user_name]</summary>
		public FormAdapterElement UserName;
		///<summary>[num_fields]</summary>
		public FormAdapterElement NumFields;
		///<summary>[birthday]</summary>
		public FormAdapterElement Birthday;
		///<summary>[created_at]</summary>
		public FormAdapterElement CreatedAt;
		///<summary>[modified_at]</summary>
		public FormAdapterElement ModifiedAt;
		

		/// <summary>݂̃f[^\[X擾
		/// </summary>
        public override object GetDataSource()
        {
            return this.table;
        }
		/// <summary>\̍XV
		/// </summary>
        public override void RenderView()
        {
			this.UserId.Render();
			this.Password.Render();
			this.UserName.Render();
			this.NumFields.Render();
			this.Birthday.Render();
			this.CreatedAt.Render();
			this.ModifiedAt.Render();
			
        }

		/// <summary>̃A_v^[f[^ݒ
		/// </summary>
        /// <param name="dataSource">̃A_v^[f[^</param>
        public override void SetDataSource(object dataSource)
        {
        	this.table = (UsersTableRow)dataSource;
			this.UserId.SetValue(this.table.UserId);
			this.Password.SetValue(this.table.Password);
			this.UserName.SetValue(this.table.UserName);
			this.NumFields.SetValue(this.table.NumFields);
			this.Birthday.SetValue(this.table.Birthday);
			this.CreatedAt.SetValue(this.table.CreatedAt);
			this.ModifiedAt.SetValue(this.table.ModifiedAt);
			

        }

		/// <summary>UI͂ꂽef[^\[XɎ荞
		/// </summary>
        public override void UpdateDataSource()
        {
			this.table.UserId = StringUtil.StringValue(this.UserId.GetValue());
			this.table.Password = StringUtil.StringValue(this.Password.GetValue());
			this.table.UserName = StringUtil.StringValue(this.UserName.GetValue());
			this.table.NumFields = NumberUtil.Value<Int32?>(this.NumFields.GetValue());
			this.table.Birthday = DateUtil.DateValue(this.Birthday.GetValue());
			this.table.CreatedAt = DateUtil.DateValue(this.CreatedAt.GetValue());
			this.table.ModifiedAt = DateUtil.DateValue(this.ModifiedAt.GetValue());
			
        }

		/// <summary>UI͂ꂽe荞
		/// </summary>
        public override void UpdateFields()
        {
			this.UserId.UpdateField();
			this.Password.UpdateField();
			this.UserName.UpdateField();
			this.NumFields.UpdateField();
			this.Birthday.UpdateField();
			this.CreatedAt.UpdateField();
			this.ModifiedAt.UpdateField();
			
        }

		/// <summary>͓e؂
		/// </summary>
        public override bool Validate()
        {
            bool valid = true;
			if(!this.UserId.Validate()) valid = false;
			if(!this.Password.Validate()) valid = false;
			if(!this.UserName.Validate()) valid = false;
			if(!this.NumFields.Validate()) valid = false;
			if(!this.Birthday.Validate()) valid = false;
			if(!this.CreatedAt.Validate()) valid = false;
			if(!this.ModifiedAt.Validate()) valid = false;
			

            return valid;
        }
		
	}

}