using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using System.Data.SqlClient;
using System.Xml;
using System.Xml.Serialization;
using CFW.Util;
using CFW.FieldProperties;
using CFW.Database;
using CFW.Database.TableCommand;
using CFW.Sample.Test4;
using CFW.Sample.Test4.TableRow;
using CFW.Sample.Test4.TableProperty;


namespace CFW.Sample.Test4.TableAccess
{
    /// <summary>
    /// table[users]ɑ΂鑀
    /// </summary>
    [Serializable()]
    public class UsersTableAccess
    {
        /// <summary>
        /// f[^\[Xւ̐ڑ
        /// </summary>
        private Connection connection;
        /// <summary>
        /// usersɑΉvpeB
        /// </summary>
        private UsersTableProperty property;



#region constructors
        /// <summary>
        /// default construct  gps
        /// </summary>
        private UsersTableAccess()
        {
            this.connection = ConnectionFactory.GetConnectionByName("default");
            this.property = new UsersTableProperty();
        }
        /// <summary>
        /// ̐ڑgp\z
        /// </summary>
        public UsersTableAccess(Connection db)
        {
            this.connection = db;
            this.property = new  UsersTableProperty();
        }
        /// <summary>
        /// ̐ڑAvpeBgp\z
        /// </summary>
        /// <param name="db">̐ڑBJĂO</param>
        /// <param name="property">̃vpeB</param>
        public UsersTableAccess(Connection db, UsersTableProperty property)
        {
            this.connection = db;
            this.property = property;
        }
#endregion

#region public interface
        /// <summary>
        /// users֍s̑}
        /// </summary>
        /// <param name="data">}sf[^</param>
        public int Insert(UsersTableRow data)
        {
            TableInsertCommand command = BuildInsertCommand(data);
            int ret = connection.ExecuteUpdate(command.GetCommand());
            return ret;
        }

        /// <summary>
        /// users֍s̍XV
        /// </summary>
        /// <param name="data">XVsf[^</param>
        public int Update(UsersTableRow data)
        {
            TableUpdateCommand command = BuildUpdateCommand(data);
            int ret = connection.ExecuteUpdate(command.GetCommand());
            return ret;
        }
        /// <summary>
        /// users֍s̍XV
        /// </summary>
        /// <remarks>where͌ĂяogݗāAp[^Ăяo</remarks>
        /// <param name="data">XVsf[^</param>
        /// <param name="condition"></param>
        public int Update(UsersTableRow data,  TableCommandCondition condition)
        {
            TableUpdateCommand command = BuildUpdateCommand(data,condition);
            int ret = connection.ExecuteUpdate(command.GetCommand());
            return ret;
        }
        /// <summary>
        /// userss̍폜
        /// </summary>
        /// <param name="data">폜sf[^BL[̂݃ZbgłĂOK</param>
        public int Delete(UsersTableRow data)
        {
            TableDeleteCommand command = BuildDeleteCommand(data);
            int ret = connection.ExecuteUpdate(command.GetCommand());
            return ret;
        }
        /// <summary>
        /// userss̍폜
        /// </summary>
        /// <remarks>where͌ĂяogݗāAp[^Ăяo</remarks>
        /// <param name="condition"></param>
        public int Delete(TableCommandCondition condition)
        {
            TableDeleteCommand command = BuildDeleteCommand(condition);
            int ret = connection.ExecuteUpdate(command.GetCommand());
            return ret;
        }
        /// <summary>
        /// users̍s݊mF
        /// </summary>
        /// <param name="data">L[ݒ肵f[^</param>
        /// <return>ݒ肵L[ɊYs݂鎞true</return>
        public bool Exists(UsersTableRow data)
        {
            TableSelectCommand command = BuildExistsCommand(data);
            DataSet result = connection.ExecuteQuery(command.GetCommand());

            int cnt = NumberUtil.IntValue(result.Tables[0].Rows[0][0]);
            if(cnt > 0) return true;
            else return false;
        }
        /// <summary>
        /// users̍s擾
        /// L[1s擾B
        /// قƂǂ̃NCAg͎gpȂ͂AeXgpƂĎgp\
        /// </summary>
        /// <param name="condition">L[ݒ肵f[^</param>
        public UsersTableRow Get(UsersTableRow condition)
        {
            TableSelectCommand command = BuildSelectCommand(condition);
            DataSet result = connection.ExecuteQuery(command.GetCommand());

            UsersTableRow data = null;

            if(result.Tables[0].Rows.Count>0){
                data = new UsersTableRow();
                data.FromDataRow(result.Tables[0].Rows[0],"users");
                data.IsNew = false;
            }
            return data;
        }
        /// <summary>
        /// users̍s擾
        /// [U[ݒɊYsׂĎ擾B
        /// قƂǂ̃NCAg͎gpȂ͂AeXgpƂĎgp\
        /// </summary>
        /// <param name="condition">WHERE</param>
        /// <param name="order">\[g</param>
        public List<UsersTableRow> GetList( TableCommandCondition condition,List<TableCommandColumn> order)
        {
            UsersTableRow data = null;

            TableSelectCommand command = BuildSelectCommand(condition,order);

            DataSet result = connection.ExecuteQuery(command.GetCommand());

			List<UsersTableRow> list = new List<UsersTableRow>();
            if(result.Tables[0].Rows.Count>0){
                for (int i = 0; i < result.Tables[0].Rows.Count; i++)
                {
	                data = new UsersTableRow();
	                data.FromDataRow(result.Tables[0].Rows[0],"users");
                    data.IsNew = false;
                    list.Add(data);
                }
            }
            return list;
        }
#endregion
        /// <summary>
        /// usersւinsert sqlR}h
        /// </summary>
        /// <param name="data">ǉf[^</param>
        public TableInsertCommand BuildInsertCommand(UsersTableRow data)
        {
            TableInsertCommand command = new TableInsertCommand("users");

            if (property.UserId.DoUpdate) command.AddInsert(property.UserId, data.UserId);
            if (property.Password.DoUpdate) command.AddInsert(property.Password, data.Password);
            if (property.UserName.DoUpdate) command.AddInsert(property.UserName, data.UserName);
            if (property.NumFields.DoUpdate) command.AddInsert(property.NumFields, data.NumFields);
            if (property.Birthday.DoUpdate) command.AddInsert(property.Birthday, data.Birthday);
            if (property.CreatedAt.DoUpdate) command.AddInsert(property.CreatedAt, data.CreatedAt);
            if (property.ModifiedAt.DoUpdate) command.AddInsert(property.ModifiedAt, data.ModifiedAt);
            
            return command;
        }
        /// <summary>
        /// usersւupdate sqlR}h(WHERE͎L[g)
        /// </summary>
        /// <param name="data">ύXf[^</param>
        public TableUpdateCommand BuildUpdateCommand(UsersTableRow data)
        {
            TableUpdateCommand command = new TableUpdateCommand("users");

            //XV`
            if (property.UserId.DoUpdate) command.AddUpdate(property.UserId, data.UserId);
            if (property.Password.DoUpdate) command.AddUpdate(property.Password, data.Password);
            if (property.UserName.DoUpdate) command.AddUpdate(property.UserName, data.UserName);
            if (property.NumFields.DoUpdate) command.AddUpdate(property.NumFields, data.NumFields);
            if (property.Birthday.DoUpdate) command.AddUpdate(property.Birthday, data.Birthday);
            if (property.CreatedAt.DoUpdate) command.AddUpdate(property.CreatedAt, data.CreatedAt);
            if (property.ModifiedAt.DoUpdate) command.AddUpdate(property.ModifiedAt, data.ModifiedAt);
            

            //XV`
            command.AddWhere(new ColumnValueCondition( property.UserId,"@PK_UserId", data.UserId,"="));
            
            return command;
        }

        /// <summary>
        /// usersւ̍XVSqlR}h(WHERE͊O炤)
        /// </summary>
        /// <param name="data">ύXf[^</param>
        /// <param name="condition">Ώۏ</param>
        public TableUpdateCommand BuildUpdateCommand(UsersTableRow data, TableCommandCondition condition)
        {
            TableUpdateCommand command = new TableUpdateCommand("users");

            //XV`
            if (property.UserId.DoUpdate) command.AddUpdate(property.UserId, data.UserId);
            if (property.Password.DoUpdate) command.AddUpdate(property.Password, data.Password);
            if (property.UserName.DoUpdate) command.AddUpdate(property.UserName, data.UserName);
            if (property.NumFields.DoUpdate) command.AddUpdate(property.NumFields, data.NumFields);
            if (property.Birthday.DoUpdate) command.AddUpdate(property.Birthday, data.Birthday);
            if (property.CreatedAt.DoUpdate) command.AddUpdate(property.CreatedAt, data.CreatedAt);
            if (property.ModifiedAt.DoUpdate) command.AddUpdate(property.ModifiedAt, data.ModifiedAt);
            

            //XV`
            command.AddWhere(condition);

            return command;
        }

        /// <summary>
        /// usersւselect sqlR}h(WHERE͊O炤
        /// </summary>
        /// <param name="condition">Ώۏ</param>
        public TableDeleteCommand BuildDeleteCommand(TableCommandCondition condition)
        {
            TableDeleteCommand command = new TableDeleteCommand("users");


            //XV`
            command.AddWhere(condition);

            return command;
        }
        /// <summary>
        /// usersւdelete sqlR}h(WHERE͎L[g)
        /// </summary>
        /// <param name="data">Ώۏ</param>
        public TableDeleteCommand BuildDeleteCommand(UsersTableRow data)
        {
            TableDeleteCommand command = new TableDeleteCommand("users");

            //XV`
            command.AddWhere(new ColumnValueCondition( property.UserId,"@PK_UserId", data.UserId,"="));
            

            return command;
        }

        /// <summary>
        /// usersւselect count(*)(WHERE͎L[g)
        /// </summary>
        /// <param name="data">Ώۏ</param>
        public TableSelectCommand BuildExistsCommand(UsersTableRow data)
        {
            TableSelectCommand command = new TableSelectCommand("users");

            //XV`
            command.AddSelect(new TableCommandColumn("CNT","COUNT(*)"));

            //XV`
            command.AddWhere(new ColumnValueCondition( property.UserId,"@PK_UserId", data.UserId,"="));
            

            return command;
        }

        /// <summary>
        /// usersւselect sqlR}h(WHERE͎L[g)
        /// </summary>
        /// <param name="data">Ώۏ</param>
        public TableSelectCommand BuildSelectCommand(UsersTableRow data)
        {
            TableSelectCommand command = new TableSelectCommand("users");

            //XV`
            command.AddSelect(property.UserId);
            command.AddSelect(property.Password);
            command.AddSelect(property.UserName);
            command.AddSelect(property.NumFields);
            command.AddSelect(property.Birthday);
            command.AddSelect(property.CreatedAt);
            command.AddSelect(property.ModifiedAt);
            

            //XV`
            command.AddWhere(new ColumnValueCondition( property.UserId,"@PK_UserId", data.UserId,"="));
            

            return command;
        }

        /// <summary>
        /// usersւselect sqlR}h(WHERE͊O炤)
        /// </summary>
        /// <param name="condition">Ώۏ</param>
        /// <param name="order">\[g</param>
        public TableSelectCommand BuildSelectCommand(TableCommandCondition condition,List<TableCommandColumn> order)
        {
            TableSelectCommand command = new TableSelectCommand("users");

            //XV`
            command.AddSelect(property.UserId);
            command.AddSelect(property.Password);
            command.AddSelect(property.UserName);
            command.AddSelect(property.NumFields);
            command.AddSelect(property.Birthday);
            command.AddSelect(property.CreatedAt);
            command.AddSelect(property.ModifiedAt);
            

            //XV`
            if(condition != null)   command.AddWhere(condition);
            //
            if (order != null) command.OrderBy.AddRange(order);

            return command;
        }
        /// <summary>
        /// usersselect list
        /// </summary>
        /// <param name="tableAlias">e[uɕtʖ</param>
        /// <param name="columnAliasPrefix">ɕtʖ̐ړ</param>
        public string  GetSelectListString(string tableAlias , string columnAliasPrefix)
        {
        	StringBuilder builder = new StringBuilder();

            //XV`
            builder.AppendLine(", "+ tableAlias + ".user_id AS " + columnAliasPrefix + "user_id" );
            builder.AppendLine(", "+ tableAlias + ".password AS " + columnAliasPrefix + "password" );
            builder.AppendLine(", "+ tableAlias + ".user_name AS " + columnAliasPrefix + "user_name" );
            builder.AppendLine(", "+ tableAlias + ".num_fields AS " + columnAliasPrefix + "num_fields" );
            builder.AppendLine(", "+ tableAlias + ".birthday AS " + columnAliasPrefix + "birthday" );
            builder.AppendLine(", "+ tableAlias + ".created_at AS " + columnAliasPrefix + "created_at" );
            builder.AppendLine(", "+ tableAlias + ".modified_at AS " + columnAliasPrefix + "modified_at" );
            

            return builder.ToString().Substring(1);
        }
    }
}
