﻿using System;
using System.Collections.Generic;
using System.Windows.Forms;
using log4net;
using System.IO;

namespace Menu
{
    static class Program
    {
        private static readonly log4net.ILog logger = LogManager.GetLogger(System.Reflection.MethodBase.GetCurrentMethod().DeclaringType);

        /// <summary>
        /// アプリケーションのメイン エントリ ポイントです。
        /// </summary>
        [STAThread]
        static void Main()
        {
            FileInfo info = new FileInfo(
            string.Format("{0}.exe.config", log4net.Util.SystemInfo.AssemblyShortName(
            System.Reflection.Assembly.GetExecutingAssembly())));
            // アセンブリがdllの場合は”.dll.config”

            log4net.Config.XmlConfigurator.Configure(LogManager.GetRepository(), info);

            Application.EnableVisualStyles();
            Application.SetCompatibleTextRenderingDefault(false);
            Application.Run(new Form1());
        }
    }
}