using System;
using System.Collections.Generic;
using System.Text;
using OFW.FieldProperties;
using OFW.Util;

namespace OFW.Validators
{
    /// <summary>
    /// tB[hpValidator
    /// </summary>
    public class StringFieldValidator : FieldValidator
    {
        /// <summary>
        /// ftHg\z
        /// </summary>
        public StringFieldValidator() : base()
        {
            this.mProperty = new StringFieldProperty();
        }
        /// <summary>
        /// vpeBw
        /// </summary>
        /// <param name="p"></param>
        public StringFieldValidator(FieldProperty p) : base(p)
        {

        }
        /// <summary>
        /// ^Cv`FbÑI[o[Ch
        /// </summary>
        /// <param name="aValue">Ώےl</param>
        /// <returns>validȂtrue</returns>
        public override bool ValidateType(object aValue)
        {
            this.ErrorMessage = "";
            try
            {
                string checkVale = aValue.ToString();
            }
            catch
            {
                this.ErrorMessage = String.Format(mResource.GetString("ERR_INVALID_FORMAT"), this.mProperty.DisplayName);
                return false;
            }

            return true;
        }
        /// <summary>
        /// `FbÑI[o[Ch
        /// </summary>
        /// <param name="aValue">Ώےl</param>
        /// <returns>validȂtrue</returns>
        /// <remarks>nchar,nvarchar΍B
        /// </remarks>
        public override bool ValidateLength(object aValue)
        {
            this.ErrorMessage = "";
            try
            {
                StringFieldProperty prop = (StringFieldProperty)this.mProperty;

                string checkVale = aValue.ToString();
                int length = 0;
                if (prop.UseWideChar)
                {
                    length = checkVale.Length;
                }
                else
                {
                    length = StringUtil.LengthB(checkVale);
                }
                if ((prop.MinLength <= length) && (length <= prop.MaxLength))
                {//valid
                }
                else
                {
                    this.ErrorMessage = String.Format(
                        mResource.GetString("ERR_INVALID_RANGE"), this.mProperty.DisplayName, prop.MinLength.ToString() + "", prop.MaxLength.ToString() + "");
                    return false;
                }
            }
            catch
            {
                this.ErrorMessage = String.Format(mResource.GetString("ERR_INVALID_FORMAT"), this.mProperty.DisplayName);
                return false;
            }

            return true;
        }
        /// <summary>
        /// tH[}bg`FbÑI[o[Ch
        /// </summary>
        /// <param name="aValue">Ώےl</param>
        /// <returns>validȂtrue</returns>
        public override bool ValidateFormat(object aValue)
        {
            this.ErrorMessage = "";
            try
            {
                StringFieldProperty prop = (StringFieldProperty)this.mProperty;
                string checkVale = aValue.ToString();
                if (prop.Format == "") return true;

                if (!TypeChecker.CheckFormatString(checkVale, prop.Format))
                {
                    this.ErrorMessage = String.Format(mResource.GetString("ERR_INVALID_FORMAT"), this.mProperty.DisplayName);
                    return false;
                }
            }
            catch
            {
                this.ErrorMessage = String.Format(mResource.GetString("ERR_INVALID_FORMAT"), this.mProperty.DisplayName);
                return false;
            }

            return base.ValidateLength(aValue);
        }
    }
}
