using System;
using System.Collections.Generic;
using System.Text;
using OFW.FieldProperties;
using OFW.Util;

namespace OFW.Validators
{
    /// <summary>
    /// InttB[hpValidator
    /// </summary>
    public class IntFieldValidator : FieldValidator
    {
        /// <summary>
        /// ftHg\z
        /// </summary>
        public IntFieldValidator() : base()
        {

        }
        /// <summary>
        /// vpeBw
        /// </summary>
        public IntFieldValidator(FieldProperty p) : base(p)
        {

        }
        /// <summary>
        /// ^Cv`FbÑI[o[Ch
        /// </summary>
        /// <param name="aValue">Ώےl</param>
        /// <returns>validȂtrue</returns>
        public override bool ValidateType(object aValue)
        {
            this.ErrorMessage = "";
            try
            {
                if (aValue is int)
                {
                    return true;
                }
                else
                {
                    this.ErrorMessage = String.Format(mResource.GetString("ERR_INVALID_FORMAT"), this.mProperty.DisplayName);
                    return false;
                }
            }
            catch
            {
                this.ErrorMessage = String.Format(mResource.GetString("ERR_INVALID_FORMAT"), this.mProperty.DisplayName);
                return false;
            }

        }
        /// <summary>
        /// ͈̓`FbNI[o[Ch
        /// </summary>
        /// <param name="aValue">Ώےl</param>
        /// <returns>validȂtrue</returns>
        public override bool ValidateRange(object aValue)
        {
            this.ErrorMessage = "";
            try
            {
                IntFieldProperty prop = (IntFieldProperty)this.mProperty;

                int checkVale = Int32.Parse(aValue.ToString());
                if (!TypeChecker.CheckNumeric(checkVale, prop.MinValue, prop.MaxValue))
                {
                    this.ErrorMessage = String.Format(mResource.GetString("ERR_INVALID_RANGE"), prop.DisplayName, prop.MinValue, prop.MaxValue);
                    return false;
                }
            }
            catch
            {
                this.ErrorMessage = String.Format(mResource.GetString("ERR_INVALID_FORMAT"), this.mProperty.DisplayName);
                return false;
            }
            return true;
        }
    }
}
