using System;
using System.Collections.Generic;
using System.Text;

namespace OFW.Util
{
    /// <summary>
    /// 
    /// </summary>
    [Serializable]
    public class Time
    {
        int day;

        int hour;
        int minute;
        /// <summary>
        /// 
        /// </summary>
        public int Day
        {
            get { return this.day; }
            set { this.day= value; }
        }
        /// <summary>
        /// 
        /// </summary>
        public int Hour
        {
            get { return this.hour; }
            set { this.hour = value; }
        }
        /// <summary>
        /// 
        /// </summary>
        public int Minute
        {
            get { return this.minute; }
            set { this.minute = value; }
        }
        /// <summary>
        /// ftHg̍\z
        /// </summary>
        public Time()
        {
            this.day = 0;
            this.hour = 0;
            this.minute = 0;
        }
        /// <summary>
        /// 4̐lŕ\\z
        /// </summary>
        /// <param name="timeNumber">w</param>
        public Time(int timeNumber)
        {
            this.day = 0;
            this.hour = timeNumber / 100;
            this.minute= timeNumber % 100;
        }
        /// <summary>
        /// ƕč\z
        /// </summary>
        /// <param name="h"></param>
        /// <param name="m"></param>
        public Time(int h,int m)
        {
            this.day = h / 24;
            this.hour = h % 24;
            this.minute = m;
        }
        /// <summary>
        /// \񂩂\z
        /// </summary>
        /// <param name="time">\</param>
        public Time(string time)
        {
            this.day = 0;
            this.hour = 0;
            this.minute = 0;

            if (time.IndexOf(":") > 0)
            {
                string[] timeparts = time.Split(':');
                this.hour = NumberUtil.IntValue(timeparts[0]);
                this.minute = NumberUtil.IntValue(timeparts[1]);

            }
            else
            {
                int timeNumber = NumberUtil.IntValue(time);

                this.hour = timeNumber / 100;
                this.minute = timeNumber % 100;
            }
        }
        /// <summary>
        /// ԂZ
        /// </summary>
        /// <param name="hours">Z</param>
        /// <returns>Z</returns>
        public Time AddHours(int hours)
        {
            this.hour += hours;
            if (this.hour >= 24)
            {
                this.day += this.hour / 24;
                this.hour = this.hour % 24;
            }

            return this;
        }
        /// <summary>
        /// Z
        /// </summary>
        /// <param name="minutes">Z()</param>
        /// <returns>Z</returns>
        public Time AddMinutes(int minutes)
        {
            this.minute += minutes;
            if (this.minute >= 60)
            {
                int h = this.minute / 60;
                this.AddHours(h);
                this.minute = this.minute % 60;
            }

            return this;
        }
        /// <summary>
        /// 
        /// </summary>
        /// <returns>\</returns>
        public string Format()
        {
            return this.hour.ToString("00") + ":" + this.minute.ToString("00");
        }
        /// <summary>
        /// 
        /// </summary>
        /// <returns>\</returns>
        public string FormatJP()
        {
            return this.hour.ToString("00") + "" + this.minute.ToString("00") + "";
        }
        /// <summary>
        /// ݎ
        /// </summary>
        /// <returns>ݎ</returns>
        public static Time Now()
        {
            DateTime d = DateTime.Now;
            Time t = new Time(d.Hour, d.Minute);
            return t;
        }
        /// <summary>
        /// TimeɎԉZ
        /// </summary>
        /// <param name="t"></param>
        /// <param name="hours">Z</param>
        /// <returns>Z</returns>
        public static Time AddHours(Time t, int hours)
        {
            Time result = new Time(t.hour, t.minute);
            return result.AddHours(hours);
        }
    }
}
