using System;
using System.Collections;
using System.Collections.Generic;
using System.Data;
using System.Text;
using System.IO;
using System.Web;
using System.Web.Util;
using System.Text.RegularExpressions;
using Microsoft.VisualBasic;

namespace OFW.Util
{
	/// <summary>
	/// StringUtil ̊Tv̐łB
	/// </summary>
	public class StringUtil
	{
        private static Encoding sjisEnc = Encoding.GetEncoding("Shift_JIS");

        /// <summary>
        /// RXgN^
        /// </summary>
        private StringUtil()
		{
		}

        /// <summary>
        /// w肳ꂽ̃oCg̒lԂ
        /// </summary>
        /// <param name="ConvValue">oCg擾Ώۂ̕^̎</param>
        /// <returns>oCg</returns>
        public static int LengthB(string ConvValue)
        {
            int intRet = 0;

            try
            {
                intRet = sjisEnc.GetByteCount(ConvValue);
            }
            catch
            {
                intRet = 0;
            }
            finally
            {
            }

            return (intRet);
        }
        /// <summary>
        /// ̍擾
        /// 
        /// Ώە̒wTCYɖȂꍇ͌̂܂ܕԋpB
        /// </summary>
        /// <param name="s">Ώە</param>
        /// <param name="size">擾TCY</param>
        /// <returns>Ώە̍</returns>
        public static string Left(string s, int size)
        {
            if (string.IsNullOrEmpty(s)) return "";
            if (s.Length < size) return s;
            return s.Substring(0, size);
        }
        /// <summary>
        /// ̍[w肳ꂽoCg̕Ԃ܂
        /// Ώە̒wTCYɖȂꍇ͌̂܂ܕԋpB
        /// wTCY̍Ō̕Sp2oCgڂ̏ꍇA̕1oCgڂ͎̂ĂB
        /// </summary>
        /// <param name="ConvValue">oΏۂ̕^̎</param>
        /// <param name="CutCount">ooCg</param>
        /// <returns>o</returns>
        public static string LeftB(string ConvValue, int CutCount)
        {
            string strRet = "";

            if (CutCount > 0)
            {
                byte[] byteArray = sjisEnc.GetBytes(ConvValue);
                if (byteArray.Length > CutCount)
                {
                    //̂ƁAMBCS2oCgڂ͈̔͂ɗƂȂB
                    //  =0x8381
                    //؂ʒuMBCS leadingȂ폜
                    //if (((byteArray[CutCount - 1] > 0x80) &&
                    //    (byteArray[CutCount - 1] <= 0x9f)) ||
                    //    ((byteArray[CutCount - 1] >= 0xe0) &&
                    //    (byteArray[CutCount - 1] <= 0xfc)))
                    //{
                    //    CutCount--;
                    //}
                    int c = 0;
                    while(c < CutCount)
                    {
                        if (((byteArray[c] > 0x80) &&
                            (byteArray[c] <= 0x9f)) ||
                            ((byteArray[c] >= 0xe0) &&
                            (byteArray[c] <= 0xfc)))
                        {
                            //MBCS1oCg
                            c += 2;
                        }
                        else
                        {
                            c++;
                        }
                        
                    }
                    if (c > CutCount)
                    {
                        //Ō̃oCg߂͂ݏoB
                        CutCount--;
                    }
                    strRet = sjisEnc.GetString(byteArray, 0, CutCount);
                }
                else
                {
                    //؂钷̒Ȃ̂Ő؂ȂĂ悢
                    strRet = ConvValue;
                }
                //strRet = MidB(ConvValue, 1, CutCount);
            }

            return (strRet);
        }

        /// <summary>
        /// SĔpɂ
        /// StrConvƓȂ̂ŔpɏoȂ͂̂܂ܕԋp
        /// </summary>
        /// <param name="val">Ώە</param>
        /// <returns>pϊ</returns>
		public static string ToNarrow(string val)
        {
            string strRet = "";

            try
            {
                strRet = Strings.StrConv(val, VbStrConv.Narrow, 0x0411);
            }
            catch
            {
                strRet = "";
            }
            finally
            {
            }

            return (strRet);
        }
        /// <summary>
        /// w蕶SpɕϊԂ
        /// </summary>
        /// <param name="ConvValue">SpɕϊΏۂ̕^̎</param>
        /// <returns>Spɕϊ</returns>
        public static string ToWide(string ConvValue)
        {
            string strRet = "";

            try
            {
                strRet = Strings.StrConv(ConvValue, VbStrConv.Wide, 0x0411);

                strRet = strRet.Replace("\\", "");
            }
            catch
            {
                strRet = "";
            }
            finally
            {
            }

            return (strRet);
        }

        /// <summary>
        /// w蕶𕶎ɕϊ
        /// </summary>
        /// <param name="ConvValue">ϊΏە</param>
        /// <returns>ϊ</returns>
        public static string StringValue(object ConvValue)
        {
            string strRet = "";

            if (ConvValue == null)
            {
                strRet = "";
            }
            else
            {
                if (ConvValue == DBNull.Value)
                {
                    strRet = "";
                }
                else
                {
                    strRet = ConvValue.ToString();
					// GXP[vV[PX̍폜
					strRet = DeleteEscapeSequence(strRet);
                }
            }

            return (strRet);
        }

		/// <summary>
		/// i]vƎvjGXP[vV[PX̍폜
        /// c^uAEOFAnull폜B
        /// nullCWFNV邽߂ɃVXeO̓͂ɑ΂ĕKʂKvB
		/// </summary>
		/// <param name="s">Ώە</param>
		/// <returns>폜̕</returns>
		public static string DeleteEscapeSequence(string s)
		{
            string result = s.Replace("\v", string.Empty).Replace("\x1a", string.Empty).Replace("\x00", string.Empty);

            return result;
		}

        /// <summary>
        /// w蕶HTML̈Sȕɕϊ
        /// </summary>
        /// <param name="ConvValue">ϊΏە</param>
        /// <returns>ϊ</returns>
        public static string HtmlSafe(object ConvValue)
        {
            string strRet = "";

            if (ConvValue == null)
            {
                strRet = "";
            }
            else
            {
                if (ConvValue == DBNull.Value)
                {
                    strRet = "";
                }
                else
                {
                    strRet = HttpUtility.HtmlEncode( ConvValue.ToString() );
                }
            }

            return (strRet);
        }
        /// <summary>
        /// sbrvfɒu
        /// </summary>
        /// <param name="s">Ώە</param>
        /// <returns>u</returns>
        public static string Nl2Br(string s)
        {
            string outString = NormalizeNewLine( s ).Replace(Environment.NewLine, "<br />");
            return outString;
        }
        /// <summary>
        /// ̎wʒu̕
        /// </summary>
        /// <param name="source">̕</param>
        /// <param name="start">Jnʒu</param>
        /// <returns></returns>
        public static string Mid(string source, int start)
        {
            return source.Substring(start);
        }
        /// <summary>
        /// ̎wʒu̕
        /// </summary>
        /// <param name="source">̕</param>
        /// <param name="start">Jnʒu</param>
        /// <param name="length"></param>
        /// <returns></returns>
        public static string Mid(string source, int start,int length)
        {
            if (start >= source.Length) return "";
            if ((start + length) > source.Length) return source.Substring(start);
            return source.Substring(start,length);
        }
        /// <summary>
        /// ̉Ew蕶擾
        /// </summary>
        /// <param name="source">̕</param>
        /// <param name="length"></param>
        /// <returns>̉̕E</returns>
        public static string Right(string source, int length)
        {
            if (source.Length < length) return source;

            return source.Substring(source.Length - length, length);
        }

        /// <summary>
        /// ̎w肳ꂽoCgʒuAw肳ꂽoCg̕Ԃ
        /// </summary>
        /// <param name="stTarget">擾Ώە</param>
        /// <param name="iStart">擾Jn</param>
        /// <param name="iByteSize">擾oCg</param>
        /// <returns></returns>
        /// <remarks>̂܂܂ł͊̒ԂŕĂ܂</remarks>
        public static string MidB(string stTarget, int iStart, int iByteSize)
        {
            string strRet = "";

            try
            {
                byte[] bBytes = sjisEnc.GetBytes(stTarget);

                strRet = sjisEnc.GetString(bBytes, iStart - 1, iByteSize);
            }
            catch
            {
                strRet = "";
            }
            finally
            {
            }

            return (strRet);
        }


        /// <summary>
        /// trim()g
        /// SpłpłXy[Xۂ͎̂菜A^uǉ
        /// </summary>
        /// <param name="s">̕</param>
        /// <returns>폜̕</returns>
        public static string Trim(string s)
        {
            string result = "";
            Regex regexLeft = new Regex( "^(@| |\t)+"); //Sp󔒂Ɣp
            result = regexLeft.Replace(s,"");
            Regex regexRight = new Regex("(@| |\t)+$"); //Sp󔒂Ɣp
            result = regexRight.Replace(result, "");

            return result;
        }
        /// <summary>
        /// trim()g
        /// SpłpłXy[Xۂ͎̂菜A^uǉ
        /// </summary>
        /// <param name="s">̕</param>
        /// <returns>폜̕</returns>
        public static string TrimRight(string s)
        {
            string result = s;
            Regex regexRight = new Regex("(@| |\t)+$"); //Sp󔒂Ɣp
            result = regexRight.Replace(result, "");

            return result;
        }
        /// <summary>
        /// trim()g
        /// SpłpłXy[Xۂ͎̂菜A^uǉ
        /// </summary>
        /// <param name="s">̕</param>
        /// <returns>폜̕</returns>
        public static string TrimLeft(string s)
        {
            string result = s;
            Regex regexRight = new Regex("^(@| |\t)+"); //Sp󔒂Ɣp
            result = regexRight.Replace(result, "");

            return result;
        }
        /// <summary>
        /// 󔒍폜
        /// SpłpłXy[Xۂ͎̂菜A^uǉ
        /// 񒆂̋󔒂Ώ
        /// </summary>
        /// <param name="s">̕</param>
        /// <returns>폜̕</returns>
        public static string DeleteAllWhiteSpace(string s)
        {
            string result = "";
            Regex regexLeft = new Regex("(@| |\t)+"); //Sp󔒂Ɣp
            result = regexLeft.Replace(s, "");

            return result;
        }
        /// <summary>
        /// tab폜
        /// </summary>
        /// <param name="s">̕</param>
        /// <returns>폜̕</returns>
        public static string DeleteTab(string s)
        {
            string result = "";
            Regex regexLeft = new Regex("\t+"); //Sp󔒂Ɣp
            result = regexLeft.Replace(s, "");

            return result;
        }
        /// <summary>
        /// tab -> 
        /// </summary>
        /// <param name="s">̕</param>
        /// <returns>ϊ̕</returns>
        public static string TabToWhiteSpace(string s)
        {
            string result = "";
            result = s.Replace('\t',' ');

            return result;
        }
        /// <summary>
        /// s폜
        /// </summary>
        /// <param name="s">̕</param>
        /// <returns>폜̕</returns>
        public static string DeleteNewLine(string s)
        {
            string result = "";
            Regex re = new Regex("\r\n"); //Sp󔒂Ɣp
            result = re.Replace(s, "");

            return result;
        }
        /// <summary>
        /// Ỏs폜
        /// </summary>
        /// <param name="s">̕</param>
        /// <returns>폜̕</returns>
        public static string TrimBlankLine(string s)
        {
            StringReader sr = new StringReader(NormalizeNewLine( s ));
            string line;
            StringBuilder b = new StringBuilder();

            //܂擪̉sƂB
            int aaLine = 0;
            int lastLine = 0;
            while ((line = sr.ReadLine()) != null)
            {
                if (Trim(line) == "")
                {
                    if (aaLine == 0)
                    {
                        continue;
                    }
                    aaLine++;
                }
                else
                {
                    aaLine++;
                    lastLine = aaLine;
                }
                if (b.Length > 0) b.Append("\r\n");
                b.Append(TrimRight(line));
            }
            sr.Close();
            
            //Ō̋󔒂łȂs܂ł炽߂stringBuilderɓB
            sr = new StringReader(b.ToString());
            aaLine = 0;
            b = new StringBuilder();
            while ((line = sr.ReadLine()) != null)
            {
                if (aaLine > lastLine)
                {
                    break;
                }
                if (b.Length > 0) b.Append(Environment.NewLine);
                if (aaLine == 0) b.Append(Trim(line));
                else b.Append(s);

                aaLine++;
            }


   
            return b.ToString();
        }
		/// <summary>
		/// ݂ʎނ̉s\r\nɂ낦
		/// </summary>
		/// <param name="s">̕</param>
		/// <returns>낦ʂ̕</returns>
        public static string NormalizeNewLine(string s)
        {
            string result = "";

            //\nނ\r\nɂāAƂ\r\nł̂\r\r\nɂȂĂ܂̂ōŌ\r\r\rɂB
            result = s.Replace("\n", "\r\n").Replace("\r\r", "\r");
            return result;
            
        }
        /// <summary>
        /// ʂ̐K
        /// 
        /// </summary>
        /// <returns></returns>
        public enum NormalizeMode : int
        {
            /// <summary>
            /// None
            /// </summary>
            None = 0,
            /// <summary>
            /// TrimLeft
            /// </summary>
            TrimLeft = 1,
            /// <summary>
            /// TrimRight
            /// </summary>
            TrimRight = 2,
            /// <summary>
            /// TrimAll
            /// </summary>
            TrimAll = 3,
            /// <summary>
            /// DeleteSpace
            /// </summary>
            DeleteSpace = 4,
            /// <summary>
            /// DeleteWideSpace
            /// </summary>
            DeleteWideSpace = 8,
            /// <summary>
            /// DeleteTab
            /// </summary>
            DeleteTab = 16,
            /// <summary>
            /// DeleteAllWhiteSpace
            /// </summary>
            DeleteAllWhiteSpace = 31,
            /// <summary>
            /// TabToSpace
            /// </summary>
            TabToSpace = 32,
            /// <summary>
            /// ToNarrow
            /// </summary>
            ToNarrow = 64,
            /// <summary>
            /// ToLower
            /// </summary>
            ToLower = 128,
            /// <summary>
            /// ToUpper
            /// </summary>
            ToUpper = 256,
            /// <summary>
            /// alphabetic
            /// </summary>
            ToAlpha = 512,
            /// <summary>
            /// Digits
            /// </summary>
            ToDigit = 1024,
            /// <summary>
            /// alphabetic and digits
            /// </summary>
            ToAlphaDigit = 1536,
            /// <summary>
            /// Digits
            /// </summary>
            ToNumeric = 2048,

            /// <summary>
            /// Default(TabToSpace | TrimAll)
            /// </summary>
            Default = 35

        }
        /// <summary>
        /// NormalizeString
        /// </summary>
        /// <param name="s">̕</param>
        /// <param name="mode">K[h</param>
        /// <returns></returns>
        public static string NormalizeString(string s,NormalizeMode mode)
        {
            string norm = DeleteEscapeSequence( s );
            if ((mode & NormalizeMode.TrimLeft) == NormalizeMode.TrimLeft) norm = TrimLeft(norm);
            if ((mode & NormalizeMode.TrimRight) == NormalizeMode.TrimRight) norm = TrimRight(norm);
            if ((mode & NormalizeMode.DeleteSpace) == NormalizeMode.DeleteSpace) norm = norm.Replace(" ", "");
            if ((mode & NormalizeMode.DeleteWideSpace) == NormalizeMode.DeleteWideSpace) norm = norm.Replace("@", "");
            if ((mode & NormalizeMode.DeleteTab) == NormalizeMode.DeleteTab) norm = norm.Replace("\t", "");
            if ((mode & NormalizeMode.TabToSpace) == NormalizeMode.TabToSpace) norm = TabToWhiteSpace(norm);
            if ((mode & NormalizeMode.ToNarrow) == NormalizeMode.ToNarrow) norm = ToNarrow(norm);
            if ((mode & NormalizeMode.ToLower) == NormalizeMode.ToLower) norm = norm.ToLower();
            if ((mode & NormalizeMode.ToUpper) == NormalizeMode.ToUpper) norm = norm.ToUpper();
            if ((mode & NormalizeMode.ToAlphaDigit) == NormalizeMode.ToAlphaDigit)
            {
                norm = NormalizeAlphaNumeric(norm);
            }
            else
            {
                if ((mode & NormalizeMode.ToDigit) == NormalizeMode.ToDigit) norm = NormalizeDigit(norm);
                if ((mode & NormalizeMode.ToAlpha) == NormalizeMode.ToAlpha) norm = NormalizeAlpha(norm);
            }
            if ((mode & NormalizeMode.ToNumeric) == NormalizeMode.ToNumeric) norm = NormalizeNumeric(norm);

            return norm;
        }
        /// <summary>
        /// ڂ𐳋K
        /// ׂĂ̋󔒁A^uASp󔒂菜
        /// J}폜
        /// </summary>
        /// <param name="s">̕</param>
        /// <returns>K</returns>
        public static string NormalizeNumeric(string s)
        {
            s = DeleteEscapeSequence(s);
            string norm = DeleteAllWhiteSpace(DeleteNewLine(ToNarrow(s)));
            norm = Regex.Replace(norm, "[^0-9.\\-]", "");
            return norm;
        }
        /// <summary>
        /// ڂ𐳋K
        /// ׂĂ̋󔒁A^uASp󔒂菜
        /// J}폜
        /// </summary>
        /// <param name="s">̕</param>
        /// <returns>K</returns>
        public static string NormalizeDigit(string s)
        {
            s = DeleteEscapeSequence(s);
            string norm = Regex.Replace(s, "[^0-9]", "");
            return norm;
        }
        /// <summary>
        /// p𐳋K
        /// ׂĂ̋󔒁A^uASp󔒂菜
        /// </summary>
        /// <param name="s">̕</param>
        /// <returns>K</returns>
        public static string NormalizeAlphaNumeric(string s)
        {
            s = DeleteEscapeSequence(s);
            string norm = Regex.Replace(s, "[^0-9.\\-a-zA-Z]", "");
            return norm;
        }
        /// <summary>
        /// p𐳋K
        /// ׂĂ̋󔒁A^uASp󔒂菜
        /// </summary>
        /// <param name="s">̕</param>
        /// <returns>K</returns>
        public static string NormalizeAlpha(string s)
        {
            s = DeleteEscapeSequence(s);
            string norm = Regex.Replace(s, "[^a-zA-Z]", "");
            return norm;
        }

        /// <summary>
		/// URL𐳋K
		/// ׂĂ̋󔒁A^uASp󔒂菜
		/// J}sIhɂ
		/// </summary>
        /// <param name="s">̕</param>
        /// <returns>K</returns>
        public static string NormalizeURL(string s)
        {
            s = DeleteEscapeSequence(s);
            string n = DeleteAllWhiteSpace(DeleteNewLine(ToNarrow(s))).Replace(',', '.').ToLower();
            return n;            

        }
        /// <summary>
        /// URL𐳋K
        /// ׂĂ̋󔒁A^uASp󔒂菜
        /// J}sIhɂ
        /// </summary>
        /// <param name="s">̕</param>
        /// <returns>K</returns>
        public static string NormalizeDomain(string s)
        {
            s = DeleteEscapeSequence(s);
            return DeleteAllWhiteSpace(DeleteNewLine(ToNarrow(s))).Replace(',', '.').ToLower();
        }
        /// <summary>
		/// dbԍ𐳋K
		/// ׂĂ̋󔒁A^uASp󔒂菜
		/// </summary>
        /// <param name="s">̕</param>
        /// <returns>K</returns>
        public static string NormalizeTel(string s)
        {
            s = DeleteEscapeSequence(s);
            return DeleteAllWhiteSpace(DeleteNewLine(ToNarrow(s)));
        }
		/// <summary>
		/// X֔ԍ𐳋K
		/// ׂĂ̋󔒁A^uASp󔒂菜
		/// nCt܂܂ĂȂƂ3Ɖ4nCtłȂ
		/// </summary>
        /// <param name="s">̕</param>
        /// <returns>K</returns>
        public static string NormalizePostal(string s)
        {
            s = DeleteEscapeSequence(s);
            string ss = DeleteAllWhiteSpace(DeleteNewLine(ToNarrow(s)));
            if (TypeChecker.CheckFormatString(ss, RegExpFormat.NormalizePostalCode))
            {
                if (ss.IndexOf('-') < 0)
                {
                    if (ss.Length > 3)
                    {
                        ss = ss.Substring(0, 3) + "-" + ss.Substring(3);
                    }
                }
            }
            return ss;
        }
        /// <summary>
        /// ̕\𐳋K
        /// ׂĂ̋󔒁A^uASp󔒂菜
        /// </summary>
        /// <param name="s">̕</param>
        /// <returns>K</returns>
        public static string NormalizeTime(string s)
        {
            s = DeleteEscapeSequence(s);
            string t = DeleteAllWhiteSpace(DeleteNewLine(ToNarrow(s)));
            if (t == "") return t;
            if (TypeChecker.CheckFormatString(t, RegExpFormat.TIME_SMALL))
            {
                string timestring = "";
                string[] tt = Split(t, ":");
                if (tt.Length == 2)
                {
                    timestring = NumberUtil.Format(NumberUtil.IntValue(tt[0]), "00")
                                + ":" + NumberUtil.Format(NumberUtil.IntValue(tt[1]), "00");
                    return timestring;
                }
                if (tt.Length == 1)
                {
                    if (tt[0].Length <= 2)
                    {
                        timestring = NumberUtil.Format(NumberUtil.IntValue(tt[0]), "00")
                                    + ":00";
                        return timestring;
                    }
                    else if (tt[0].Length <= 4)
                    {
                        
                        string hhmm0 = "0" + tt[0];
                        string hhmm = hhmm0.Substring(hhmm0.Length - 4, 4);
                        string tt1 = hhmm.Substring(0, 2);
                        string tt2 = hhmm.Substring(2, 2);
                        timestring = NumberUtil.Format(NumberUtil.IntValue( tt1 ), "00")
                                    + ":" + NumberUtil.Format(NumberUtil.IntValue( tt2 ), "00");
                        return timestring;
                    }
                }
                return t;
            }
            return t;
        }
        /// <summary>
        /// t
        /// </summary>
        /// <param name="s">̕</param>
        /// <returns>K</returns>
        public static string NormalizeDateTime(string s)
        {
            s = DeleteEscapeSequence(s);
            string ss = ToNarrow(Trim(s)).Replace("-", "/");
            ss = Regex.Replace(ss, "[^0-9/:\\. ]", "");
            return ss.Trim();
        }


		/// <summary>
		/// VBSplit
		/// 󕶎͗vf0̔zԂB
		/// </summary>
		/// <param name="src">̕</param>
		/// <param name="delim">؂蕶</param>
		/// <returns>؂茋</returns>
        public static string[] Split(string src, string delim)
        {
            string[] ss;
            if (Trim(src).Length == 0)
            {
                ss = new string[0];
                return ss;
            }
            ss = Microsoft.VisualBasic.Strings.Split(src, delim, -1, CompareMethod.Text);
            return ss;
        }
        /// <summary>
        /// toStringĔr
        /// </summary>
        /// <param name="a">̕P</param>
        /// <param name="b">̕Q</param>
        /// <returns>rʁBa傫ꍇAb傫ꍇAvꍇ0</returns>
        /// <remarks>nulll͋󕶎</remarks>
        public static int Compare(object a, object b)
        {
            string sa = StringValue(a);
            string sb = StringValue(b);


            return sa.CompareTo(sb);
        }
        /// <summary>
        /// StringValueNumeric
        /// </summary>
        /// <param name="s">̕</param>
        /// <returns>l킷</returns>
        public static string NumericString(string s)
        {
            string parsed = NormalizeNumeric(s);
            if (TypeChecker.CheckFormatString(parsed, "^\\d*")) return parsed;
            return "";
        }
        /// <summary>
        /// StringValueAlphaNumeric
        /// </summary>
        /// <param name="s">̕</param>
        /// <returns>p</returns>
        public static string AlphaNumericString(string s)
        {
            string parsed = NormalizeAlphaNumeric(s);
            if (TypeChecker.CheckFormatString(parsed, "^[A-Za-z0-9]*")) return parsed;
            return "";
        }
        /// <summary>
        /// UrlString
        /// </summary>
        /// <param name="s">̕</param>
        /// <returns>URL</returns>
        public static string UrlString(string s)
        {
            string parsed = NormalizeURL(s);
            if (TypeChecker.CheckFormatString(parsed, RegExpFormat.Url))
            {
                if(parsed.IndexOf("../") >= 0) return "";

                if (TypeChecker.CheckFormatString(parsed, RegExpFormat.Url))
                {
                    return parsed;
                }
                
                return "";
            }
            return "";
        }
        /// <summary>
        /// DomainString
        /// {hC͍lȂ
        /// </summary>
        /// <param name="s">̕</param>
        /// <returns>hC</returns>
        public static string DomainString(string s)
        {
            string parsed = NormalizeDomain(s);
            if (TypeChecker.CheckFormatString(parsed, RegExpFormat.Domain)) return parsed;
            return "";
        }
        /// <summary>
        /// TelString
        /// </summary>
        /// <param name="s">̕</param>
        /// <returns>dbԍ</returns>
        public static string TelString(string s)
        {
            string parsed = NormalizeTel(s);
            if (!TypeChecker.CheckFormatString(parsed, RegExpFormat.Tel)) return "";
            if (!TypeChecker.CheckStringLengthByte(parsed, 13)) return "";
            if(!parsed.StartsWith("+"))
                if (!TypeChecker.CheckFormatString(parsed, "{[.],12,13}")) return "";
            return parsed;
        }
        /// <summary>
        /// PostalString
        /// </summary>
        /// <param name="s">̕</param>
        /// <returns>X֔ԍ</returns>
        public static string PostalString(string s)
        {
            string parsed = NormalizePostal(s);
            if (TypeChecker.CheckFormatString(parsed, RegExpFormat.PostalCode)) return parsed;
            return "";
        }
        /// <summary>
        /// TimeString
        /// </summary>
        /// <param name="s">̕</param>
        /// <returns></returns>
        public static string TimeString(string s)
        {
            string parsed = NormalizeTime(s);
            if (TypeChecker.CheckFormatString(parsed, RegExpFormat.TIME24_EX)) return parsed;
            return "";
        }

        /// <summary>
        /// -,_ŋ؂ꂽPCapitalizeČ
        /// </summary>
        /// <param name="str"></param>
        /// <returns></returns>
        /// <example>
        /// string s = "aaa_bbb-cc";
        /// string ss = StringUtil.Camelize(s);
        /// Debug.WriteLine(ss); //AaaBbbCcc\
        /// </example>
        public static string Camelize(string str)
        {
            string[] strlist = str.Split(new char[] { '_', '-' });
            string ss = "";
            for (int i = 0; i < strlist.Length; i++)
            {
                string s = strlist[i].ToLower();
                string s1;
                string s2;
                if (s.Length > 1)
                {
                    s1 = s.Substring(0, 1).ToUpper();
                    s2 = s.Substring(1).ToLower();
                    ss += s1 + s2;
                }
                else
                {
                    ss += s;
                }

            }
            return ss.ToString();
        }
        /// <summary>
        /// R[h𔻕ʂ
        /// </summary>
        /// <remarks>
        /// Jcode.pmgetcode\bhڐÂłB
        /// Jcode.pm(http://openlab.ring.gr.jp/Jcode/index-j.html)
        /// C#o[W:http://dobon.net/vb/dotnet/string/detectcode.html
        /// </remarks>
        /// <param name="byts">R[h𒲂ׂf[^</param>
        /// <returns>KƎvEncodingIuWFNgB
        /// fłȂnullB</returns>
        public static System.Text.Encoding DetectEncode(byte[] byts)
        {
            const byte bESC = 0x1B;
            const byte bAT = 0x40;
            const byte bDollar = 0x24;
            const byte bAnd = 0x26;
            const byte bOP = 0x28;    //(
            const byte bB = 0x42;
            const byte bD = 0x44;
            const byte bJ = 0x4A;
            const byte bI = 0x49;

            int len = byts.Length;
            int binary = 0;
            int ucs2 = 0;
            int sjis = 0;
            int euc = 0;
            int utf8 = 0;
            byte b1, b2;

            for (int i = 0; i < len; i++)
            {
                if (byts[i] <= 0x06 || byts[i] == 0x7F || byts[i] == 0xFF)
                {
                    //'binary'
                    binary++;
                    if (len - 1 > i && byts[i] == 0x00
                        && i > 0 && byts[i - 1] <= 0x7F)
                    {
                        //smells like raw unicode
                        ucs2++;
                    }
                }
            }

            if (binary > 0)
            {
                if (ucs2 > 0)
                    //JIS
                    //ucs2(Unicode)
                    return System.Text.Encoding.Unicode;
                else
                    //binary
                    return null;
            }

            for (int i = 0; i < len - 1; i++)
            {
                b1 = byts[i];
                b2 = byts[i + 1];

                if (b1 == bESC)
                {
                    if (b2 >= 0x80)
                        //not Japanese
                        //ASCII
                        return System.Text.Encoding.ASCII;
                    else if (len - 2 > i &&
                        b2 == bDollar && byts[i + 2] == bAT)
                        //JIS_0208 1978
                        //JIS
                        return System.Text.Encoding.GetEncoding(50220);
                    else if (len - 2 > i &&
                        b2 == bDollar && byts[i + 2] == bB)
                        //JIS_0208 1983
                        //JIS
                        return System.Text.Encoding.GetEncoding(50220);
                    else if (len - 5 > i &&
                        b2 == bAnd && byts[i + 2] == bAT && byts[i + 3] == bESC &&
                        byts[i + 4] == bDollar && byts[i + 5] == bB)
                        //JIS_0208 1990
                        //JIS
                        return System.Text.Encoding.GetEncoding(50220);
                    else if (len - 3 > i &&
                        b2 == bDollar && byts[i + 2] == bOP && byts[i + 3] == bD)
                        //JIS_0212
                        //JIS
                        return System.Text.Encoding.GetEncoding(50220);
                    else if (len - 2 > i &&
                        b2 == bOP && (byts[i + 2] == bB || byts[i + 2] == bJ))
                        //JIS_ASC
                        //JIS
                        return System.Text.Encoding.GetEncoding(50220);
                    else if (len - 2 > i &&
                        b2 == bOP && byts[i + 2] == bI)
                        //JIS_KANA
                        //JIS
                        return System.Text.Encoding.GetEncoding(50220);
                }
            }

			int sjis1 = 0;
            for (int i = 0; i < len - 1; i++)
            {
                b1 = byts[i];
                b2 = byts[i + 1];
				if (((b1 >= 0x81 && b1 <= 0x9F) || (b1 >= 0xE0 && b1 <= 0xFC)) &&
					((b2 >= 0x40 && b2 <= 0x7E) || (b2 >= 0x80 && b2 <= 0xFC)))
				{
					sjis += 2;
					i++;
				}
				// pJi`FbN
				//else
				//{
				//    // TODO:ЂƂb1pJȉꍇb2`FbN̂ق
				//    if (b1 >= 0xA1 && b1 <= 0xDF)
				//    {
				//        sjis1++;
				//    }
				//    if (b2 >= 0xA1 && b2 <= 0xDF)
				//    {
				//        sjis1++;
				//        // b2pJȉꍇi++
				//        // Ăꍇ͂̂܂܁ib22oCgR[h̐擪Ȃ̂Łj
				//        i++;
				//    }
				//}
            }
            for (int i = 0; i < len - 1; i++)
            {
                b1 = byts[i];
                b2 = byts[i + 1];
                if (((b1 >= 0xA1 && b1 <= 0xFE) && (b2 >= 0xA1 && b2 <= 0xFE)) ||
                    (b1 == 0x8E && (b2 >= 0xA1 && b2 <= 0xDF)))
                {
                    euc += 2;
                    i++;
                }
                else if (len - 2 > i &&
                    b1 == 0x8E && (b2 >= 0xA1 && b2 <= 0xFE) &&
                    (byts[i + 2] >= 0xA1 && byts[i + 2] <= 0xFE))
                {
                    euc += 3;
                    i += 2;
                }
            }
            for (int i = 0; i < len - 1; i++)
            {
                b1 = byts[i];
                b2 = byts[i + 1];
                if ((b1 >= 0xC0 && b1 <= 0xDF) && (b2 >= 0x80 && b2 <= 0xBF))
                {
                    utf8 += 2;
                    i++;
                }
                else if (len - 2 > i &&
                    (b1 >= 0xE0 && b1 <= 0xEF) && (b2 >= 0x80 && b2 <= 0xBF) &&
                    (byts[i + 2] >= 0x80 && byts[i + 2] <= 0xBF))
                {
                    utf8 += 3;
                    i += 2;
                }
            }

			// pJỉ\ꍇAsjisD悷
			//if (euc > sjis && euc > utf8)
			if (euc > (sjis + sjis1) && euc > utf8)
				//EUC
				//return System.Text.Encoding.GetEncoding(51932);
				// TODO:Ƃ肠eucʂ͎̂ĂsjisԂ
				return System.Text.Encoding.GetEncoding(932);
			else if (sjis > euc && sjis > utf8)
				//SJIS
				return System.Text.Encoding.GetEncoding(932);
			else if (utf8 > euc && utf8 > sjis)
				//UTF8
				return System.Text.Encoding.UTF8;

            return null;
        }
        /// <summary>
        /// 蕶JԂԂ
        /// </summary>
        /// <param name="s">JԂ</param>
        /// <param name="times"></param>
        /// <returns>w񐔌JԂ</returns>
        public static string Repeat(string s,int times)
        {
            StringBuilder b = new StringBuilder();
            for (int i = 0; i < times; i++)
            {
                b.Append(s);
            }
            return b.ToString();
        }
        /// <summary>
        /// w蕶̋󔒕
        /// </summary>
        /// <param name="times">JԂ</param>
        /// <returns>w蕶̋󔒕</returns>
        public static string Blank(int times)
        {
            return Repeat(" ", times);
        }
        /// <summary>
        /// w蕶̑Sp
        /// </summary>
        /// <param name="times">JԂ</param>
        /// <returns>w蕶̋󔒕</returns>
        public static string WideBlank(int times)
        {
            return Repeat("@", times);
        }
        /// <summary>
        /// w蕶ɂȂ܂fillŖ߂
        /// </summary>
        /// <param name="s">̕</param>
        /// <param name="fill">߂镶</param>
        /// <param name="length"></param>
        /// <returns></returns>
        public static string FillLeftWith(string s, string fill, int length)
        {
            if (s.Length > length) return s;
            return Repeat(fill, length - s.Length ) + s;
        }
        /// <summary>
        /// w蕶ɂȂ܂fillŖ߂
        /// </summary>
        /// <param name="s">̕</param>
        /// <param name="fill">߂镶</param>
        /// <param name="length"></param>
        /// <returns></returns>
        public static string FillRightWith(string s, string fill, int length)
        {
            if (s.Length > length) return s;
            return s + Repeat(fill, length - s.Length);
        }
        /// <summary>
        /// w蕶ɂȂ܂ŋ󔒂𖄂߂
        /// </summary>
        /// <param name="s">̕</param>
        /// <param name="length"></param>
        /// <returns></returns>
        public static string FillBlankLeft(string s, int length)
        {
            return FillLeftWith(s," ", length);
        }
        /// <summary>
        /// w蕶ɂȂ܂ŋ󔒂𖄂߂
        /// </summary>
        /// <param name="s">̕</param>
        /// <param name="length"></param>
        /// <returns></returns>
        public static string FillBlankRight(string s, int length)
        {
            return FillRightWith(s," ", length);
        }
        /// <summary>
        /// w蕶ɂȂ܂ŋ󔒂𖄂߂
        /// </summary>
        /// <param name="s">̕</param>
        /// <param name="length"></param>
        /// <returns></returns>
        public static string FillWideBlankLeft(string s, int length)
        {
            return FillLeftWith(s, "@", length);
        }
        /// <summary>
        /// w蕶ɂȂ܂ŋ󔒂𖄂߂
        /// </summary>
        /// <param name="s">̕</param>
        /// <param name="length"></param>
        /// <returns></returns>
        public static string FillWideBlankRight(string s, int length)
        {
            return FillRightWith(s, "@", length);
        }
        /// <summary>
        /// w蕶ɂȂ܂0𖄂߂
        /// </summary>
        /// <param name="s">̕</param>
        /// <param name="length"></param>
        /// <returns></returns>
        public static string FillZeroLeft(string s, int length)
        {
            return FillLeftWith(s, "0", length);
        }
        /// <summary>
        /// w蕶ɂȂ܂0𖄂߂
        /// </summary>
        /// <param name="s">̕</param>
        /// <param name="length"></param>
        /// <returns></returns>
        public static string FillZeroRight(string s, int length)
        {
            return FillRightWith(s, "0", length);
        }

        /// <summary>
        /// w̒ɐ؂葵
        /// </summary>
        /// <param name="orginal"></param>
        /// <param name="width">1s̕(byte)</param>
        /// <returns>؂肻낦</returns>
        public static List<string> SplitByWidth(string orginal, int width)
        {
            List<string> resultLines = new List<string>();
            
            StringWriter writer = new StringWriter();
            string s = "";
            int length = orginal.Length;
            int currentWidth = 0;
            for(int pos = 0;pos < length;pos++)
            {
                s = orginal.Substring(pos,1);
                int cLength = LengthB(s);
                if ((currentWidth + cLength) > width)
                {
                    resultLines.Add(writer.ToString());
                    writer = new StringWriter();
                    currentWidth = 0;
                }
                writer.Write(s);
                currentWidth += cLength;
            }
            resultLines.Add(writer.ToString());
            return resultLines;
        }
        /// <summary>
        /// `ꂽ̌
        /// </summary>
        /// <param name="lines">sȂ̕List(1vf1s)</param>
        /// <returns>s܂񂾕</returns>
        public static string JoinLine(IEnumerable lines)
        {
            StringBuilder builder = new StringBuilder();
            foreach (object line in lines)
            {
                if (builder.Length > 0)
                {
                    builder.Append(Environment.NewLine);
                }
                builder.Append(line);
            }
            return builder.ToString();
        }
        /// <summary>
        /// L[[hXgw蕶񂪃L[[hŎn܂ꍇ̈ʒu0n܂CfbNXԂ
        /// </summary>
        /// <param name="s">Ώ</param>
        /// <param name="keywords">镶</param>
        /// <returns>L[[hz̃CfbNX</returns>
        public static int FindKeywordIndex(string[] keywords,string s)
        {
            for(int i = 0;i < keywords.Length;i++)
            {
                if (s.StartsWith(keywords[i])) return i;
            }
            return -1;
        }
        /// <summary>
        /// L[[hXgw蕶񂪃L[[hŏIꍇ̈ʒu0n܂CfbNXԂ
        /// </summary>
        /// <param name="s">Ώ</param>
        /// <param name="keywords">镶</param>
        /// <returns>L[[hz̃CfbNX</returns>
        public static int FindKeywordIndexRight(string[] keywords, string s)
        {
            for (int i = 0; i < keywords.Length; i++)
            {
                if (s.EndsWith(keywords[i])) return i;
            }
            return -1;
        }
        /// <summary>
        /// Xgĕɂ
        /// </summary>
        /// <param name="list">Xg</param>
        /// <returns></returns>
        public static string Join(IEnumerable list)
        {
            return Join(list, ",", "");
        }
        /// <summary>
        /// XgĕɂB
        /// 
        /// vfƂɋ؂蕶B
        /// </summary>
        /// <param name="list">Xg</param>
        /// <param name="glue">؂蕶</param>
        /// <returns></returns>
        public static string Join(IEnumerable list, string glue)
        {
            return Join(list, glue, "");
        }
        /// <summary>
        /// Xgĕɂ
        /// </summary>
        /// <param name="list">Xg</param>
        /// <param name="glue">؂蕶</param>
        /// <param name="quote">vfɕtpL</param>
        /// <returns></returns>
        public static string Join(IEnumerable list, string glue,string quote)
        {
            StringBuilder builder = new StringBuilder();
            foreach (object o in list)
            {
                if (builder.Length > 0) builder.Append(glue);
                builder.Append(quote + StringValue( o ) + quote);
            }
            return builder.ToString();
        }
        /// <summary>
        /// Xgĕɂ
        /// 
        /// vfɋvf(nullƂ󕶎)ꍇ͖B
        /// </summary>
        /// <param name="list">Xg</param>
        /// <param name="glue">؂蕶</param>
        /// <param name="quote">vfɕtpL</param>
        /// <returns></returns>
        public static string JoinIgnoreEmpty(IEnumerable list, string glue, string quote)
        {
            StringBuilder builder = new StringBuilder();
            foreach (object o in list)
            {
                if (o == null) continue;
                if(string.IsNullOrEmpty(o.ToString())) continue;

                if (builder.Length > 0) builder.Append(glue);
                builder.Append(quote + o.ToString() + quote);
            }
            return builder.ToString();
        }
        /// <summary>
        /// oCgz񂩂當֕ϊ(UTF-8)
        /// </summary>
        /// <param name="bytes">oCgz</param>
        /// <returns>ʕ</returns>
        public static string BytesToString(byte[] bytes)
        {
            Encoding encoding = Encoding.UTF8;
            string retstr = encoding.GetString(bytes, 0, bytes.Length);
            return retstr;
        }
        /// <summary>
        /// oCgz񂩂當֕ϊ
        /// </summary>
        /// <param name="bytes">oCgz</param>
        /// <param name="enc">GR[fBO</param>
        /// <returns>ʕ</returns>
        public static string BytesToString(byte[] bytes, Encoding enc)
        {
            string retstr = enc.GetString(bytes, 0, bytes.Length);
            return retstr;
        }
        /// <summary>
        /// oCgz񂩂當֕ϊ
        /// </summary>
        /// <param name="bytes">oCgz</param>
        /// <returns>ʕ</returns>
        public static string BytesToHexString(byte[] bytes)
        {
            System.Text.StringBuilder result = new System.Text.StringBuilder();
            foreach (byte b in bytes)
            {
                result.Append(b.ToString("x2"));
            }
            return result.ToString();

        }
        /// <summary>
        /// 16i񂩂oCgz֕ϊ
        /// </summary>
        /// <param name="input">16i</param>
        /// <returns>ʔz</returns>
        public static byte[] HexStringToBytes(string input)
        {
            byte[] bytes = new byte[input.Length / 2];
            for (int i = 0; i < bytes.Length; i++)
            {
                string element = input.Substring(i * 2,2);
                bytes[i] = System.Convert.ToByte(element, 16);
            }
            return bytes;

        }

        /// <summary>
        /// 񂩂oCgɕϊ(UTF-8)
        /// </summary>
        /// <param name="s">̕</param>
        /// <returns>oCgz</returns>
        public static byte[] StringToBytes(string s)
        {
            Encoding encoding = Encoding.UTF8;
            byte[] bytes = encoding.GetBytes(s);
            return bytes;
        }
        /// <summary>
        /// 񂩂oCgɕϊ
        /// </summary>
        /// <param name="s">̕</param>
        /// <param name="enc">̃GR[fBO</param>
        /// <returns>oCgz</returns>
        public static byte[] StringToBytes(string s, Encoding enc)
        {
            byte[] bytes = enc.GetBytes(s);
            return bytes;
        }
        /// <summary>
        /// sourcetargeẗʒuTBsourcenul̏ꍇ-1ԂB
        /// </summary>
        /// <param name="source">Ώ</param>
        /// <param name="target"></param>
        /// <returns>ʒu</returns>
        public static int FindIndex(string source, string target)
        {
            if (string.IsNullOrEmpty(source)) return -1;
            return source.IndexOf(target);
        }
        /// <summary>
        /// sourcetargeẗʒuTBsourcenul̏ꍇ-1ԂB
        /// </summary>
        /// <param name="source">Ώ</param>
        /// <param name="target"></param>
        /// <param name="start">Jnʒu</param>
        /// <param name="count"></param>
        /// <returns>ʒu</returns>
        public static int FindIndex(string source, string target, int start, int count)
        {
            if (string.IsNullOrEmpty(source)) return -1;
            return source.IndexOf(target,start,count);
        }
        /// <summary>
        /// 񃊃Xg󕶎ۂȂ̍ŏ̂̂Ԃ
        /// </summary>
        /// <param name="list">̃Xg</param>
        /// <returns>ŏɌ</returns>
        public static string FindValidString(IEnumerable list)
        {
            foreach (object o in list)
            {
                if (o == null) continue;
                if (string.IsNullOrEmpty(o.ToString())) continue;

                if (Trim(o.ToString()) != "") return o.ToString();
            }
            return "";
        }
        /// <summary>
        /// 񃊃Xg󕶎ۂȂ̍ŏ̈ʒuԂ
        /// </summary>
        /// <param name="list">̃Xg</param>
        /// <returns>ŏɌʒu</returns>
        public static int FindValidIndex(IEnumerable list)
        {
            int index = -1;
            
            foreach (object o in list)
            {
                index++;
                if (o == null) continue;
                if (string.IsNullOrEmpty(o.ToString())) continue;

                if (Trim(o.ToString()) != "") return index;
            }
            return -1;
        }
        /// <summary>
        /// 񂪓蕶݂̂܂ނeXg
        /// </summary>
        /// <param name="source">Ώ</param>
        /// <param name="pattern">p^[</param>
        /// <returns>true</returns>
        public static bool IsValidPattern(string source, string pattern)
        {
            string regexPattern = "";
            if (pattern.StartsWith("^") && pattern.EndsWith("$"))
            {
                regexPattern = pattern;
            }
            else
            {
                StringBuilder regexPatternBuilder = new StringBuilder();
                regexPatternBuilder.Append("^[");
                for (int i = 0; i < pattern.Length; i++)
                {
                    if ((pattern[i] == '-') || (pattern[i] == '[') || (pattern[i] == ']') || (pattern[i] == '(') || (pattern[i] == ')') || (pattern[i] == '^') || (pattern[i] == '$'))
                    {
                        regexPatternBuilder.Append("\\");
                        regexPatternBuilder.Append(pattern[i]);
                    }
                    else
                    {
                        regexPatternBuilder.Append(pattern[i]);
                    }
                }
                regexPatternBuilder.Append("]+$");
                regexPattern = regexPatternBuilder.ToString();
            }

            return Regex.IsMatch(source, regexPattern);
        }
        /// <summary>
        /// ܂܂邩`FbN
        /// </summary>
        /// <param name="source">Ώە</param>
        /// <returns>Ȃtrue</returns>
        public static bool IsDigit(string source)
        {
            return IsValidPattern(source, "^[0-9]+$");
        }
        /// <summary>
        /// l\񂩃`FbN
        /// </summary>
        /// <param name="source">Ώە</param>
        /// <returns>lۂȂtrue</returns>
        public static bool IsNumeric(string source)
        {
            return IsValidPattern(source, "^\\-?[0-9]+(\\.[0-9]*)?$");
        }
        /// <summary>
        /// 啶܂ނ`FbN
        /// </summary>
        /// <param name="source">Ώە</param>
        /// <returns>啶Ȃtrue</returns>
        public static bool IsCapitalAlpha(string source)
        {
            return IsValidPattern(source, "^[A-Z]+$");
        }
        /// <summary>
        /// 啶Ɛ܂ނ`FbN
        /// </summary>
        /// <param name="source">Ώە</param>
        /// <returns>啶ƐȂtrue</returns>
        public static bool IsCapitalAlphaDigit(string source)
        {
            return IsValidPattern(source, "^[A-Z0-9]+$");
        }
        /// <summary>
        /// keyƒlɕ
        /// 
        /// key = valueAkey:valueŋLqꂽL[ƒlɕ
        /// </summary>
        /// <param name="s">Ώە</param>
        /// <param name="delimiter">keyƒl𕪂镶</param>
        /// <returns>keyƒlȂ镶z</returns>
        public static string[] SplitKeyValue(string s,string delimiter)
        {
            string[] keyvalue = new string[2];

            int splitPosition = s.IndexOf(delimiter);

            if (splitPosition < 0)
            {
                keyvalue[0] = s.Trim();
                keyvalue[1] = "";
                return keyvalue;
            }
            int keyLength = NumberUtil.Distance(0, splitPosition - 1) + 1;
            int valueLength = NumberUtil.Distance(splitPosition + 1,s.Length - 1) + 1;

            if (keyLength <= 0)
            {
                keyvalue[0] = "";
                keyvalue[1] = "";
                return keyvalue;
            }

            keyvalue[0] = s.Substring(0, keyLength).Trim();
            if (valueLength > 0)
            {
                keyvalue[1] = s.Substring(splitPosition + 1, valueLength).Trim();
            }
            else
            {
                keyvalue[1] = "";
            }

            return keyvalue;
        }
        /// <summary>
        /// BASE64ɕϊ
        /// </summary>
        /// <param name="s">͕</param>
        /// <returns>͕BASE64</returns>
        public static string ToBase64(string s)
        {
            return System.Convert.ToBase64String(Encoding.ASCII.GetBytes(s));

        }
        /// <summary>
        /// BASE64񂩂ǂ߂镶ɕϊ
        /// </summary>
        /// <param name="s">BASE64</param>
        /// <returns>BASE64fR[h</returns>
        public static string FromBase64(string s)
        {
            return BytesToString( System.Convert.FromBase64String(s) );

        }
        /// <summary>
        /// 16iɕϊ
        /// </summary>
        /// <param name="s">͕</param>
        /// <returns>̃oCg16i\L</returns>
        public static string ToHexString(string s)
        {
            return BytesToHexString(Encoding.ASCII.GetBytes(s));
        }
        /// <summary>
        /// 16iƂ̕ɕϊ
        /// </summary>
        /// <param name="s">16ił킳ꂽoCǧ</param>
        /// <returns>͕BASE64</returns>
        public static string FromHexString(string s)
        {
            return BytesToString(HexStringToBytes(s));
        }
        /// <summary>
        /// _L[̃X^C
        /// </summary>
        public enum RandomKeyEncodeStyle
        {
            /// <summary>
            /// BASE64łB
            /// </summary>
            Base64,
            /// <summary>
            /// 16i\LłB
            /// </summary>
            HexString
        }
        /// <summary>
        /// _ȃL[𐶐B
        /// GUIDɂĂ̂łقڏd̉\͂ȂB
        /// </summary>
        /// <returns>_ȃL[Bo͕BASE64ɃGR[hĂB</returns>
        public static string GenerateRandomKey()
        {
            return GenerateRandomKey(RandomKeyEncodeStyle.Base64);
        }
        /// <summary>
        /// _ȃL[𐶐B
        /// GUIDɂĂ̂łقڏd̉\͂ȂB
        /// </summary>
        /// <param name="style">o͂̃GR[hX^C</param>
        /// <returns>_ȃL[Bo͕̓GR[hX^Cɏ]GR[hĂB</returns>
        public static string GenerateRandomKey(RandomKeyEncodeStyle style)
        {
            byte[] guid = System.Guid.NewGuid().ToByteArray();
            byte[] hashed = OFW.Util.Hash.MD5(guid);
            if (style == RandomKeyEncodeStyle.Base64)
            {
                return ByteArrayUtil.ToBase64String(hashed);
            }
            if (style == RandomKeyEncodeStyle.HexString)
            {
                return ByteArrayUtil.ToHexString(hashed);
            }
            return "";
        }
        /// <summary>
        /// ړAڔ菜
        /// </summary>
        /// <param name="s"></param>
        /// <param name="prefix"></param>
        /// <param name="suffix"></param>
        /// <returns></returns>
        public static string stripAffix(string s,string prefix,string suffix)
        {
            int startPosition = 0;
            int length = s.Length;
            int endPosition = length - 1;
            if (prefix.Length > 0)
            {
                startPosition = s.IndexOf(prefix);
                if (startPosition < 0) { 
                    startPosition = 0; 
                }
                else
                {
                    //prefix̎̈ʒuJn
                    startPosition = startPosition + prefix.Length;
                }

            }
            if (suffix.Length > 0)
            {
                endPosition = s.LastIndexOf(suffix);
                if (endPosition < 0)
                {
                    endPosition = s.Length - 1;
                }
                else
                {
                    //suffix̑Öʒu܂
                    endPosition = endPosition - 1;
                }

            }
            length = endPosition - startPosition + 1;

            if (length < 0) return "";
            return s.Substring(startPosition,length);


        }

    }
}
