using System;
using System.ComponentModel;

namespace OFW.Util
{
	/// <summary>
	/// NumberUtil ̊Tv̐łB
	/// </summary>
	public class NumberUtil
	{
        /// <summary>
        /// RXgN^
        /// </summary>
        private NumberUtil()
        {
        }

        #region ϊ
        /// <summary>
        /// byte^҂lbyte^ɕϊB
        /// </summary>
        /// <param name="value">͒l</param>
        /// <returns>͒lbyte\</returns>
        public static byte ByteValue(object value)
        {
            byte result = 0;
            if (value == null) return 0;
            if (value == DBNull.Value) return 0;
            if (value is byte) return (byte)value;
            if (byte.TryParse(value.ToString(), out result)) return result;
            return 0;
        }
        /// <summary>
        /// int(32bit)҂lintɕϊ
        /// </summary>
        /// <param name="value">͒l</param>
        /// <returns>͒lint\</returns>
        public static int IntValue(object value)
        {
            int result = 0;
            if (value == null) return 0;
            if (value == DBNull.Value) return 0;
            if (value is int) return (int)value;

            if (int.TryParse(value.ToString(), out  result)) return result;
            return 0;
        }
        /// <summary>
        /// short(16bit)҂lshortɕϊ
        /// </summary>
        /// <param name="value">͒l</param>
        /// <returns>͒lshort\</returns>
        public static short ShortValue(object value)
        {
            short result = 0;
            if (value == null) return 0;
            if (value == DBNull.Value) return 0;
            if (value is short) return (short)value;

            if (short.TryParse(value.ToString(), out  result)) return result;
            return 0;
        }
        /// <summary>
        /// long(64bit)҂llongɕϊ
        /// </summary>
        /// <param name="value">͒l</param>
        /// <returns>͒lshort\</returns>
        public static long LongValue(object value)
        {
            long result = 0;
            if (value == null) return 0;
            if (value == DBNull.Value) return 0;
            if (value is long) return (long)value;

            if (long.TryParse(value.ToString(), out  result)) return result;
            return 0;
        }
        /// <summary>
        /// float҂lfloatɕϊ
        /// </summary>
        /// <param name="value">͒l</param>
        /// <returns>͒lfloat\</returns>
        public static float FloatValue(object value)
        {
            float result = 0;
            if (value == null) return 0;
            if (value == DBNull.Value) return 0;
            if (value is float) return (float)value;

            if (float.TryParse(value.ToString(), out  result)) return result;
            return 0;
        }
        /// <summary>
        /// double҂ldoubleɕϊ
        /// </summary>
        /// <param name="value">͒l</param>
        /// <returns>͒ldouble\</returns>
        public static double DoubleValue(object value)
        {
            double result = 0;
            if (value == null) return 0;
            if (value == DBNull.Value) return 0;
            if (value is double) return (double)value;

            if (double.TryParse(value.ToString(), out  result)) return result;
            return 0;
        }
        /// <summary>
        /// decimal҂ldoubleɕϊ
        /// </summary>
        /// <param name="value">͒l</param>
        /// <returns>͒ldecimal\</returns>
        public static decimal DecimalValue(object value)
        {
            decimal result = 0;
            if (value == null) return 0;
            if (value == DBNull.Value) return 0;
            if (value is decimal) return (decimal)value;

            if (decimal.TryParse(value.ToString(), out  result)) return result;
            return 0;
        }
        /// <summary>
        /// bool҂lboolɕϊ
        /// </summary>
        /// <param name="value">͒l</param>
        /// <returns>͒lbool\</returns>
        public static bool BoolValue(object value)
        {
            if (value == null) return false;
            if (value == DBNull.Value) return false;

            if (value is bool) return (bool)value;
            if (value.ToString().Trim() == "") return false;
            try
            {
                if (value.ToString().Trim().ToLower() == "false") return false;
                if (value.ToString().Trim().ToLower() == "true") return true;

                if (value.ToString().Trim().ToLower() == "no") return false;
                if (value.ToString().Trim().ToLower() == "yes") return true;

                if (value.ToString().Trim().ToLower() == "n") return false;
                if (value.ToString().Trim().ToLower() == "y") return true;

                if (value.ToString().Trim().ToLower() == "off") return false;
                if (value.ToString().Trim().ToLower() == "on") return true;

                try
                {
                    int i = NumberUtil.IntValue(value);

                    if (i == 0) return false;
                    else return true;
                }
                catch { }

                if ((bool)value == false) return false;
                else return true;
            }
            catch
            {
                return false;
            }
        }
        /// <summary>
        /// Bool1/0ɂĕԂB
        /// 
        /// trueȂ1,falseȂ0
        /// </summary>
        /// <remarks></remarks>
        /// <param name="value">͒l</param>
        /// <returns>ϊ</returns>
        public static int BoolToInt(bool value)
        {
            if (value) return 1;
            else return 0;
        }
        /// <summary>
        /// nullableΉValue
        /// </summary>
        /// <typeparam name="T">ϊΏۂ̌^w</typeparam>
        /// <param name="value">͒l</param>
        /// <returns>ϊ</returns>
        public static T Value<T>(object value)
        {

            T ret = default(T);

            try
            {
                if (value == null) return ret;

                if (value == DBNull.Value)
                {
                    return ret;
                }

                if (value is T) return (T)value;
                if (value is string && value.ToString() == "") return default(T);

                try
                {
                    Type ct = typeof(T);
                    if (ct.IsGenericType)
                    {
                        Type baseType = ct.GetGenericArguments()[0]; //匳̌^擾int?int
                        ret = (T)System.Convert.ChangeType(value, baseType);

                        return ret;
                    }
                    ret = (T)System.Convert.ChangeType(value, ct);
                    return ret;
                }
                catch (Exception)
                {
                }

                string stringValue = StringUtil.NormalizeNumeric(value.ToString());
                if (stringValue == "") return ret;
                Type ct2 = typeof(T);
                if (ct2.IsGenericType)
                {
                    Type baseType = ct2.GetGenericArguments()[0]; //匳̌^擾int?int
                    ret = (T)System.Convert.ChangeType(stringValue.ToString(), baseType);

                    return ret;
                }


                return ret;
            }
            catch
            {
            }
            finally
            {
            }

            return (ret);
        }

        #endregion
        #region tH[}bg
        /// <summary>
        /// ftHg̏ŏ
        /// </summary>
        /// <param name="value">͒l</param>
        /// <returns>ʕ</returns>
        public static string Format(object value)
        {
            if (value == null) return "";

            string formated = "";
            try
            {
                formated = value.ToString();
            }
            catch
            {
                formated = value.ToString();
            }
            return formated;

        }
        /// <summary>
        /// w菑ŏ
        /// </summary>
        /// <param name="value">͒l</param>
        /// <param name="formatString">w</param>
        /// <returns>ʕ</returns>
        public static string Format(object value, string formatString)
        {
            if (value == null) return "";

            string formated = "";
            try
            {
                string sfFormatString = "{0:" + formatString + "}";
                formated = string.Format(sfFormatString, value);
            }
            catch
            {
                formated = value.ToString();
            }
            return formated;

        }
        /// <summary>
        /// bool̐^Uɑ΂蓖ĂĕԂ
        /// </summary>
        /// <param name="value">͒l</param>
        /// <param name="TrueExpression">ltruȅꍇ̏o</param>
        /// <param name="FalseExpression">lfalsȅꍇ̏o</param>
        /// <returns>ʕ</returns>
        public static string FormatBool(bool value, string TrueExpression, string FalseExpression)
        {
            if (value) return TrueExpression;
            else return FalseExpression;
        }
        /// <summary>
        /// bool̐^Uɑ΂蓖ĂĕԂ
        /// </summary>
        /// <param name="value">͒l</param>
        /// <returns>ʕ</returns>
        public static string FormatBoolYN(bool value)
        {
            return FormatBool(value, "Y", "N");
        }
        /// <summary>
        /// bool̐^Uɑ΂(YesNo)蓖ĂĕԂ
        /// </summary>
        /// <param name="value">͒l</param>
        /// <returns>ʕ</returns>
        public static string FormatBoolYesNo(bool value)
        {
            return FormatBool(value, "Yes", "No");
        }
        /// <summary>
        /// ʉ݌`
        /// 
        /// vbscriptɂFormatCurrencỹRs[B
        /// </summary>
        /// <param name="value">͒l</param>
        /// <returns>ʕ</returns>
        public static string FormatCurrency(decimal value)
        {
            string retStr = "";
            System.Globalization.CultureInfo MyCulture = new System.Globalization.CultureInfo("ja-JP");
            retStr = value.ToString("C", MyCulture);
            return retStr;
        }
        /// <summary>
        /// ʉ݌`
        /// vbscriptɂFormatCurrencỹRs[B
        /// </summary>
        /// <param name="value">͒l</param>
        /// <param name="scale">_ȉ</param>
        /// <returns>ʕ</returns>
        public static string FormatCurrency(decimal value, int scale)
        {
            string retStr = "";
            System.Globalization.CultureInfo MyCulture = new System.Globalization.CultureInfo("ja-JP");
            retStr = value.ToString("C" + scale.ToString(), MyCulture);
            return retStr;
        }
        /// <summary>
        /// ʉ݌`
        /// vbscriptɂFormatCurrencỹRs[B
        /// </summary>
        /// <param name="value">͒l</param>
        /// <returns>ʕ</returns>
        public static string FormatCurrency(int value)
        {
            string retStr = "";
            System.Globalization.CultureInfo MyCulture = new System.Globalization.CultureInfo("ja-JP");
            retStr = value.ToString("C", MyCulture);
            return retStr;
        }
        /// <summary>
        /// ؂菑
        /// vbscriptFormatNumberIvVȂŎŝƓB
        /// vbscriptɂFormatCurrencỹRs[B
        /// </summary>
        /// <param name="value">͒l</param>
        /// <returns>ʕ</returns>
        public static string FormatNumber(decimal value)
        {
            string retStr = "";
            retStr = value.ToString("#,##0");
            return retStr;
        }
        /// <summary>
        /// ؂菑
        /// vbscriptFormatNumberIvVȂŎŝƓB
        /// </summary>
        /// <param name="value">͒l</param>
        /// <returns>ʕ</returns>
        public static string FormatNumber(int value)
        {
            string retStr = "";
            retStr = value.ToString("#,##0");
            return retStr;
        }
        /// <summary>
        /// 0ߏ
        /// </summary>
        /// <param name="value">͒l</param>
        /// <param name="width">o͕</param>
        /// <returns>ʕ</returns>
        public static string FormatZero(decimal value, int width)
        {
            string retStr = "";
            string formatString = StringUtil.Repeat("0", width);
            retStr = value.ToString(formatString);
            return retStr;
        }
        /// <summary>
        /// 0ߏ
        /// </summary>
        /// <param name="value">͒l</param>
        /// <param name="width">o͕</param>
        /// <returns>ʕ</returns>
        public static string FormatZero(int value, int width)
        {
            string retStr = "";
            string formatString = StringUtil.Repeat("0", width);
            retStr = value.ToString(formatString);
            return retStr;
        }
        #endregion
        #region ͉
        /// <summary>
        /// ͂ĐlԂ
        /// </summary>
        /// <param name="s">͑Ώە</param>
        /// <returns>͌</returns>
        public static bool ParseBool(string s)
        {
            if (s == "1") return true;
            if (s.ToLower() == "y") return true;
            if (s.ToLower() == "yes") return true;
            if (s.ToLower() == "true") return true;

            return false;
        }
        /// <summary>
        /// ͕͂lԂ
        /// </summary>
        /// <typeparam name="T">Ԃ^̎w</typeparam>
        /// <param name="s">͑Ώە</param>
        /// <returns>͌</returns>
        public static T Parse<T>(string s) 
        {
            return Value<T>(s);
        }
        /// <summary>
        /// ͂ĐlԂ
        /// </summary>
        /// <param name="s">͑Ώە</param>
        /// <returns>͌</returns>
        public static byte ParseByte(string s)
        {
            return Parse<byte>(s);
        }
        /// <summary>
        /// ͂ĐlԂ
        /// </summary>
        /// <param name="s">͑Ώە</param>
        /// <returns>͌</returns>
        public static short ParseShort(string s)
        {
            return Parse<short>(s);
        }
        /// <summary>
        /// ͂ĐlԂ
        /// </summary>
        /// <param name="s">͑Ώە</param>
        /// <returns>͌</returns>
        public static int ParseInt(string s)
        {
            return Parse<int>(s);
        }
        /// <summary>
        /// ͂ĐlԂ
        /// </summary>
        /// <param name="s">͑Ώە</param>
        /// <returns>͌</returns>
        public static long ParseLong(string s)
        {
            return Parse<long>(s);
        }
        /// <summary>
        /// ͂ĐlԂ
        /// </summary>
        /// <param name="s">͑Ώە</param>
        /// <returns>͌</returns>
        public static float ParseFloat(string s)
        {
            return Parse<float>(s);
        }
        /// <summary>
        /// ͂ĐlԂ
        /// </summary>
        /// <param name="s">͑Ώە</param>
        /// <returns>͌</returns>
        public static double ParseDouble(string s)
        {
            return Parse<double>(s);
        }
        /// <summary>
        /// ͂ĐlԂ
        /// </summary>
        /// <param name="s">͑Ώە</param>
        /// <returns>͌</returns>
        public static decimal ParseDecimal(string s)
        {
            return Parse<decimal>(s);
        }
        #endregion
        #region vZ
        /// <summary>
        /// w萸xŎľܓ
        /// POPʁAPOOPʂȂǂscale}CiXɂ
        /// </summary>
        /// <param name="value">͒l</param>
        /// <param name="scale">xB</param>
        /// <returns>ľܓ</returns>
        public static decimal Round(decimal value, int scale)
        {
            //VXe̎Round\bhuۂ߁vŝł͎gȂ
            //if (scale >= 0) return decimal.Round(value, scale);

            decimal sign = (value >= 0) ? 1 : -1;
            decimal abs = value * sign;
            decimal coefficient = Power(10, scale);
            return decimal.Floor((abs * coefficient) + 0.5M) / coefficient * sign;

        }
        /// <summary>
        /// w萸xŐ؂グ
        /// POPʁAPOOPʂȂǂscale}CiXɂ
        /// </summary>
        /// <param name="value">͒l</param>
        /// <param name="scale">xB</param>
        /// <returns>ľܓ</returns>
        public static decimal RoundUp(decimal value, int scale)
        {
            decimal sign = (value >= 0) ? 1 : -1;
            decimal abs = value * sign;
            decimal coefficient = Power(10, scale);
            return decimal.Ceiling((abs * coefficient)) / coefficient * sign;
        }
        /// <summary>
        /// w萸xŐ؂̂
        /// POPʁAPOOPʂȂǂscale}CiXɂ
        /// </summary>
        /// <param name="value">͒l</param>
        /// <param name="scale">xB</param>
        /// <returns>ľܓ</returns>
        public static decimal RoundDown(decimal value, int scale)
        {
            decimal sign = (value >= 0) ? 1 : -1;
            decimal abs = value * sign;
            decimal coefficient = Power(10, scale);
            return decimal.Floor((abs * coefficient)) / coefficient * sign;
        }
        /// <summary>
        /// decimalׂ̂B
        /// L͂킩Ȃ̂ŕۗB
        /// </summary>
        /// <param name="x"></param>
        /// <param name="y">ׂ</param>
        /// <returns>decimalׂ̂B</returns>
        public static decimal Power(decimal x, int y)
        {
            decimal result = 1;
            if (y >= 0)
            {
                for (decimal d = 0; d < y; d++)
                {
                    result *= x;
                }
            }
            else
            {
                for (decimal d = 0; d > y; d--)
                {
                    result /= x;
                }
            }
            return result;
        }

        /// <summary>
        /// w萸xŎľܓ
        /// </summary>
        /// <param name="value">͒l</param>
        /// <param name="scale">xB</param>
        /// <returns>ľܓ</returns>
        public static double Round(double value, int scale)
        {
            //VXe̎Round\bhuۂ߁vŝł͎gȂ
            //if (scale >= 0) return System.Math.Round(value, scale);

            double sign = (value >= 0) ? 1D : -1D;
            double abs = value * sign;
            double coefficient = System.Math.Pow(10, scale);
            return System.Math.Floor((abs * coefficient) + 0.5D) / coefficient * sign;

        }
        /// <summary>
        /// w萸xŐ؂グ
        /// </summary>
        /// <param name="value">͒l</param>
        /// <param name="scale">xB</param>
        /// <returns>ľܓ</returns>
        public static double RoundUp(double value, int scale)
        {
            double sign = (value >= 0) ? 1 : -1;
            double abs = value * sign;
            double coefficient = System.Math.Pow(10, scale);
            return System.Math.Ceiling((abs * coefficient)) / coefficient * sign;
        }
        /// <summary>
        /// w萸xŐ؂̂
        /// </summary>
        /// <param name="value">͒l</param>
        /// <param name="scale">xB</param>
        /// <returns>ľܓ</returns>
        public static double RoundDown(double value, int scale)
        {
            double sign = (value >= 0) ? 1 : -1;
            double abs = value * sign;
            double coefficient = System.Math.Pow(10, scale);
            return System.Math.Floor((abs * coefficient)) / coefficient * sign;
        }
        /// <summary>
        /// 2l̋
        /// 
        /// Ƃ 02̋ 2
        /// </summary>
        /// <param name="origin">ʒu</param>
        /// <param name="position">ʒu</param>
        /// <returns>Bʒuʒu̍̏ꍇ</returns>
        public static int Distance(int origin,int position)
        {
            return position - origin ;
        }


        #endregion
        #region `FbN
        /// <summary>
        /// w萔l͈͓ɂ邩`FbN
        /// </summary>
        /// <typeparam name="T">^w</typeparam>
        /// <param name="target">͒l</param>
        /// <param name="min">ŏl</param>
        /// <param name="max">ől</param>
        /// <returns>͒lŏlől͈̔͂ɂtrue</returns>
        public static bool IsInRange<T>(T target, T min, T max) where T : IConvertible, IComparable
        {
            return ((target.CompareTo(min) >= 0) && (target.CompareTo(max) <= 0));
        }
        #endregion

    }
}
