using System;
using System.Reflection;
using System.Collections;
using System.Collections.Generic;
using System.Text;
using System.Xml;
using System.Xml.Serialization;
using System.IO;
using OFW.Util;
namespace OFW.Serializer
{
    /// <summary>
    /// ^Oɗ͒ZXmlSerializer<br />
    /// vf͈ȉ̂Ƃ<br />
    /// &lt;(targetObjectType)&gt;
    ///   &lt;field name=&quot;hoge&quot; type=&quot;fuga&quot; value=&quot;foo&quot; /&gt;
    /// ...<br />
    /// tB[h^CvNX̂ƂvalueqvfɃtB[hzu
    /// </summary>
    public class SXSerializer
    {
        /// <summary>JSONf[^̃[gIuWFNg</summary>
        XmlDocument doc;
        ///<summary>
        /// ϊNX̃^Cv
        /// </summary>
        Type mType;

        /// <summary>
        /// ^CṽLbV
        /// </summary>
        List<Type> mTypeCache;
        /// <summary>
        /// ̒l̎vfoȂ
        /// </summary>
        public bool IgnoreEmptyValue;
        /// <summary>
        /// lԂ݂ēǂ݂₷`ɂ
        /// </summary>
        public bool HumanReadable = false;
        /// <summary>
        /// ϊNXw肵č\z
        /// </summary>
        /// <param name="t">ϊNXType</param>
        public SXSerializer(Type t)
        {
            mType = t;
        }
        /// <summary>
        /// VACY
        /// </summary>
        /// <param name="writer"></param>
        /// <param name="o"></param>
        /// <returns></returns>
        public void Serialize(TextWriter writer, object o)
        {
            doc = new XmlDocument();

            XmlElement oo = CreateElementCore(o, mType, mType.FullName);

            doc.AppendChild(oo);

            XmlWriterSettings settings = new XmlWriterSettings();
            if (this.HumanReadable) settings.Indent = true;
            else settings.Indent = false;

            XmlWriter xwriter = XmlWriter.Create(writer,settings);
            doc.WriteContentTo(xwriter);
            xwriter.Close();
        }
        /// <summary>
        /// tVACY
        /// </summary>
        /// <param name="reader"></param>
        /// <returns>tVACYIuWFNg</returns>
        public object Deserialize(TextReader reader)
        {

            doc = new XmlDocument();
            doc.Load(reader);

            XmlElement element = (XmlElement)doc.LastChild;

            return ParseElementCore(element, mType);

        }
        /// <summary>
        /// q^̗vf
        /// </summary>
        /// <param name="o"></param>
        /// <param name="t"></param>
        /// <param name="baseName"></param>
        /// <returns></returns>
        XmlElement CreatePrimitiveElement(object o, Type t, string baseName)
        {
            if (IgnoreEmptyValue)
            {
                if (o == null) return null;
                if (o.ToString() == "") return null;
            }

            XmlElement element = doc.CreateElement("field");
            element.SetAttribute("name", baseName);
            if (o == null)
            {
                element.SetAttribute("type", t.FullName);
            }
            else
            {
                if (t.Name == "Object")
                {
                    element.SetAttribute("type", o.GetType().FullName);
                }
                element.SetAttribute("value", o.ToString());
            }
            return element;

        }
        /// <summary>
        /// IuWFNgċAIɏȂelementc[𐶐
        /// </summary>
        /// <param name="o">ΏۃIuWFNg</param>
        /// <param name="t">IuWFNg̒`^</param>
        /// <param name="baseName">ɂȂ閼O</param>
        /// <returns>ΏۃIuWFNg̕ϊ</returns>
        internal XmlElement CreateElementCore(object o, Type t, string baseName)
        {

            if (o == null)
            {
                return CreatePrimitiveElement(null, t, baseName);
            }
            else if (o == DBNull.Value)
            {
                return CreatePrimitiveElement(null, t, baseName);
            }
            Type objectType = t;
            if (IsNullable(t))
            {
                objectType = t.GetGenericArguments()[0];
            }

            if (objectType.Name == "DateTime")
            {
                return CreatePrimitiveElement(o, objectType, baseName);
            }
            else if (objectType.Name == "String")
            {
                return CreatePrimitiveElement(o, objectType, baseName);
            }
            else if (objectType.Name == "Type")
            {
                return CreatePrimitiveElement(((Type)o).FullName, objectType, baseName);
            }
            else if (objectType.IsEnum)
            {
                int i = (int)System.Convert.ChangeType(o, objectType);
                return CreatePrimitiveElement(i, objectType, baseName);
            }

            else if (objectType.IsPrimitive || objectType.IsValueType)
            {
                //TODO:objectɑ΂Č^ƒl킯ĕۑB
                return CreatePrimitiveElement(o, objectType, baseName);
            }
            else
            {
                Type tt = o.GetType().GetInterface("System.Collections.ICollection");
                if (tt != null)
                {
                    return CreateArrayElement(o, t, baseName);
                }
                else
                {
                    return CreateObjectElement(o, t, baseName);
                }
            }


        }
        /// <summary>
        /// zAXgARNV
        /// </summary>
        /// <param name="o">zAXgARNV</param>
        /// <param name="t">zAXgARNV̌^</param>
        /// <param name="baseName"></param>
        /// <returns>XmlElement</returns>
        private XmlElement CreateArrayElement(object o, Type t, string baseName)
        {
            XmlElement element = doc.CreateElement("field");
            if (o == null)
            {
                return CreatePrimitiveElement(o, t, baseName);
            }
            element.SetAttribute("name", baseName);
            System.Collections.ICollection ic = (System.Collections.ICollection)o;
            System.Collections.IEnumerator e = ic.GetEnumerator();
            int i = 0;
            while (e.MoveNext())
            {
                Type childType = e.Current.GetType();
                XmlElement child = CreateElementCore(e.Current, childType, i.ToString());
                element.AppendChild(child);

                i++;

            }
            element.SetAttribute("type", t.Name);
            element.SetAttribute("length", ic.Count.ToString());
            return element;
        }
        /// <summary>
        /// n^ł͂ȂIuWFNg
        /// </summary>
        /// <param name="o">ΏۃIuWFNg</param>
        /// <param name="t">ΏۃIuWFNg̒`^</param>
        /// <param name="baseName"></param>
        /// <returns></returns>
        private XmlElement CreateObjectElement(object o, Type t, string baseName)
        {
            XmlElement element;
            if (t.Equals(mType))
            {
                element = doc.CreateElement(baseName);
            }
            else
            {
                element = doc.CreateElement("field");
                element.SetAttribute("name", baseName);
            }
            Type objectType = o.GetType();

            element.SetAttribute("type", o.GetType().FullName);
            if (objectType.Name == "String")
            {
                element.SetAttribute("value", o.ToString());
                return element;
            }
            if (objectType.Name == "DateTime")
            {
                element.SetAttribute("value", o.ToString());
                return element;
            }
            if (objectType.IsValueType || objectType.IsPrimitive)
            {
                element.SetAttribute("value", o.ToString());
                return element;
            }
            FieldInfo[] fis = objectType.GetFields();
            foreach (FieldInfo fi in fis)
            {
                object[] attrs = fi.GetCustomAttributes(typeof(XmlIgnoreAttribute), true);
                if (attrs.Length > 0) continue;

                object childValue = fi.GetValue(o);
                Type childType = fi.FieldType;
                XmlElement child = CreateElementCore(childValue, childType, fi.Name);
                if (child != null) element.AppendChild(child);
            }
            PropertyInfo[] pis = objectType.GetProperties();
            foreach (PropertyInfo pi in pis)
            {
                object[] attrs = pi.GetCustomAttributes(typeof(XmlIgnoreAttribute), true);
                if (attrs.Length > 0) continue;

                object childValue = pi.GetValue(o, null);
                Type childType = pi.PropertyType;
                XmlElement child = CreateElementCore(childValue, childType, pi.Name);
                if (child != null) element.AppendChild(child);
            }
            return element;
        }
        /// <summary>
        /// n^ł͂ȂIuWFNg𕜌
        /// </summary>
        /// <param name="element">ΏJSONIuWFNg</param>
        /// <param name="t">IuWFNg̒`^</param>
        /// <returns>IuWFNg</returns>
        private object ParseObjectElement(XmlElement element, Type t)
        {
            Type objectType;
            if (element.HasAttribute("type"))
            {
                string typeName = element.GetAttribute("type");
                objectType = this.GetType(typeName);
            }
            else
            {
                objectType = t;
            }
            if (objectType.Name == "String")
            {
                return ParseElementCore(element, objectType);
            }
            if (objectType.IsValueType || objectType.IsPrimitive)
            {
                return ParseElementCore(element, objectType);
            }

            object o = Activator.CreateInstance(objectType);
            Type tt = o.GetType();
            IEnumerator e = element.ChildNodes.GetEnumerator();
            while (e.MoveNext())
            {
                XmlElement child = (XmlElement)e.Current;
                string fieldName = child.GetAttribute("name");
                string val = child.GetAttribute("value");

                FieldInfo fi = tt.GetField(fieldName);
                if (fi != null)
                {
                    object[] attrs = fi.GetCustomAttributes(typeof(XmlIgnoreAttribute), true);
                    if (attrs.Length > 0) continue;

                    object childObject = ParseElementCore(child, fi.FieldType);
                    fi.SetValue(o, childObject);
                    continue;
                }
                PropertyInfo pi = tt.GetProperty(fieldName);
                if (pi != null)
                {
                    object[] attrs = pi.GetCustomAttributes(typeof(XmlIgnoreAttribute), true);
                    if (attrs.Length > 0) continue;

                    object childObject = ParseElementCore(child, pi.PropertyType);
                    pi.SetValue(o, childObject, null);
                    continue;
                }
            }
            return o;


        }
        /// <summary>
        /// ̒S
        /// </summary>
        /// <param name="element">Ώ</param>
        /// <param name="t">Ώۂ̒`^</param>
        /// <returns>IuWFNg܂͌n^f[^</returns>
        internal object ParseElementCore(XmlElement element, Type t)
        {
            string stype = element.GetAttribute("type");
            Type objectType = null;
            if (stype != "") objectType = GetType(stype);
            if (objectType == null) objectType = t;

            bool isNullable = IsNullable(objectType);
            if (isNullable) objectType = objectType.GetGenericArguments()[0];

            if (element == null) return null;

            string sValue = element.GetAttribute("value");

            if (objectType == typeof(DateTime))
            {
                object o = (DateTime)Convert.ToDateTime(sValue);
                return o;
            }
            else if (objectType == typeof(string))
            {
                object o = sValue;
                return o;
            }
            else if (objectType == typeof(Type))
            {
                Type o = GetType(sValue);
                return o;
            }
            else if (objectType.IsEnum)
            {

                int i = (int)System.Convert.ChangeType(sValue, objectType);
                return i;
            }

            else if (objectType.IsPrimitive || objectType.IsValueType)
            {
                object o = Convert.ChangeType(sValue, objectType);
                return o;
            }
            else
            {
                Type ilistType = objectType.GetInterface("System.Collections.IList");
                if (ilistType != null)
                {
                    if (objectType.IsArray)
                    {
                        Array a = (Array)ParseArrayElement(element, objectType);

                        return a;
                    }
                    if (objectType.IsGenericType)
                    {
                        System.Collections.IList il = (System.Collections.IList)ParseListElement(element, objectType);
                        return il;
                    }
                    if (objectType.BaseType.IsArray)
                    {
                        Array a = (Array)ParseArrayElement(element, objectType);
                        return a;
                    }
                    if (objectType.BaseType.IsGenericType)
                    {
                        System.Collections.IList il = (System.Collections.IList)ParseListElement(element, objectType);
                        return il;
                    }

                    System.Collections.IList dil = (System.Collections.IList)parseDefaultListElement(element, objectType);
                    return dil;
                }
                else
                {
                    object o = ParseObjectElement(element, objectType);
                    return o;
                }
            }

        }
        /// <summary>
        /// z𕜌
        /// </summary>
        /// <param name="element">JSONz</param>
        /// <param name="t">ž^</param>
        /// <returns>z</returns>
        protected object ParseArrayElement(XmlElement element, Type t)
        {
            int len = NumberUtil.Value<int>(element.GetAttribute("length"));
            Array a = (Array)Activator.CreateInstance(t, new object[len]);
            if (len > 0)
            {
                for (int i = 0; i < len; i++)
                {
                    XmlElement child = (XmlElement)element.ChildNodes[i];
                    string typeName = child.GetAttribute("type");
                    Type tt = GetType(typeName);
                    object childObject = ParseElementCore(child, tt);
                    a.SetValue(childObject, i);
                }
            }
            return a;
        }
        /// <summary>
        /// Xg𕜌
        /// </summary>
        /// <param name="element">JSONz</param>
        /// <param name="t">郊Xǧ^</param>
        /// <returns>ꂽXg</returns>
        protected object ParseListElement(XmlElement element, Type t)
        {
            System.Collections.IList il = (System.Collections.IList)Activator.CreateInstance(t);
            Type[] genericArguments = t.GetGenericArguments();
            int len = NumberUtil.Value<int>(element.GetAttribute("length"));

            if (len > 0)
            {
                for (int i = 0; i < len; i++)
                {
                    XmlElement child = (XmlElement)element.ChildNodes[i];
                    Type tt = null;
                    string typeName = child.GetAttribute("type");
                    if (typeName != "")
                    {
                        tt = GetType(typeName);
                    }
                    if (tt == null)
                    {
                        if (genericArguments != null)
                        {
                            if (genericArguments.Length > 0)
                            {
                                tt = t.GetGenericArguments()[0];
                            }
                        }
                    }
                    if (tt == null)
                    {
                        continue;
                    }
                    object childObject = ParseElementCore(child, tt);

                    il.Add(childObject);
                }
            }
            return il;
        }
        object parseDefaultListElement(XmlElement element, Type t)
        {
            System.Collections.IList il = (System.Collections.IList)Activator.CreateInstance(t);
            Type[] genericArguments = t.GetGenericArguments();
            int len = NumberUtil.Value<int>(element.GetAttribute("length"));

            if (len > 0)
            {
                for (int i = 0; i < len; i++)
                {
                    XmlElement child = (XmlElement)element.ChildNodes[i];
                    Type tt = null;
                    string typeName = child.GetAttribute("type");
                    if (typeName != "")
                    {
                        tt = GetType(typeName);
                    }
                    if (tt == null)
                    {
                        if (genericArguments != null)
                        {
                            if (genericArguments.Length > 0)
                            {
                                tt = t.GetGenericArguments()[0];
                            }
                        }
                    }
                    if (tt == null)
                    {
                        continue;
                    }
                    object childObject = ParseElementCore(child, tt);

                    il.Add(childObject);
                }
            }
            return il;
        }
        /// <summary>
        /// ^Cv^CvԂB
        /// 
        /// </summary>
        /// <param name="typeName"></param>
        /// <returns></returns>
        /// <remarks>
        /// PType.GetType()ł悳Ȃ̂Ȃ̂ɁAdllœƂɂ܂[hłȂB
        /// ŁAType.GetType()Ŏs猻݃[hĂAZuׂĂ^CvTB
        /// </remarks>
        private Type GetType(string typeName)
        {
            Type t = Type.GetType(typeName);
            if (t == null)
            {
                if (mTypeCache == null) mTypeCache = new List<Type>();

                for (int i = 0; i < mTypeCache.Count; i++)
                {
                    if (mTypeCache[i].FullName == typeName)
                    {
                        t = mTypeCache[i];

                        break;
                    }
                }

            }
            if (t == null)
            {
                AppDomain a = AppDomain.CurrentDomain;
                Assembly[] asms = a.GetAssemblies();
                for (int i = 0; i < asms.Length; i++)
                {
                    t = asms[i].GetType(typeName);

                    if (t != null)
                    {
                        mTypeCache.Add(t);
                        break;
                    }
                }
            }
            return t;
        }
        private string RootName(Type t)
        {
            string name = t.Name;
            if (name.IndexOf("`") >= 0) name = name.Replace("`", "_");

            return name;
        }

        /// <summary>
        /// ̃^CvNullableł邩
        /// </summary>
        /// <param name="type"></param>
        /// <returns></returns>
        bool IsNullable(Type type)
        {
            if (type.IsGenericType)
            {
                if (type.GetGenericTypeDefinition() ==
                    typeof(Nullable<>)) return true;
            }
            return false;
        }

    }
}
