using System;
using System.Collections;
using System.Collections.Generic;
using System.Collections.Specialized;
using System.Text;
using System.Data;
using System.IO;
using OFW.Util;
using Newtonsoft.Json;

namespace OFW.Serializer
{
    /// <summary>
    /// System.Data.DataSetJSON
    /// </summary>
    public class DataTableJSON
    {
        /// <summary>
        /// VACYΏۂ̃e[u
        /// </summary>
        protected DataTable mDataTable;
        /// <summary>
        /// \z
        /// </summary>
        /// <param name="dataTable"></param>
        public DataTableJSON(DataTable dataTable)
        {
            mDataTable = dataTable;
        }
        /// <summary>
        /// ݂̃e[uwJSON
        /// </summary>
        /// <param name="columns"></param>
        /// <returns></returns>
        public JavaScriptObject ToJSON( StringCollection columns)
        {
            JavaScriptObject jso = new JavaScriptObject();
            JavaScriptArray jsa = new JavaScriptArray();
            DataColumnCollection cols = mDataTable.Columns;
            for (int i = 0; i < mDataTable.Rows.Count; i++)
            {
                DataRow row = mDataTable.Rows[i];
                JavaScriptObject o = new JavaScriptObject();
                for (int c = 0; c < columns.Count; c++)
                {
                    DataColumn col = cols[columns[c]];
                    object colData = row[col.ColumnName];
                    if (colData == DBNull.Value) colData = null;
                    else
                    {
                        if (col.DataType == typeof(DateTime)) colData = colData.ToString();
                    }
                    o.Add(col.ColumnName, colData);
                }
                jsa.Add(o);

            }
            jso.Add("Rows", jsa);
            return jso;
        }
    }
    /// <summary>
    /// 
    /// </summary>
    public class DataSetJSON
    {
        JavaScriptObject jso;

        /// <summary>
        /// dataset VACY
        /// </summary>
        /// <param name="writer"></param>
        /// <param name="data"></param>
        public void SerializeDataSet(TextWriter writer, DataSet data)
        {
          

            jso = createDataSetElement(data);

            Newtonsoft.Json.JsonSerializer serializer = new JsonSerializer();
            serializer.Serialize(writer, jso);
        }
        /// <summary>
        /// xmlDataTableɂŃVACY
        /// </summary>
        /// <param name="reader"></param>
        /// <returns></returns>
        public DataSet DeserializeDataSet(TextReader reader)
        {

            Newtonsoft.Json.JsonSerializer serializer = new JsonSerializer();

            JavaScriptObject jso = serializer.Deserialize(new JsonReader( reader )) as JavaScriptObject;

            return parseDataSet(jso);

        }

        #region create
        JavaScriptObject createDataSetElement(DataSet data)
        {
            JavaScriptObject element = new JavaScriptObject();
            JavaScriptArray arr = new JavaScriptArray();
            foreach (DataTable table in data.Tables)
            {
                arr.Add(createDataTableElement(table));
            }
            element.Add("tables", arr);
            return element;
        }
        JavaScriptObject createDataTableElement(DataTable table)
        {
            JavaScriptObject element = new JavaScriptObject();
            element.Add("name", table.TableName);
            element.Add("columns", createColumnsElement(table));
            element.Add("rows", createDataRowsElement(table));

            return element;
        }
        JavaScriptArray createColumnsElement(DataTable table)
        {
            JavaScriptArray arr = new JavaScriptArray();

            for (int i = 0; i < table.Columns.Count; i++)
            {
                JavaScriptObject columnElement = new JavaScriptObject();

                DataColumn column = table.Columns[i];
                columnElement.Add("name", column.ColumnName);
                columnElement.Add("type", column.DataType.FullName);
                columnElement.Add("nullable", column.AllowDBNull);
                arr.Add(columnElement);

            }
            return arr;
        }

        JavaScriptArray createDataRowsElement(DataTable table)
        {
            JavaScriptArray arr = new JavaScriptArray();

            for (int i = 0; i < table.Rows.Count; i++)
            {
                JavaScriptObject rowElement =  createDataRowElement(table.Rows[i]);
                arr.Add(rowElement);
            }
            return arr;

        }
        JavaScriptObject createDataRowElement(DataRow row)
        {
            JavaScriptObject rowElement = new JavaScriptObject();

            for (int i = 0; i < row.Table.Columns.Count; i++)
            {
                DataColumn column = row.Table.Columns[i];
                object o = row[column];
                if (o is DateTime) o = o.ToString();
                if (o == DBNull.Value) rowElement.Add(column.ColumnName, null);
                else rowElement.Add(column.ColumnName, o);

            }
            return rowElement;
        }
       
        #endregion
        #region parse
        DataSet parseDataSet(JavaScriptObject element)
        {
            DataSet s = new DataSet();
            JavaScriptArray tables = (JavaScriptArray)element["tables"];
            for (int i = 0; i < tables.Count; i++)
            {
                DataTable t = parseTable((JavaScriptObject)tables[i]);
                s.Tables.Add(t);
            }
            return s;

        }
        DataTable parseTable(JavaScriptObject element)
        {
            DataTable t = new DataTable();
            t.TableName = StringUtil.StringValue( element["name"] );

            JavaScriptArray columnsElement = (JavaScriptArray)element["columns"];
            t.Columns.AddRange(parseColumns(columnsElement));

            JavaScriptArray rowsElement = (JavaScriptArray)element["rows"];
            for (int i = 0; i < rowsElement.Count ; i++)
            {
                JavaScriptObject rowElement = (JavaScriptObject)rowsElement[i];
                DataRow row = t.NewRow();
                foreach (DataColumn c in t.Columns)
                {
                    if (rowElement.ContainsKey(c.ColumnName))
                    {
                        row[c.ColumnName] = fixValue(c, rowElement[c.ColumnName]);
                    }
                }
                t.Rows.Add(row);
            }
            return t;

        }

        DataColumn[] parseColumns(JavaScriptArray element)
        {
            DataColumn[] columns = new DataColumn[element.Count];
            for (int i = 0; i < element.Count; i++)
            {
                DataColumn col = parseColumn((JavaScriptObject)element[i]);
                columns[i] = col;
            }
            return columns;
        }
        DataColumn parseColumn(JavaScriptObject element)
        {
            string columnName = StringUtil.StringValue( element["name"] );
            string typeName = StringUtil.StringValue( element["type"]);
            bool nullable = NumberUtil.BoolValue(element["nullable"]);
            DataColumn col = new DataColumn(columnName, Type.GetType(typeName));
            col.AllowDBNull = nullable;
            return col;
        }
        #endregion

        #region util
        object fixValue(DataColumn c, object val)
        {
            Type objectType = c.DataType;
            if (val == null) return DBNull.Value;
            if (objectType == typeof(int))
            {
                return NumberUtil.Value<Int32>(val);
            }
            if (objectType == typeof(byte))
            {
                return NumberUtil.Value<Byte>(val);
            }
            if (objectType == typeof(short))
            {
                return NumberUtil.Value<Int16>(val);
            }
            if (objectType == typeof(long))
            {
                return NumberUtil.Value<Int64>(val);
            }
            if (objectType == typeof(bool))
            {
                return NumberUtil.Value<bool>(val);
            }
            if (objectType == typeof(DateTime))
            {
                return DateUtil.DateValue(val);
            }
            if (objectType == typeof(decimal))
            {
                return NumberUtil.Value<decimal>(val);
            }
            if (objectType == typeof(float))
            {
                return NumberUtil.Value<float>(val);
            }
            if (objectType == typeof(double))
            {
                return NumberUtil.Value<double>(val);
            }
            if (objectType == typeof(Type))
            {
                return Type.GetType(val.ToString());
            }
            if (objectType.IsEnum)
            {
                return val;
            }
            if (objectType.IsPrimitive || objectType.IsValueType)
            {
                return val;
            }

            return val;
        }
        #endregion
    }
}
