using System;
using System.Collections.Generic;
using System.Text;

namespace OFW.Models
{
    /// <summary>
    /// MODEĽ؋@\
    /// </summary>
    /// <typeparam name="TEntity">ؑΏۂ̃GeBeB̌^</typeparam>
    /// <typeparam name="TProperty">ؑΏۃGeBeB̒`</typeparam>
    public class Validator<TEntity,TProperty>  where TEntity:IEntity where TProperty : IEntityProperty,new()
    {
        /// <summary>
        /// ؑΏۂ̃GeBeB
        /// </summary>
        protected TEntity target;
        /// <summary>
        /// ؑΏۂ̃vpeB
        /// </summary>
        protected TProperty property;
        /// <summary>
        /// ؒɔbZ[W
        /// </summary>
        List<string> errorMessages;

        /// <summary>
        /// ؒɔbZ[W
        /// </summary>
        public List<string> ErrorMessages
        {
            get { return errorMessages; }
            set { errorMessages = value; }
        }

        /// <summary>
        /// {\z
        /// </summary>
        public Validator()
        {
            this.errorMessages = new List<string>();
        }
        /// <summary>
        /// {\z
        /// </summary>
        public Validator(TEntity entity)
        {
            this.errorMessages = new List<string>();
            this.target = entity;
            this.property = new TProperty();
        }
        /// <summary>
        /// {\z
        /// </summary>
        public Validator(TEntity entity, TProperty property)
        {
            this.errorMessages = new List<string>();
            this.target = entity;
            this.property = property;
        }

        /// <summary>
        /// Zbg
        /// </summary>
        public void Reset()
        {
            this.errorMessages.Clear();
        }
        /// <summary>
        /// ؖ{
        /// </summary>
        /// <returns>ؑΏۂ̃GeBeBԂłtrue</returns>
        /// <remarks>ݒ肳ĂGeBeB؂BXVtB[hƍ쐬tB[h͌؂ȂB</remarks>
        public virtual bool Validate()
        {
            bool valid = true;
            foreach(FieldProperties.FieldProperty p in property.Fields())
            {
                OFW.Validators.FieldValidator validator = OFW.Validators.FieldValidator.GetInstance(p);
                if (property.IsCreatedAtField(p)) continue;
                if (property.IsModifiedAtField(p)) continue;
                if (p.IgnoreValidation) continue;
                if (!p.DoUpdate) continue;
                if (!validator.Validate(this.target.GetValue(p.FieldName)))
                {
                    this.ErrorMessages.Add(validator.ErrorMessage);
                    valid = false;
                }
            }

            return valid;
        }
    }
}
