using System;
using System.Collections.Generic;
using System.Text;

namespace OFW.Forms.Filters
{
    /// <summary>
    /// 
    /// </summary>
    public class StringFilter : Filter
    {
        Util.StringUtil.NormalizeMode normalizeMode;
        int length;
        bool truncateOnExceed;
        /// <summary>
        /// ftHg\z
        /// </summary>
        public StringFilter()
        {
            this.length = 50;
            this.truncateOnExceed = true;
            this.normalizeMode = OFW.Util.StringUtil.NormalizeMode.Default;
        }
        /// <summary>
        /// w
        /// </summary>
        /// <param name="length"></param>
        public StringFilter(int length)
        {
            this.length = length;
            this.truncateOnExceed = true;
            this.normalizeMode = OFW.Util.StringUtil.NormalizeMode.Default;
        }
        /// <summary>
        /// ƃIvVw
        /// </summary>
        /// <param name="length"></param>
        /// <param name="normalizeMode">IvV</param>
        public StringFilter(int length,OFW.Util.StringUtil.NormalizeMode normalizeMode)
        {
            this.length = length;
            this.truncateOnExceed = true;
            this.normalizeMode = normalizeMode;
        }
        /// <summary>
        /// ƃIvVw
        /// </summary>
        /// <param name="length"></param>
        /// <param name="normalizeMode">IvV</param>
        /// <param name="truncateOnExceed">؎̂</param>
        public StringFilter(int length, OFW.Util.StringUtil.NormalizeMode normalizeMode,bool truncateOnExceed)
        {
            this.length = length;
            this.truncateOnExceed = truncateOnExceed;
            this.normalizeMode = normalizeMode;
        }

        /// <summary>
        /// w
        /// </summary>
        /// <param name="property">vpeB</param>
        public StringFilter(FieldProperties.FieldProperty property)
        {
            this.length = property.Length;
            this.truncateOnExceed = true;
            this.normalizeMode = OFW.Util.StringUtil.NormalizeMode.Default;
        }
        /// <summary>
        /// ƃIvVw
        /// </summary>
        /// <param name="property">vpeB</param>
        /// <param name="normalizeMode">IvV</param>
        public StringFilter(FieldProperties.FieldProperty property, OFW.Util.StringUtil.NormalizeMode normalizeMode)
        {
            this.length = property.Length;
            this.truncateOnExceed = true;
            this.normalizeMode = normalizeMode;
        }
        /// <summary>
        /// ƃIvVw
        /// </summary>
        /// <param name="property">vpeB</param>
        /// <param name="normalizeMode">IvV</param>
        /// <param name="truncateOnExceed">؎̂</param>
        public StringFilter(FieldProperties.FieldProperty property, OFW.Util.StringUtil.NormalizeMode normalizeMode, bool truncateOnExceed)
        {
            this.length = property.Length;
            this.truncateOnExceed = truncateOnExceed;
            this.normalizeMode = normalizeMode;
        }

        /// <summary>
        /// tB^[
        /// </summary>
        /// <param name="o">͒l</param>
        /// <returns>tB^[̒l</returns>
        public override object FilterValue(object o)
        {
            if (o == null) return "";

            string result = Util.StringUtil.NormalizeString(o.ToString(), this.normalizeMode);
            if (this.truncateOnExceed)
            {
                result = Util.StringUtil.Left(result, length);
            }
            return result;
        }
    }
}
