using System;
using System.Collections.Generic;
using System.Text;
using OFW.Util;

namespace OFW.FieldProperties
{
    /// <summary>
    /// int pFieldProperty
    /// </summary>
    [Serializable()]
    public class IntFieldProperty : FieldProperty
    {
        /// <summary>
        /// ől
        /// </summary>
        private int mMaxValue = Int32.MaxValue;
        /// <summary>
        /// ől
        /// </summary>
        /// <remarks>
        /// ͐xɊÂőlƐݒ肳ꂽől̏̒lԂ
        /// </remarks>
        public int MaxValue
        {
            get
            {
                if (this.Precision < 10)
                {
                    string m = (new String('9', (this.Precision)));
                    int mm = int.Parse(m);

                    return (mMaxValue > mm) ? mm : mMaxValue;
                }
                else
                {
                    return mMaxValue;
                }
            }
            set { mMaxValue = value; }
        }
        /// <summary>
        /// ŏl
        /// </summary>
        private int mMinValue = int.MinValue;
        /// <summary>
        /// ŏl
        /// </summary>
        /// <remarks>
        /// ͐xɊÂőlƐݒ肳ꂽől̑傫̒lԂ
        /// </remarks>
        public int MinValue
        {
            get
            {
                if (this.Precision < 10)
                {
                    string m = (new String('9', (this.Precision)));
                    int mm = int.Parse(m) * (-1);

                    return (mMinValue < mm) ? mm : mMinValue;
                }
                else
                {
                    return mMinValue;
                }

            }
            set { mMinValue = value; }
        }
        /// <summary>
        /// default construct
        /// </summary>
        public IntFieldProperty()
            : base()
        {

            FieldType = typeof(int);
            setup("int", "", "", "", 4, 10, 0, false, 0, false);
        }
        /// <summary>
        /// 
        /// </summary>
        /// <param name="entityName"></param>
        /// <param name="fieldName"></param>
        /// <param name="displayName"></param>
        public IntFieldProperty(string entityName, string fieldName, string displayName)
            : base()
        {

            FieldType = typeof(int);
            setup("int", entityName, fieldName, displayName, 4, 10, 0, false, 0, false);
        }
        /// <summary>
        /// Rs[RXgN^ǂ
        /// </summary>
        /// <param name="p">ɂȂvpeB</param>
        public IntFieldProperty(FieldProperty p)
            : base(p)
        {
            FieldType = typeof(int);
            if (p.GetType() == this.GetType())
            {
                MaxValue = ((IntFieldProperty)p).MaxValue;
                MinValue = ((IntFieldProperty)p).MinValue;
            }
        }
        /// <summary>
        /// ő咷
        /// </summary>
        /// <returns>ő͒</returns>
        /// <remarks>J}AA_܂񂾒Ԃ</remarks>
        public override int MaxLength
        {
            get
            {
                int max = this.Precision;

                //","؂̕
                max += (this.Precision - this.Scale - 1) / 3;
                //̕
                max += 1;

                return max;
            }
        }
        /// <summary>
        /// ftHgl
        /// </summary>
        /// <returns>ftHgl̕\</returns>
        public override string DefaultValueDisplay()
        {
            return NumberUtil.Format(this.DefaultValue,"#");
        }
        /// <summary>
        /// ftHgl
        /// </summary>
        public override object DefaultValue
        {
            get
            {
                return this.mDefaultValue;
            }
            set
            {
                this.mDefaultValue = NumberUtil.Value<int?>(value);
            }
        }
        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        public override object Clone()
        {
            return new IntFieldProperty(this); //NXłgȂ
        }
        /// <summary>
        /// 
        /// </summary>
        /// <param name="length"></param>
        /// <param name="precision"></param>
        /// <param name="scale"></param>
        public override void setSize(int length, int precision, int scale)
        {
            //length,scale͖B
            if(precision != 0) this.Precision = precision;
        }
    }

}
