using System;
using System.Collections.Generic;
using System.Text;
using System.IO;
using OFW.Util;
namespace OFW.Util
{
    /// <summary>
    /// fBNg쐬
    /// </summary>
    public class DirectoryBuilder
    {
        /// <summary>
        /// fBNg
        /// </summary>
        /// <remarks>
        /// fBNgƎwpXpXfBNg쐬B<br />
        /// "\"ȂƂ͕₢A]ɂȂƂ͂͂B
        /// </remarks>
        /// <param name="aBasePath">pX</param>
        /// <param name="aPath">ǉpX(pX̑)</param>
        /// <returns>ǉꂽpX(tpX)</returns>
        /// <example>
        /// <code>
        /// string basedir = "testdir\testsubdir";
        /// string path = "subdir2";
        /// string buildPath = BuildDirectory(basedir,path);
        /// //testdir\testsubdir\subdir݂Ȃ΃fBNg쐬
        /// //ɑ݂΂̂܂܁B
        /// </code>
        /// </example>
        public static string BuildDirectory(string aBasePath, string aPath)
        {
            string nextPath = FullPath(aBasePath, aPath);

            System.IO.Directory.CreateDirectory(nextPath);
            return nextPath;

        }
        /// <summary>
        /// pX̌
        /// </summary>
        /// <remarks>
        /// FileSystemObject.BuildPath̑
        /// ̃pX̖ɖOǉ܂B
        /// pXf~^sĂƂɃpXf~^tĕԂ
        /// </remarks>
        /// <param name="baseDir">pX</param>
        /// <param name="additionalPath">ǉpX</param>
        /// <returns>쐬pX\</returns>
        public static string FullPath(string baseDir, string additionalPath)
        {
            if (baseDir == "") return additionalPath.Replace("/", "\\");
            if (additionalPath == "") return baseDir.Replace("/", "\\");

            string full = baseDir;
            if (full.EndsWith("\\") || full.EndsWith("/"))
            {
            }
            else
            {
                full += "\\";
            }

            if (additionalPath.StartsWith("\\") || additionalPath.StartsWith("/"))
            {
                full += additionalPath.Substring(1);
            }
            else
            {
                full += additionalPath;
            }

            return full.Replace("/","\\");

        }

        /// <summary>
        /// pX̌
        /// </summary>
        /// <remarks>
        /// FullPathƓpXf~^"/"
        /// </remarks>
        /// <param name="baseDir">pX</param>
        /// <param name="additionalPath">ǉpX</param>
        /// <returns>쐬pX\</returns>
        /// <example>
        /// <code>
        /// string basedir = "http://hoge.com/";
        /// string path = "/index.html";
        /// string buildPath = FullURL(basedir,path);
        /// // buildPath = "http://hoge.com/index.html"ƂȂB
        /// </code>
        /// </example>
        public static string FullURL(string baseDir, string additionalPath)
        {
            if (baseDir == "") return additionalPath;
            //vgR܂ށEEEƂ΁A"://"΁Aŗǂ͂
			//if (additionalPath.StartsWith("http://")) return additionalPath;
            if (additionalPath.IndexOf("://") > 0) return additionalPath.Replace("\\", "/");
            if (additionalPath == "") return baseDir.Replace("\\", "/");


            string full = baseDir;
            if (full.EndsWith("\\") || full.EndsWith("/"))
            {
            }
            else
            {
                full += "/";
            }

            if (additionalPath.StartsWith("\\") || additionalPath.StartsWith("/"))
            {
                full += additionalPath.Substring(1);
            }
            else
            {
                full += additionalPath;
            }

            return full.Replace("\\","/");
        }
        /// <summary>
        /// pX𐶐B
        /// </summary>
        /// <param name="path1"></param>
        /// <param name="path2"></param>
        /// <param name="pathDelimiter"></param>
        /// <returns></returns>
        public static string BuildPath(string path1, string path2, string pathDelimiter)
        {
            string p1 = path1.Replace('\\', '/');
            string p2 = path2.Replace('\\', '/');

            string p = FullURL(p1, p2);
            return p.Replace("/", pathDelimiter);
        }
        /// <summary>
        /// pX𐶐B
        /// </summary>
        /// <param name="path1"></param>
        /// <param name="path2"></param>
        /// <returns></returns>
        public static string BuildPath(string path1, string path2)
        {
            return BuildPath(path1, path2, "/");
        }
        
    }
}
