using System;
using System.Collections.Generic;
using System.Text;
using System.Text.RegularExpressions;
using System.Windows.Forms;
using System.ComponentModel;

using OFW.FieldProperties;
using OFW.Forms;
using OFW.Forms.Filters;
using OFW.Validators;
namespace OFW.Windows.Forms.Adapters
{
    /// <summary>
    /// l̓A_v^[vf
    /// </summary>
    public class NumberInputElement : OFW.Forms.FormAdapterElement
    {
        const int PRECISION_MAX = 28;
        const int SCALE_MAX = 28;
        const int PRECISION_DEFAULT = 20;
        const int SCALE_DEFAULT = 00;

        enum ControlChars : int
        {
            CTRL_A = 0x01,
            CTRL_C = 0x03,
            CTRL_X = 0x18,
            CTRL_V = 0x16,
            CTRL_Z = 0x1a,
            BACKSPACE = 0x08
        };

        TextBox theControl;

        string outputFormat;
        int precision;
        int scale;
        int intPartMaxLength;
        int decimalPartMaxLength;
        /// <summary>
        /// //A}CiXA_A؂AobNXy[XActrl-c,ctrl-v,ctrl-a,ctrl-z
        /// </summary>
        private Regex acceptableCharPattern = new Regex(@"[\d\-\.,]"); 
        private Regex validPattern = new Regex(@"\-?[\d]+(\.[\d]+)?");

        /// <summary>
        /// ftHg
        /// </summary>
        public NumberInputElement()
        {

        }
        /// <summary>
        /// \z
        /// </summary>
        /// <param name="control">eLXg{bNX</param>
        public NumberInputElement(TextBox control)
        {
            this.theControl = control;
            setup(PRECISION_DEFAULT,SCALE_DEFAULT,"");

            this.validator = createDefaultValidator();
            attachHandlers();
        }
        /// <summary>
        /// \zB
        /// <para>͉\ȑŜ̕Ɛxw肷Bw肷`SQL decimalƓ`(Ŝ̕A_ȉ) </para>
        /// </summary>
        /// <param name="control">̓Rg[</param>
        /// <param name="precision">Ŝ̕</param>
        /// <param name="scale">_ȉ</param>
        public NumberInputElement(TextBox control, int precision, int scale)
        {
            this.theControl = control;
            setup(precision, scale,"");
            this.validator = createDefaultValidator();
            attachHandlers();
        }
        /// <summary>
        /// \z
        /// <para>͉\ȑŜ̕Ɛxw肷Bw肷`SQL decimalƓ`(Ŝ̕A_ȉ) </para>
        /// <para>\ptH[}bgw肷邱ƂŃJ}؂ȂǂB</para>
        /// </summary>
        /// <param name="control">̓Rg[</param>
        /// <param name="precision">Ŝ̕</param>
        /// <param name="scale">_ȉ</param>
        /// <param name="outputFormat">\ptH[}bg</param>
        public NumberInputElement(TextBox control, int precision, int scale,string outputFormat)
        {
            this.theControl = control;
            setup(precision, scale,outputFormat);
            attachHandlers();
        }
        /// <summary>
        /// ̗vpeBw肵č\z
        /// <para>\ptH[}bgɂ̓vpeB̕\ptH[}bg(DisplayFormat)gB</para>
        /// </summary>
        /// <param name="control">̓Rg[</param>
        /// <param name="property">̗vpeB</param>
        public NumberInputElement(TextBox control, FieldProperty property)
        {
            this.theControl = control;
            setup(property, property.DisplayFormat);

            attachHandlers();
        }
        /// <summary>
        /// ̗vpeBw肵č\z
        /// <para>\ptH[}bgw肷邱ƂŃJ}؂ȂǂB</para>
        /// </summary>
        /// <param name="control">̓Rg[</param>
        /// <param name="property">̗vpeB</param>
        /// <param name="outputFormat">\ptH[}bg</param>
        public NumberInputElement(TextBox control, FieldProperty property, string outputFormat)
        {
            this.theControl = control;
            setup(property,outputFormat);

            attachHandlers();
        }
        /// <summary>
        /// xݒ肵ē͏Ȃǂ\z
        /// </summary>
        /// <param name="precision">Ŝ̕</param>
        /// <param name="scale">_ȉ</param>
        /// <param name="outputFormat">\ptH[}bg</param>
        public void setup(int precision, int scale, string outputFormat)
        {
            this.precision = precision;
            this.scale = scale;
            this.intPartMaxLength = precision - scale;
            this.decimalPartMaxLength = scale;
            this.outputFormat = outputFormat;

            this.filter = new NumberFilter<decimal?>(this.precision, this.scale);
            this.validator = createDefaultValidator();

            setupMaxLength();
            setupValidPattern();
            setupOutputFormat();
        }
        /// <summary>
        /// ̗vpeBݒ肵ē͏Ȃǂ\zB
        /// </summary>
        /// <param name="property"></param>
        /// <param name="outputFormat">\ptH[}bg</param>
        public void setup(FieldProperty property, string outputFormat)
        {
            this.precision = property.Precision;
            this.scale = property.Scale;
            this.intPartMaxLength = precision - scale;
            this.decimalPartMaxLength = scale;
            this.outputFormat = outputFormat;


            this.filter = new NumberFilter<decimal?>(this.precision, this.scale);
            this.validator = FieldValidator.GetInstance(property);

            setupMaxLength();
            setupValidPattern();
            setupOutputFormat();
        }
        private void setupMaxLength()
        {
            int maxLength = intPartMaxLength + (intPartMaxLength / 3) + (decimalPartMaxLength == 0 ? 0 : decimalPartMaxLength + 1) + 1;
            theControl.MaxLength = maxLength;
        }
        /// <summary>
        /// {IȌ؃IuWFNg쐬
        /// </summary>
        /// <returns></returns>
        private FieldValidator createDefaultValidator()
        {
            FieldProperty property = FieldProperty.NewInstance("decimal", "", theControl.Name, "", 0, precision, scale, true, 0, false);
            FieldValidator validator = FieldValidator.GetInstance(property);
            return validator;
        }
        private void setupOutputFormat()
        {
            if (outputFormat != "") return;

            string intPartFormat = OFW.Util.StringUtil.Repeat("#", intPartMaxLength);
            string decimalPartForamt = OFW.Util.StringUtil.Repeat("#", decimalPartMaxLength);
            string formatString = intPartFormat + (decimalPartMaxLength > 0 ? "." + decimalPartForamt : "");
            outputFormat = formatString;

        }
        /// <summary>
        /// ͉\ȕp^[\z
        /// </summary>
        private void setupValidPattern()
        {
            string integerPartPattern = string.Format( @"\-?[\d]{{0,{0}}}",intPartMaxLength);
            string decimalPartPattern = string.Format(@"\.[\d]{{0,{0}}}", decimalPartMaxLength);
            string pattern = integerPartPattern;
            if (decimalPartMaxLength > 0) pattern += "(" + decimalPartPattern + ")?";
            validPattern = new Regex("^"+ pattern + "$");
        }

        /// <summary>
        /// Rg[̒l荞
        /// </summary>
        public override void UpdateField()
        {
            this.theValue = this.filter.FilterValue(this.theControl.Text);

        }
        /// <summary>
        /// \
        /// </summary>
        public override void Render()
        {
            if (this.isValid)
            {
                
                 this.theControl.Text = formatValue(theValue);
            }
            else
            {
                this.theControl.Text = OFW.Util.StringUtil.StringValue(this.theValue);
            }
        }
        /// <summary>
        /// w̒l݂̃[ɊÂtH[}bgB
        /// </summary>
        /// <param name="value">tH[}bgl</param>
        /// <returns></returns>
        private string formatValue(object value)
        {
            string formatted = "";
            if (this.outputFormat == "") formatted = OFW.Util.StringUtil.StringValue(value);
            else
            {
                string sfFormatString = "{0:" + this.outputFormat + "}";
                formatted = string.Format(sfFormatString, value);
            }
            return formatted;
        }
        /// <summary>
        /// tH[JXAEgɃtB^[Kp邩
        /// </summary>
        public override bool FilterOnBlur
        {
            get
            {
                return base.FilterOnBlur;
            }
            set
            {
                base.FilterOnBlur = value;
                if(filterOnBlur) this.theControl.Leave += blurHandler;
            }
        }
        /// <summary>
        /// tH[JXAEg̃tB^[Kp
        /// </summary>
        /// <param name="sender">CxgM</param>
        /// <param name="e">Cxg</param>
        protected void blurHandler(object sender, EventArgs e)
        {
            this.theControl.Text = formatValue( this.filter.FilterValue(this.theControl.Text) );
        }
        /// <summary>
        /// Cxgnh[̓Rg[ɕRt
        /// </summary>
        private void attachHandlers()
        {

            this.theControl.KeyDown += keyDownHandler;
            this.theControl.KeyPress += keyPressHandler;
            this.theControl.Validating += validatingHandler;
        }
        /// <summary>
        /// L[
        /// </summary>
        /// <param name="sender">CxgM</param>
        /// <param name="e">Cxg</param>
        private void keyDownHandler(object sender, System.Windows.Forms.KeyEventArgs e)
        {
        }
        /// <summary>
        /// L[(́ARg[ɑ΂鐧䕶͂Ȃ)
        /// </summary>
        /// <param name="sender">CxgM</param>
        /// <param name="e">Cxg</param>
        private void keyPressHandler(object sender, System.Windows.Forms.KeyPressEventArgs e)
        {
            if (isControlChar(e.KeyChar)) return;

            string newCharString = (new string(e.KeyChar, 1));
            if (!isAcceptable(newCharString))
            {
                e.Handled = true;
                return;
            }
            TextBox currentControl = (TextBox)sender;
            string currentString = currentControl.Text;
            string newString = currentString.Substring(0, currentControl.SelectionStart) + newCharString + currentString.Substring(currentControl.SelectionStart + currentControl.SelectionLength);

            if (!isValidPattern(newString))
            {
                e.Handled = true;
                return;
            }

            decimal? newValue = OFW.Util.NumberUtil.Parse<decimal?>(newString);
            System.Diagnostics.Trace.WriteLine("value    : " + newValue.ToString());
        }
        /// <summary>
        /// ͕䕶𔻒肷
        /// </summary>
        /// <param name="code">͕R[h</param>
        /// <returns>͕䕶̏ꍇtrue</returns>
        private bool isControlChar(char code)
        {
            int needle = (int)code;
            if (needle == (int)ControlChars.BACKSPACE) return true;
            if (needle == (int)ControlChars.CTRL_A) return true;
            if (needle == (int)ControlChars.CTRL_C) return true;
            if (needle == (int)ControlChars.CTRL_V) return true;
            if (needle == (int)ControlChars.CTRL_X) return true;
            if (needle == (int)ControlChars.CTRL_Z) return true;

            return false;
        }
        /// <summary>
        /// ͕͉\肷
        /// </summary>
        /// <param name="newCharString">͕</param>
        /// <returns>͉\Ȃtrue</returns>
        private bool isAcceptable(string newCharString)
        {
            return acceptableCharPattern.IsMatch(newCharString);
          
        }
        /// <summary>
        /// ͐̃p^[Ɉv邩肷
        /// </summary>
        /// <param name="newString">ΏہBʏ́uKeyPressɗ\z͕v</param>
        /// <returns></returns>
        private bool isValidPattern(string newString)
        {
            return validPattern.IsMatch(newString.Replace(",",""));
        }
        /// <summary>
        /// source̒needle邩
        /// </summary>
        /// <param name="source"></param>
        /// <param name="needle">T</param>
        /// <returns></returns>
        private int countString(string source, string needle)
        {
            int count = 0;
            int position = source.IndexOf(needle);
            while (position >= 0)
            {
                count++;
                position = source.IndexOf(needle, position + needle.Length);
            }
            return count;
        }
        /// <summary>
        /// Windows.FormsvalidatingCxg̃nh
        /// <para>CxgIuWFNgCancel^ɂƃtH[JXړ𐧌ł邪AtH[鎖oȂȂ̂łł͓͒lătH[}bg邾</para>
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void validatingHandler(object sender, CancelEventArgs e)
        {
            decimal? d = (decimal?)filter.FilterValue(theControl.Text);
            theControl.Text = formatValue(d);
        }

    }
}
