using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;
using System.Threading;

namespace OFW.Windows.ErrorHandler
{
    /// <summary>
    /// AvP[VG[̃nhOsB
    /// </summary>
    /// <example>WindowsFormsAvP[V̏ꍇ.<code>static class Program
    /// {
    ///     /// <summary>
    ///         /// AvP[ṼC Gg |CgłB
    ///         /// </summary>
    ///         [STAThread]
    ///         static void Main()
    ///         {
    ///             //G[nh[̐ݒ
    ///             OFW.Windows.ErrorHandler.ApplicationErrorHandler.SetUp(
    ///                 new OFW.Windows.ErrorHandler.DefaultApplicationErrorHandler("OTv")
    ///                 );
    /// 
    ///             Application.EnableVisualStyles();
    ///             Application.SetCompatibleTextRenderingDefault(false);
    ///             Application.Run(new Form1());
    ///         }
    ///     }
    /// </code>
    /// </example>
    /// <remarks>Program#Main̊JnApplicationErrorHandler̎NXnh[ƂĐݒ肷B
    /// ftHg(DefaultApplicationErrorHandler)ł͈ȉ̃tH[}bgbZ[W{bNX\
    /// <list type="table">
    /// <listheader><term></term><description>e</description></listheader>
    /// <item><term>^Cg</term><description>AvP[V</description></item>
    /// <item><term>bZ[W</term><description>AvP[VO܂B(s)(s) + ObZ[W</description></item>
    /// <item><term>ACR</term><description>G[</description></item>
    /// <item><term>{^</term><description>OK{^̂</description></item>
    /// </list>
    /// <p>\`ύXɂApplicationErrorHandlerpShowErrorMessage\bhB </p>
    /// <p>Webł͎gȂB</p>
    /// </remarks>
    public abstract class ApplicationErrorHandler
    {
        /// <summary>
        /// AvP[VB
        /// O͎QƂłȂB\zȂǂŐݒ肵Ă
        /// </summary>
        protected string applicationName;
        /// <summary>
        /// ftHg\z
        /// AvP[VEXE̖OB
        /// </summary>
        public ApplicationErrorHandler()
        {
            this.applicationName = AppDomain.CurrentDomain.FriendlyName;
        }
        /// <summary>
        /// AvP[Vw肷\z
        /// </summary>
        /// <param name="applicationName">AvP[V</param>
        public ApplicationErrorHandler(string applicationName)
        {
            this.applicationName = applicationName;
        }
        /// <summary>
        /// ݒ
        /// </summary>
        /// <param name="handler">{nh[</param>
        public static void SetUp(ApplicationErrorHandler handler)
        {
            // ThreadExceptionCxgEnho^
            Application.ThreadException += new ThreadExceptionEventHandler(handler.Application_ThreadException);

            // UnhandledExceptionCxgEnho^
            Thread.GetDomain().UnhandledException += new UnhandledExceptionEventHandler(handler.Application_UnhandledException);
        }
        /// <summary>
        /// OLb`CxgEnh
        /// iWindowsAvP[Vpj
        /// </summary>
        /// <param name="sender">M</param>
        /// <param name="e">Cxg</param>
        public void Application_ThreadException(object sender, ThreadExceptionEventArgs e)
        {
            OFW.ErrorHandler.ErrorMessageBuilder handler = OFW.ErrorHandler.ErrorMessageBuilderFactory.GetInstance(e.Exception);
            handler.WriteLog();
            this.ShowErrorMessage(handler);
        }

        /// <summary>
        /// OLb`CxgEnh
        /// iɃR\[EAvP[Vpj
        /// </summary>
        /// <param name="sender">M</param>
        /// <param name="e">Cxg</param>
        public void Application_UnhandledException(object sender, UnhandledExceptionEventArgs e)
        {
            Exception ex = e.ExceptionObject as Exception;
            if (ex != null)
            {
                OFW.ErrorHandler.ErrorMessageBuilder handler = OFW.ErrorHandler.ErrorMessageBuilderFactory.GetInstance(ex);
                handler.WriteLog();
                this.ShowErrorMessage(handler);
            }
        }

        /// <summary>
        /// ObZ[W\
        /// </summary>
        /// <param name="builder">IWinh[̗Onh[</param>
        public abstract void ShowErrorMessage(OFW.ErrorHandler.ErrorMessageBuilder builder);
    }
}
