using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Security.Permissions;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.Design;
using System.IO;
using System.Text;

namespace OFW.WebControls
{
    /// <summary>
    /// YUI.widget.Panelg
    /// </summary>
    public class PopupPanel : OverlayPanel
    {
        private string _helpUrl;
        /// <summary>
        /// HELPURL
        /// </summary>
        public string HelpUrl
        {
            get { return _helpUrl; }
            set { _helpUrl = value; }
        }
        /// <summary>
        /// HELPJWindow^[Qbg
        /// </summary>
        private string _helpWindowTarget;

        /// <summary>
        /// HELPJWindow^[Qbg
        /// </summary>
        public string HelpWindowTarget
        {
            get { return _helpWindowTarget; }
            set { _helpWindowTarget = value; }
        }
        private bool _showCloseButton;
        /// <summary>
        /// {^LE
        /// </summary>
        public bool ShowCloseButton
        {
            get { return _showCloseButton; }
            set { _showCloseButton = value; }

        }
        private bool _modal;
        /// <summary>
        /// [_ƂĊJ
        /// </summary>
        public bool Modal
        {
            get { return _modal; }
            set { _modal = value; }
        }
        private bool _draggable;
        /// <summary>
        /// hbO\
        /// </summary>
        public bool Draggable
        {
            get { return _draggable; }
            set { _draggable = value; }
        }
        private string _underlay;
        /// <summary>
        /// eA}bg
        /// </summary>
        public string Underlay
        {
            get { return _underlay; }
            set { _underlay = value; }
        }
        /// <summary>
        /// \z
        /// </summary>
        public PopupPanel()
        {
            this._helpUrl = "";
            this._helpWindowTarget = "";
            this._showCloseButton = true; //
            this._modal = false;
            this._draggable = true;
            this._constraintViewport = false;
            this._fixedCenter = false;
            this._underlay = "matte";
            this._jsClassName = "CJS.widget.PopupPanel";

        }
        /// <summary>
        /// qvf쐬
        /// </summary>
        protected override void CreateChildControls()
        {
            base.CreateChildControls();
            //base panel
            Panel basePanel =(Panel)base.FindControl("BasePanel");
            basePanel.CssClass = "popuppanel";
            //controlBoxZbgAbvB
            Panel headerPanel = (Panel)basePanel.FindControl("HeaderPanel");
            System.Web.UI.WebControls.Panel controlBox = new System.Web.UI.WebControls.Panel();
            controlBox.CssClass = "cbox";

            if (_helpUrl != "")
            {
                System.Web.UI.WebControls.Panel helpButton = new System.Web.UI.WebControls.Panel();
                helpButton.CssClass = "help";
                helpButton.ID = "helpButton";
                System.Web.UI.HtmlControls.HtmlAnchor a = new System.Web.UI.HtmlControls.HtmlAnchor();
                a.HRef = _helpUrl;
                a.Attributes["class"] = "helplink";
                a.Title = "wv";
                a.Target = _helpWindowTarget;
                Literal anchorText = new Literal();
                anchorText.Text = "&nbsp;";
                a.Controls.Add(anchorText);
                helpButton.Controls.Add(a);
                controlBox.Controls.Add(helpButton);
            }
            if (_showCloseButton)
            {
                System.Web.UI.WebControls.Panel closeButton = new System.Web.UI.WebControls.Panel();
                closeButton.CssClass = "closebutton";
                closeButton.ID = "closeButton";
                controlBox.Controls.Add(closeButton);
            }
            headerPanel.Controls.Add(controlBox);




        }
        /// <summary>
        /// renderO
        /// </summary>
        /// <param name="e"></param>
        protected override void OnPreRender(System.EventArgs e)
        {
            Panel basePanel = (Panel)base.FindControl("BasePanel");

            string varPopup = @"var {0} = $create( {1} , {{ controlId :""{2}"",helpUrl: ""{3}"" ,helpWindowTarget : ""{4}"",   config : {{modal : {5}, draggable : {6},close : false,underlay : ""{7}"" ,constraintoviewport   : {8},fixedcenter : {9}  }}}},  null, null, $get(""{10}""));";
            string fff = string.Format(varPopup,
                this.ClientID,
                this.JsClassName,
                this.ClientID, 
                this._helpUrl,
                this._helpWindowTarget,
                (this._modal ? "true" : "false"),
                (this._draggable ? "true" : "false"),
                this._underlay,
                (this._constraintViewport ? "true" : "false"),
                (this._fixedCenter ? "true" : "false"),
                basePanel.ClientID
                );
            this.Page.ClientScript.RegisterStartupScript(this.GetType(), this.ClientID, fff, true);


            base.OnPreRender(e);
        }
    }
}
