using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using OFW.Util;
using OFW.FieldProperties;
using OFW.Database;
using OFW.Models;
using OFW.Web.Auth.Model;

namespace OFW.Web.Auth.Model
{
    /// <summary>
    /// table auth_auto_login Field`
    /// </summary>
    [Serializable()]
    public class AuthAutoLoginTableRow : Entity,ICloneable
    {
        ///<summary>[login_id]</summary>
        protected string _LoginId;
        ///<summary>[login_id]</summary>
        public string LoginId{
            get{return _LoginId;}
            set{_LoginId = value;}
        }
        ///<summary>[random_key]</summary>
        protected string _RandomKey;
        ///<summary>[random_key]</summary>
        public string RandomKey{
            get{return _RandomKey;}
            set{_RandomKey = value;}
        }
        ///<summary>[identity_data_type]</summary>
        protected string _IdentityDataType;
        ///<summary>[identity_data_type]</summary>
        public string IdentityDataType{
            get{return _IdentityDataType;}
            set{_IdentityDataType = value;}
        }
        ///<summary>[identity_data]</summary>
        protected string _IdentityData;
        ///<summary>[identity_data]</summary>
        public string IdentityData{
            get{return _IdentityData;}
            set{_IdentityData = value;}
        }
        ///<summary>[expire_date]</summary>
        protected object _ExpireDate;
        ///<summary>[expire_date]</summary>
        public object ExpireDate{
            get{return _ExpireDate;}
            set{_ExpireDate = value;}
        }
        
        /// <summary>
        /// default construct 
        /// </summary>
        public AuthAutoLoginTableRow() : base()
        {
            this._LoginId = "";
            this._RandomKey = "";
            this._IdentityDataType = "";
            this._IdentityData = "";
            this._ExpireDate = null;
            
        }
        
        /// <summary>
        /// 񖼂w肵Ēlݒ
        /// </summary>
        /// <param name="name"></param>
        /// <param name="value"></param>
        public override void SetValue(string name,object value)
        {
            if(name ==  "login_id") this._LoginId = StringUtil.StringValue( value );
            if(name ==  "random_key") this._RandomKey = StringUtil.StringValue( value );
            if(name ==  "identity_data_type") this._IdentityDataType = StringUtil.StringValue( value );
            if(name ==  "identity_data") this._IdentityData = StringUtil.StringValue( value );
            if(name ==  "expire_date") this._ExpireDate = DateUtil.DateValue( value );
            
        }
        /// <summary>
        /// 񖼂w肵Ēl擾
        /// </summary>
        /// <param name="name"></param>
        public override object GetValue(string name)
        {
            if(name ==  "login_id") return this._LoginId;
            if(name ==  "random_key") return this._RandomKey;
            if(name ==  "identity_data_type") return this._IdentityDataType;
            if(name ==  "identity_data") return this._IdentityData;
            if(name ==  "expire_date") return this._ExpireDate;
            
            return null;
        }
        
        /// <summary>
        /// N[
        /// </summary>
        /// <return >̃IuWFNg̃N[</return>
        public virtual object Clone()
        {
            AuthAutoLoginTableRow clone = new AuthAutoLoginTableRow();
            clone.CopyFrom(this);
            return clone;
        }
        /// <summary>
        /// N[
        /// </summary>
        /// <return >̃IuWFNg̃N[</return>
        public virtual void CopyFrom(AuthAutoLoginTableRow source)
        {
            this.LoginId = source.LoginId;
            this.RandomKey = source.RandomKey;
            this.IdentityDataType = source.IdentityDataType;
            this.IdentityData = source.IdentityData;
            this.ExpireDate = source.ExpireDate;
            
        }
    }

}