using System;
using System.Collections.Generic;
using System.Text;
using System.Web;
using System.Web.Security;
using System.Security;
using System.Security.Principal;
namespace OFW.Web.Auth
{
    /// <summary>
    /// webF؋@\
    /// </summary>
    public class Authentication
    {
        /// <summary>
        /// F؏
        /// </summary>
        /// <param name="loginId"></param>
        /// <param name="password"></param>
        /// <returns></returns>
        public bool Authenticate(string loginId, string password)
        {
            HttpContext context = HttpContext.Current;
            OFW.Auth.AuthProvider provider = OFW.Auth.AuthProviderFactory.GetInstance();
            if (!provider.Authenticate(loginId, password)) return false;

            OFW.Auth.Identity id = provider.GetIdentity();
            string roles = "";
            foreach (OFW.Acl.IAclRole role in id.Roles)
            {
                if (roles.Length > 0) roles += "|";
                roles += role.name;
            }
            //`PbgƂ
            // F؃`Pbg̍쐬
            // web.config<forms timeout="..." />͎QƂȂ
            //TODO: ^CAEg̐ݒ擾
            FormsAuthenticationTicket ticket = new FormsAuthenticationTicket(
              1,
              id.Name,
              DateTime.Now,
              DateTime.Now.AddMinutes(1),
              true,
              roles);

            // `PbgNbL[ɁBNbL[<forms name="..." />Q
            // <forms protection="..." />͎QƂňÍ
            HttpCookie cookie = new HttpCookie(
              FormsAuthentication.FormsCookieName,
              FormsAuthentication.Encrypt(ticket));

            // iw肳ꂽANbL[̗L50Nɐݒ
            cookie.Expires = DateTime.Now.AddYears(50);
            context.Response.Cookies.Add(cookie);

            return true;
        }
        /// <summary>
        /// F؏擾
        /// </summary>
        /// <returns>F؏</returns>
        public OFW.Auth.Identity GetIdentity()
        {
            OFW.Auth.AuthProvider provider = OFW.Auth.AuthProviderFactory.GetInstance();
            
            return provider.GetIdentity();
        }
        /// <summary>
        /// F؃NGXg̏
        /// </summary>
        public void AuthenticateRequest()
        {
            HttpContext context = HttpContext.Current;
            //̓Tv
            String cookieName = FormsAuthentication.FormsCookieName;
            HttpCookie authCookie = context.Request.Cookies[cookieName];
            if (null == authCookie)
            {//There is no authentication cookie.
                return;
            }


            FormsAuthenticationTicket authTicket = null;

            authTicket = FormsAuthentication.Decrypt(authCookie.Value);

            if (null == authTicket)
            {//Cookie failed to decrypt.
                return;
            }

            //When the ticket was created, the UserData property was assigned a
            //pipe-delimited string of group names.
            String[] groups = authTicket.UserData.Split(new char[] { '|' });

            //Create an Identity.
            GenericIdentity id = new GenericIdentity(authTicket.Name, "FormsAuthentication");

            //This principal flows throughout the request.
            GenericPrincipal principal = new GenericPrincipal(id, groups);

            context.User = principal;

        }
        /// <summary>
        /// OAEg
        /// </summary>
        public void LogOut()
        {
            HttpContext context = HttpContext.Current;
            OFW.Auth.AuthProvider provider = OFW.Auth.AuthProviderFactory.GetInstance();
            provider.Logout();
            FormsAuthentication.SignOut();
        }
    }
}
