using System;
using System.Collections.Generic;
using System.Text;

namespace OFW.Database.Expressions
{
    /// <summary>
    /// 
    /// </summary>
    public class ComplexCondition : Expression
    {
        /// <summary>
        /// ̃Xg
        /// </summary>
        protected List<Expression> expressions;
        string modifier;
        /// <summary>
        /// \z
        /// </summary>
        public ComplexCondition() : base()
        {
            expressions = new List<Expression>();
            modifier = "";
        }
        /// <summary>
        /// NOT ݒ(̎Sے)
        /// </summary>
        /// <returns></returns>
        public ComplexCondition not()
        {
            modifier = Expression.NOT;
            return this;
        }
        /// <summary>
        /// ǉ
        /// </summary>
        /// <param name="expr"></param>
        /// <returns></returns>
        public ComplexCondition add(Expression expr)
        {
            if (expressions.Count > 0) expressions.Add(new AndOperator());
            expressions.Add(expr);
            return this;
        }
        /// <summary>
        /// ǉ
        /// </summary>
        /// <param name="expr"></param>
        /// <returns></returns>
        public ComplexCondition and(Expression expr)
        {
            if (expressions.Count > 0) expressions.Add(new AndOperator());
            expressions.Add(expr);
            return this;
        }
        /// <summary>
        /// ǉ
        /// </summary>
        /// <param name="expr"></param>
        /// <returns></returns>
        public ComplexCondition or(Expression expr)
        {
            if (expressions.Count > 0) expressions.Add(new OrOperator());
            expressions.Add(expr);
            return this;
        }
        /// <summary>
        /// gݗ
        /// </summary>
        public override void buildExpression()
        {
            StringBuilder builder = new StringBuilder();
            if (!string.IsNullOrEmpty(modifier))
            {
                builder.Append(modifier);
                builder.Append(" ");
            }
            
            builder.Append("( ");
            foreach (Expression expr in expressions)
            {
                expr.buildExpression();
                builder.Append(expr.getExpression());
                parameters.AddRange(expr.getParameters());
            }
            builder.Append(" )");

            builtExpression = builder.ToString();
        }
    }
}
