using System;
using System.Collections.Generic;
using System.Text;
using OFW.Models;
using OFW.Database.Conditions;
using OFW.Database.CommandBuilder;
namespace OFW.Database
{
    /// <summary>
    /// f[^\[X@\  via OFW.php
    /// </summary>
    /// <typeparam name="TEntity">GeBeB̌^</typeparam>
    /// <remarks>GeBeBɑ΂{Iȑ񋟂B
    /// <p>vpeBmodifiedAtField,createdAtFieldݒ肳Ă΂ꂼXVA}ɃVXeԂݒ肷B</p></remarks>
    /// <example>
    /// w肵đΏۃf[^ǂݍ
    /// <code>
    /// DataSource&lt;TestTable3Entity> datasource = DataSourceFactory.getDataSource&lt;TestTable3Entity>("default");
    /// TestTable3Property property = new TestTable3Property();
    /// datasource.setProperty(property);
    ///
    /// OFW.Database.Criteria c = new OFW.Database.Criteria();
    /// c.AddWhere(new ColumnValueCondition(property.field1,2,"="));
    ///
    /// datasource.connect();
    /// List&lt;TestTable3Entity> entities = datasource.find(c);
    /// datasource.disconnect();
    /// </code>
    /// GeBeBɕKvȃf[^ݒ肵ĕۑ
    /// <code>TestTable3Entity entity = new TestTable3Entity();
    /// entity.field1 = 1001;
    /// entity.field2 = "testdata1";
    /// entity.field3 = OFW.Util.DateUtil.DateValue("2199/1/2 12:59");
    /// entity.field4 = 12345678.12M;
    /// entity.field5 = 11;
    /// entity.field6Sub1 = 10000001;
    /// entity.field6Sub2 = 100000001;
    /// entity.IsNew = true;
    /// entity.IsModified = true;
    /// 
    /// DataSource&lt;TestTable3Entity> datasource = DataSourceFactory.getDataSource&lt;TestTable3Entity>("default");
    /// TestTable3Property property = new TestTable3Property();
    /// datasource.setProperty(property);
    ///
    /// datasource.connect();
    /// int result  = datasource.save(entity);
    /// datasource.disconnect();
    /// </code>
    /// 
    /// </example>
    public class DataSource<TEntity> where TEntity : Entity, new()
    {
        private Connection connection;
        private EntityProperty property;
        /// <summary>
        /// ftHgRXgN^BDataSourceFactorỹRXgN^ɃANZX邽߂publicɂȂĂ邪ʓIɎgpsB
        /// </summary>
        public DataSource()
        {

        }
        /// <summary>
        /// 
        /// </summary>
        /// <param name="con"></param>
        public DataSource(Connection con)
        {
            setConnection(con);
        }
        /// <summary>
        /// ڑƎgpvpeB󂯎č\z
        /// </summary>
        /// <param name="con"></param>
        /// <param name="prop"></param>
        public DataSource(Connection con, EntityProperty prop)
        {
            setConnection(con);
            setProperty(prop);

        }
        /// <summary>
        /// f[^ڑJ
        /// </summary>
        public void connect()
        {
            if (connection == null)
            {
                connection = ConnectionFactory.GetConnectionByName("default");
            }
            connection.Open();
        }
        /// <summary>
        /// f[^ڑ
        /// </summary>
        public void disconnect()
        {
            connection.Close();
            connection = null;
        }
        /// <summary>
        /// vpeBݒ肷
        /// </summary>
        /// <param name="prop">ΏۃvpeB</param>
        public void setProperty(EntityProperty prop)
        {
            this.property = prop;
        }
        /// <summary>
        /// Of[^ڑݒ肷B
        /// </summary>
        /// <param name="con">̃f[^ڑ</param>
        public void setConnection(Connection con)
        {
            this.connection = con;
        }
        /// <summary>
        /// GeBeB(1)ۑB
        /// </summary>
        /// <param name="entity">ۑΏۂ̃GeBeB</param>
        /// <returns>ۑɐ1ȏ</returns>
        /// <remarks>isDeleted̂Ƃ폜(폜)AisModifiedłisNew̏ꍇǉAisModifiedisNewłȂƂXVƂȂBf[^̑݃`FbNsĒǉXV𕪂@\͖</remarks>
        public int save(TEntity entity)
        {
            return save(new TEntity[] { entity });
        }

        /// <summary>
        /// GeBeB()ۑB
        /// </summary>
        /// <param name="entities">ۑɐ1ȏ</param>
        /// <remarks>isDeleted̂Ƃ폜(폜)AisModifiedłisNew̏ꍇǉAisModifiedisNewłȂƂXVƂȂBf[^̑݃`FbNsĒǉXV𕪂@\͖</remarks>
        public int save(IEnumerable<TEntity> entities)
        {
            int result = 0;
            List<Command> commands = new List<Command>();
            foreach (TEntity entity in entities)
            {
                if (entity.IsDeleted)
                {
                    Command command = BuildDeleteCommand(entity);
                    commands.Add(command);
                }
                else
                {
                    if (entity.IsModified)
                    {
                        if (entity.IsNew)
                        {
                            Command command = BuildInsertCommand(entity);
                            commands.Add(command);
                        }
                        else
                        {
                            Command command = BuildUpdateCommand(entity);
                            commands.Add(command);
                        }
                    }
                }
            }
            result = connection.ExecuteUpdateBatch(commands.ToArray());
            return result;
        }
        /// <summary>
        /// GeBeB
        /// </summary>
        /// <param name="c"></param>
        /// <returns>ɊYGeBeB̃XgBΏۂȂꍇ̃Xg</returns>
        public List<TEntity> find(Criteria c)
        {
            List<TEntity> list = new List<TEntity>();

            Command command = BuildSelectCommand(c);
            list = connection.ExecuteQueryAsTableRows<TEntity>(command);


            return list;
        }

        /// <summary>
        /// GeBeB
        /// </summary>
        /// <param name="c"></param>
        /// <param name="associations">̃e[uɑ΂֘Aw</param>, 
        /// <returns>ɊYGeBeB̃XgBΏۂȂꍇ̃Xg</returns>
        public List<TEntity> find(Criteria c,IEnumerable<Association> associations )
        {
            return find(c,associations,2);
        }
        /// <summary>
        /// GeBeB
        /// </summary>
        /// <param name="c"></param>
        /// <param name="associations">̃e[uɑ΂֘Aw</param>
        /// <param name="associationDepth">֘A̐[</param>
        /// <returns>ɊYGeBeB̃XgBΏۂȂꍇ̃Xg</returns>
        public List<TEntity> find(Criteria c, IEnumerable<Association> associations,int associationDepth)
        {
            List<TEntity> list = new List<TEntity>();

            AssociationSelect<TEntity> select = new AssociationSelect<TEntity>(connection);
            select.from(property);
            select.associationDepth = associationDepth;
            foreach (Association association in associations)
            {
                select.associate(association);
            }
            select.setCriteria(c);
            list = select.queryAsEntity();


            return list;
        }
        /// <summary>
        /// L[ɊYGeBeB𓾂
        /// </summary>
        /// <param name="keyEntity">L[ݒ肵GeBeB</param>
        /// <returns>YGeBeB</returns>
        public virtual TEntity findByPk(TEntity keyEntity)
        {
                Criteria c = new Criteria();
                foreach (FieldProperties.FieldProperty p in property.PrimaryKeys())
                {
                    c.AddWhere(new Conditions.ColumnValueCondition(p, keyEntity.GetValue(p.FieldName), "="));
                }

                List<TEntity> list = find(c);
                if (list.Count > 0)
                {
                    return list[0];
                }
                return null;
        }
        /// <summary>
        /// L[ɊYGeBeB𓾂
        /// </summary>
        /// <param name="keyEntity">L[ݒ肵GeBeB</param>
        /// <returns>YGeBeB</returns>
        public virtual bool exists(TEntity keyEntity)
        {
            TEntity entity = findByPk(keyEntity);
            return (entity != null);

        }

        /// <summary>
        /// y[WO
        /// </summary>
        /// <param name="c"></param>
        /// <param name="max">ő匏BɐĂAĂȂȂ炱̎</param>
        /// <returns>ɊYGeBeB̃XgBΏۂȂꍇ̃Xg</returns>
        public List<TEntity> pagenate(Criteria c,int max)
        {
            List<TEntity> list = new List<TEntity>();
 
            int limit = c.limit;
            int offset = c.offset;
            if (max == 0)
            {
                if ((offset + limit) > count(c))
                {
                    limit = count(c) - offset + 1;
                }
            }
            else
            {
                if ((offset + limit) > max)
                {
                    limit = count(c) - offset + 1;
                }
            }
            c.limit = limit;
            c.offset = offset;
            Command command = BuildPagedSelectCommand(c);
            list = connection.ExecuteQueryAsTableRows<TEntity>(command);


            return list;
        }
        /// <summary>
        /// wɊYGeBeB̌𐔂
        /// </summary>
        /// <param name="c"></param>
        /// <returns>Y(0ȏ)</returns>
        public int count(Criteria c)
        {
            Command command = BuildCountCommand(c);
            int result = OFW.Util.NumberUtil.IntValue( connection.ExecuteScalar(command) );


            return result;
        }
        /// <summary>
        /// wɊŶ݂邩`FbN
        /// </summary>
        /// <param name="c"></param>
        /// <returns>Y1ȏȂtrue</returns>
        public bool exists(Criteria c)
        {
            Command command = BuildExistsCommand(c);
            bool result = OFW.Util.NumberUtil.BoolValue(connection.ExecuteScalar(command));


            return result;
        }
        /// <summary>
        /// wGeBeBf[^ڑɑ݂邩
        /// </summary>
        /// <param name="entity">ΏۃGeBeBBPɑ݊mF邾ȂL[ݒ肵ĂΗǂ</param>
        /// <returns>݂Ȃtrue</returns>
        public bool entityExists(TEntity entity)
        {
            Command command = BuildExistsCommand(entity);
            bool result = OFW.Util.NumberUtil.BoolValue(OFW.Util.NumberUtil.IntValue(connection.ExecuteScalar(command)));


            return result;
        }
        /// <summary>
        /// GeBeBisModified,isNew̏ԂɊւ炸ǉ
        /// </summary>
        /// <param name="entity">ǉΏ</param>
        /// <returns>1ȏBOȊȌꍇɐ͂</returns>
        public int insert(TEntity entity)
        {
            Command command = BuildInsertCommand(entity);
            int result = connection.ExecuteUpdate(command);
            return result;
        }
        /// <summary>
        /// GeBeBisModified,isNew̏ԂɊւ炸ǉ
        /// </summary>
        /// <param name="entities">ǉΏۂ̃Xg</param>
        /// <returns>1ȏBOȊȌꍇɐ͂</returns>
        public int insert(IEnumerable<TEntity> entities)
        {
            int result = 0;
            List<Command> commands = new List<Command>();
            IEnumerator<TEntity> e = entities.GetEnumerator();
            while (e.MoveNext())
            {
                Command command = BuildInsertCommand(e.Current);
                commands.Add(command);
            }
            result = connection.ExecuteUpdateBatch(commands.ToArray());
            return result;
        }
        /// <summary>
        /// GeBeB̃f[^ɎwɊYSĂ̍sf[^XVB
        /// </summary>
        /// <param name="entity">XVf[^ݒ肵GeBeB</param>
        /// <param name="c">w</param>
        /// <returns>0̏ꍇ͊ŶB߂lƁuΏۂł͂̌v̓gK[⑼vZX̍XVA폜ɂvȂꍇB</returns>
        public int update(TEntity entity, Criteria c)
        {
            Command command = BuildUpdateCommand(entity,c);
            int result = connection.ExecuteUpdate(command);
            return result;
        }
        /// <summary>
        /// GeBeBisModified,isNew̏ԂɊւ炸XVB
        /// </summary>
        /// <param name="entity">ΏۃGeBeB</param>
        /// <returns>1ȏB0̏ꍇ͑Ώۂ݂ȂB</returns>
        public int update(TEntity entity)
        {
            Command command = BuildUpdateCommand(entity);
            int result = connection.ExecuteUpdate(command);
            return result;
        }
        /// <summary>
        /// GeBeBisModified,isNew̏ԂɊւ炸XVB
        /// </summary>
        /// <param name="entities">ΏۃGeBeB</param>
        /// <returns>1ȏB0̏ꍇ͑Ώۂ݂ȂB</returns>
        public int update(IEnumerable<TEntity> entities)
        {
            int result = 0;
            List<Command> commands = new List<Command>();
            IEnumerator<TEntity> e = entities.GetEnumerator();
            while (e.MoveNext())
            {
                Command command = BuildUpdateCommand(e.Current);
                commands.Add(command);
            }
            result = connection.ExecuteUpdateBatch(commands.ToArray());
            return result;
        }

        /// <summary>
        /// GeBeB̗񋓂폜
        /// </summary>
        /// <param name="entities"></param>
        /// <returns></returns>
        public int delete(IEnumerable<TEntity> entities)
        {
            int result = 0;
            List<Command> commands = new List<Command>();
            IEnumerator<TEntity> e = entities.GetEnumerator();
            while (e.MoveNext())
            {
                Command command = BuildDeleteCommand(e.Current);
                commands.Add(command);
            }
            result = connection.ExecuteUpdateBatch(commands.ToArray());
            return result;
        }
        /// <summary>
        /// ΏۃGeBeB폜
        /// </summary>
        /// <param name="entity"></param>
        /// <returns></returns>
        public int delete(TEntity entity)
        {
            Command command = BuildDeleteCommand(entity);
            int result = connection.ExecuteUpdate(command);
            return result;
        }
        /// <summary>
        /// ΏۏɃ}b`̂폜
        /// </summary>
        /// <param name="c"></param>
        /// <returns></returns>
        public int delete(Criteria c)
        {
            Command command = BuildDeleteCommand(c);
            int result = connection.ExecuteUpdate(command);
            return result;
        }
        /// <summary>
        /// insert sqlR}h
        /// </summary>
        /// <param name="entity">ǉf[^</param>
        public Command BuildInsertCommand(TEntity entity)
        {
            InsertCommandBuilder builder = new InsertCommandBuilder(connection);
            builder.into(property.EntityName);

            foreach(FieldProperties.FieldProperty p in property.Fields())
            {
                if (p.DoUpdate)
                {
                    if (p.FieldName == property.CreatedAtField)
                    {
                        builder.insert(p, DateTime.Now);
                    }
                    else if (p.FieldName == property.ModifiedAtField)
                    {
                        builder.insert(p, DateTime.Now);
                    }
                    else
                    {
                        builder.insert(p, entity.GetValue(p.FieldName));
                    }
                }
            }

            return builder.getCommand();
        }
        /// <summary>
        /// update sqlR}h(WHERE͎L[g)
        /// </summary>
        /// <param name="entity">ύXf[^</param>
        public Command BuildUpdateCommand(TEntity entity)
        {
            UpdateCommandBuilder builder = new UpdateCommandBuilder(connection);
            builder.table(property.EntityName);

            foreach (FieldProperties.FieldProperty p in property.Fields())
            {
                if (p.DoUpdate)
                {
                    if (p.FieldName == property.CreatedAtField)
                    {
                        continue;
                    }
                    else if (p.FieldName == property.ModifiedAtField)
                    {
                        builder.update(p, DateTime.Now);
                    }
                    else
                    {
                        builder.update(p, entity.GetValue(p.FieldName));
                    }
                    
                }
            }
            builder.setCriteria(buildPrimaryKeyCriteria(entity));

            return builder.getCommand();
        }

        /// <summary>
        /// XVSqlR}h(WHERE͊O炤)
        /// </summary>
        /// <param name="entity">ύXf[^</param>
        /// <param name="c">Ώۏ</param>
        public Command BuildUpdateCommand(TEntity entity, Criteria c)
        {
            c.assemble();
            UpdateCommandBuilder builder = new UpdateCommandBuilder(connection);
            builder.table(property.EntityName);

            foreach (FieldProperties.FieldProperty p in property.Fields())
            {
                if (!p.DoUpdate)
                {
                    continue;
                }
                if (p.FieldName == property.CreatedAtField)
                {
                    continue;
                }
                if (p.FieldName == property.ModifiedAtField)
                {
                    builder.update(p, entity.GetValue(p.FieldName));
                }
            }
            builder.setCriteria(c);

            return builder.getCommand();
        }

        /// <summary>
        /// delete sqlR}h(WHERE͊O炤
        /// </summary>
        /// <param name="c">Ώۏ</param>
        public Command BuildDeleteCommand(Criteria c)
        {
            c.assemble();
            DeleteCommandBuilder builder = new DeleteCommandBuilder(connection);
            builder.from(property.EntityName);
            builder.setCriteria(c);
            return builder.getCommand();
        }
        /// <summary>
        /// delete sqlR}h(WHERE͎L[g)
        /// </summary>
        /// <param name="entity">Ώۏ</param>
        public Command BuildDeleteCommand(TEntity entity)
        {
            DeleteCommandBuilder builder = new DeleteCommandBuilder(connection);
            builder.from(property.EntityName);
            builder.setCriteria(buildPrimaryKeyCriteria(entity));
            return builder.getCommand();
        }

        /// <summary>
        /// select count(*)(WHERE͎L[g)
        /// </summary>
        /// <param name="entity">Ώۏ</param>
        public Command BuildExistsCommand(TEntity entity)
        {

            SelectCommandBuilder builder = new SelectCommandBuilder(connection);
            builder.from(property.EntityName);
            builder.select("COUNT(*)", "CNT");
            builder.setCriteria(buildPrimaryKeyCriteria(entity));
            return builder.getCommand();

        }
        /// <summary>
        /// select count(*)(WHERE͎L[g)
        /// </summary>
        /// <param name="c">Ώۏ</param>
        public Command BuildExistsCommand(Criteria c)
        {
            return BuildCountCommand(c);

        }
        /// <summary>
        /// select count(*)(WHERE͎L[g)
        /// </summary>
        /// <param name="c">Ώۏ</param>
        public Command BuildCountCommand(Criteria c)
        {
            string query = "SELECT COUNT(*) AS CNT FROM {0}";
            c.assemble();
            if (!string.IsNullOrEmpty(c.whereExpression))
            {
                query += " WHERE " + c.whereExpression;
            }
            Command command = new Command(string.Format(query, connection.QuoteIdentifier(property.EntityName)), System.Data.CommandType.Text);
            command.Parameters.AddRange(c.parameters);
            return command;

        }

        /// <summary>
        /// select sqlR}h(WHERE͎L[g)
        /// </summary>
        /// <param name="entity">Ώۏ</param>
        public Command BuildSelectCommand(TEntity entity)
        {
            SelectCommandBuilder builder = new SelectCommandBuilder(connection);
            builder.from(property.EntityName);
            builder.select("*");
            builder.setCriteria(buildPrimaryKeyCriteria(entity));
            return builder.getCommand();

        }

        /// <summary>
        /// select sqlR}h(WHERE͊O炤)
        /// </summary>
        /// <param name="c">Ώۏ</param>
        public Command BuildSelectCommand(Criteria c)
        {

            SelectCommandBuilder builder = new SelectCommandBuilder(connection);
            builder.from(property.EntityName);
            builder.select(property.Fields());
            builder.setCriteria(c);
            return builder.getCommand();

        }
        /// <summary>
        /// select sqlR}h(WHERE͊O炤)
        /// </summary>
        /// <param name="c">Ώۏ</param>
        public Command BuildPagedSelectCommand(Criteria c)
        {
            c.assemble(Criteria.AssembleOption.WITH_ORDER_BY_REVERSE);
            int start = c.offset;
            int last = c.offset + c.limit - 1;

            StringBuilder b = new StringBuilder();

            //NG[
            b.Append("SELECT TOP " + last.ToString());
            b.Append(Environment.NewLine);
            b.Append(" ");
            b.Append(buildSelectListString(property.EntityName,property.EntityName + "__"));

            b.Append(string.Format(" FROM {0} ", property.EntityName));
            if (c.whereExpression != "") b.Append(" WHERE " + c.whereExpression);
            if (c.groupByExpression != "") b.Append(" GROUP BY " + c.groupByExpression);
            if (c.havingExpression != "") b.Append(" HAVING " + c.havingExpression);
            if (c.orderByExpression != "") b.Append(" ORDER BY " + c.orderByExpression);

            StringBuilder outer = new StringBuilder();
            outer.Append("SELECT TOP " + c.limit.ToString() + " * ");
            outer.Append(" FROM (");
            outer.Append(b.ToString());
            outer.Append(" ) as inner_table ");

            string reverse = c.reverseOrderByExpression;

            if (reverse != "")
            {
                outer.Append(" ORDER BY ");
                outer.Append(reverse.Replace(".", "__"));
            }

            string q = string.Format("SELECT * FROM ( {0} ) as outer_table order by {1}", outer.ToString(), c.orderByExpression.Replace(".", "__"));

            Command command = new Command(q);
            command.Parameters.AddRange(c.parameters);

            return command;
        }
        /// <summary>
        /// select sqlR}h(WHERE͊O炤)
        /// </summary>
        /// <param name="condition">Ώۏ</param>
        public OFW.Database.TableCommand.TableSelectCommand BuildCountCommand(OFW.Database.TableCommand.TableCommandCondition condition)
        {
            OFW.Database.TableCommand.TableSelectCommand command = new OFW.Database.TableCommand.TableSelectCommand(this.property.EntityName);
            command.AddSelect(new OFW.Database.TableCommand.TableCommandColumn("CNT", "COUNT(*)"));

            //XV`
            if (condition != null) command.AddWhere(condition);

            return command;
        }
        /// <summary>
        /// select list
        /// </summary>
        /// <param name="tableAlias">e[uɕtʖ</param>
        /// <param name="columnAliasPrefix">ɕtʖ̐ړ</param>
        public string buildSelectListString(string tableAlias, string columnAliasPrefix)
        {
            StringBuilder builder = new StringBuilder();
            foreach (FieldProperties.FieldProperty p in property.Fields())
            {

                builder.AppendLine(", " + tableAlias + "." + p.FieldName + " AS " + columnAliasPrefix + p.FieldName);
            }

            return builder.ToString().Substring(1);
        }
        /// <summary>
        /// 
        /// </summary>
        /// <param name="entity"></param>
        /// <returns></returns>
        protected Criteria buildPrimaryKeyCriteria(TEntity entity)
        {
            Criteria c = new Criteria();
            foreach (FieldProperties.FieldProperty p in property.PrimaryKeys())
            {
                //XV`
                c.AddWhere(new ColumnValueCondition(p, "@PK_" + p.FieldName, entity.GetValue(p.FieldName), "="));
            }
            return c;
        }

    }
}
